/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.app.WidgetCreator;
import org.nlogo.app.WidgetWrapper;
import org.nlogo.app.Zoomer;
import org.nlogo.awt.ImageSelection;
import org.nlogo.awt.Utils;
import org.nlogo.event.CompileAllEvent;
import org.nlogo.event.DirtyEvent;
import org.nlogo.event.EditWidgetEvent;
import org.nlogo.event.ExportInterfaceEvent;
import org.nlogo.event.LoadBeginEvent;
import org.nlogo.event.LoadSectionEvent;
import org.nlogo.event.WidgetEditedEvent;
import org.nlogo.event.ZoomedEvent;
import org.nlogo.nvm.JobOwner;
import org.nlogo.swing.FileDialog;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.util.Exceptions;
import org.nlogo.util.UserCancelException;
import org.nlogo.util.Version;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.ChooserWidget;
import org.nlogo.window.Editable;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.GraphicsWidget;
import org.nlogo.window.GraphicsWidgetInterface;
import org.nlogo.window.InputBoxWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.OutputWidget;
import org.nlogo.window.SliderWidget;
import org.nlogo.window.SwitchWidget;
import org.nlogo.window.TextBoxWidget;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetContainer;
import org.nlogo.window.graphing.GraphManager;
import org.nlogo.window.graphing.GraphWidget;
import org.nlogo.workspace.ModelReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class InterfacePanel
extends JLayeredPane
implements WidgetContainer,
MouseListener,
MouseMotionListener,
FocusListener,
CompileAllEvent.Raiser,
EditWidgetEvent.Raiser,
DirtyEvent.Raiser,
WidgetEditedEvent.Handler,
LoadBeginEvent.Handler,
LoadSectionEvent.Handler,
ExportInterfaceEvent.Handler,
ZoomedEvent.Handler {
    private Rectangle selectionRect;
    private Point startDragPoint;
    private WidgetWrapper newWidget;
    private List widgetsBeingDragged;
    private GUIWorkspace workspace;
    private GraphManager graphManager;
    private GraphicsWidgetInterface graphicsWidget;
    final Zoomer zoomer;
    private final JComponent glassPane;
    private boolean hasFocus;
    private WidgetCreator widgetCreator;
    private boolean sliderEventOnReleaseOnly;

    public GraphicsWidgetInterface graphicsWidget() {
        return this.graphicsWidget;
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void requestFocus() {
        this.requestFocusInWindow();
    }

    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.enableButtonKeys(true);
    }

    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.enableButtonKeys(false);
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(false);
    }

    public Dimension getPreferredSize(boolean savingAsApplet) {
        int maxX = 0;
        int maxY = 0;
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] != this.glassPane) {
                Point location = comps[i].getLocation();
                Dimension size = comps[i].getSize();
                int x = location.x + size.width;
                int y = location.y + size.height;
                if (!savingAsApplet && comps[i] instanceof WidgetWrapper && !((WidgetWrapper)comps[i]).selected()) {
                    x += 9;
                    y += 9;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y > maxY) {
                    maxY = y;
                }
            }
            ++i;
        }
        if (!savingAsApplet && System.getProperty("os.name").startsWith("Mac") && System.getProperty("os.version").startsWith("10.2")) {
            maxX += 8;
            maxY += 8;
        }
        return new Dimension(maxX, maxY);
    }

    WidgetWrapper getWrapper(Widget widget) {
        return (WidgetWrapper)widget.getParent();
    }

    private final List selectedWrappers() {
        ArrayList<WidgetWrapper> result = new ArrayList<WidgetWrapper>();
        Component[] comps = this.getComponents();
        int i = 0;
        while (comps.length != i) {
            WidgetWrapper wrapper;
            if (comps[i] instanceof WidgetWrapper && (wrapper = (WidgetWrapper)comps[i]).selected()) {
                result.add(wrapper);
            }
            ++i;
        }
        return result;
    }

    void aboutToDragSelectedWidgets(int startPressX, int startPressY) {
        this.widgetsBeingDragged = new ArrayList();
        List selectedWrappers = this.selectedWrappers();
        int i = 0;
        while (i < selectedWrappers.size()) {
            WidgetWrapper w = (WidgetWrapper)selectedWrappers.get(i);
            w.startPressX = startPressX;
            w.startPressY = startPressY;
            w.aboutToDrag();
            this.widgetsBeingDragged.add(w);
            ++i;
        }
    }

    void dragSelectedWidgets(int x, int y) {
        WidgetWrapper w;
        Point p = new Point(x, y);
        int i = 0;
        while (i < this.widgetsBeingDragged.size()) {
            w = (WidgetWrapper)this.widgetsBeingDragged.get(i);
            p = this.restrictDrag(p, w);
            ++i;
        }
        i = 0;
        while (i < this.widgetsBeingDragged.size()) {
            w = (WidgetWrapper)this.widgetsBeingDragged.get(i);
            w.doDrag(p.x, p.y);
            ++i;
        }
    }

    private final Point restrictDrag(Point p, WidgetWrapper w) {
        int x = p.x;
        int y = p.y;
        Rectangle wb = w.originalBounds;
        Rectangle b = this.getBounds();
        Rectangle newWb = new Rectangle(wb.x + x, wb.y + y, wb.width, wb.height);
        if (newWb.x + newWb.width < 18) {
            x += 18 - (newWb.x + newWb.width);
        }
        if (newWb.y < 10) {
            y += 10 - newWb.y;
        }
        if (newWb.x + 18 > b.width) {
            x -= newWb.x + 18 - b.width;
        }
        if (newWb.y + 10 > b.height) {
            y -= newWb.y + 10 - b.height;
        }
        return new Point(x, y);
    }

    void dropSelectedWidgets() {
        int i = 0;
        while (i < this.widgetsBeingDragged.size()) {
            WidgetWrapper w = (WidgetWrapper)this.widgetsBeingDragged.get(i);
            w.doDrop();
            ++i;
        }
        this.widgetsBeingDragged = null;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (!Utils.button1Mask(e)) {
            return;
        }
        try {
            Point p = e.getPoint();
            Rectangle rect = this.getBounds();
            p.x += rect.x;
            p.y += rect.y;
            if (this.newWidget != null) {
                Point p2 = this.restrictDrag(new Point(e.getX() - this.startDragPoint.x, e.getY() - this.startDragPoint.y), this.newWidget);
                this.newWidget.setLocation(this.startDragPoint.x + p2.x, this.startDragPoint.y + p2.y);
            } else if (this.startDragPoint != null) {
                if (!this.glassPane.isVisible()) {
                    this.glassPane.setBounds(0, 0, this.getWidth(), this.getHeight());
                    this.glassPane.setVisible(true);
                }
                this.scrollRectToVisible(new Rectangle(e.getX() - 20, e.getY() - 20, 40, 40));
                Rectangle oldSelectionRect = this.selectionRect;
                int x = StrictMath.min(this.getWidth(), StrictMath.max(e.getX(), 0));
                int y = StrictMath.min(this.getHeight(), StrictMath.max(e.getY(), 0));
                this.selectionRect = new Rectangle(StrictMath.min(this.startDragPoint.x, x), StrictMath.min(this.startDragPoint.y, y), StrictMath.abs(x - this.startDragPoint.x), StrictMath.abs(y - this.startDragPoint.y));
                this.selectWidgets(this.selectionRect);
                if (oldSelectionRect != null) {
                    this.glassPane.repaint(oldSelectionRect);
                }
                this.glassPane.repaint(this.selectionRect);
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        try {
            if (e.isPopupTrigger()) {
                this.doPopup(e);
                return;
            }
            if (!Utils.button1Mask(e)) {
                return;
            }
            this.requestFocus();
            Point p = e.getPoint();
            Rectangle rect = this.getBounds();
            p.x += rect.x;
            p.y += rect.y;
            if (rect.contains(p)) {
                Widget widget;
                this.unselectWidgets();
                this.startDragPoint = e.getPoint();
                if (this.widgetCreator != null && (widget = this.widgetCreator.getWidget()) != null) {
                    this.addWidget(widget, e.getX(), e.getY(), true, false);
                    this.revalidate();
                }
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    private final void doPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new WidgetCreationMenuItem("Button", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem("Slider", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem("Switch", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem("Chooser", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem("Monitor", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem("Plot", e.getX(), e.getY()));
        WidgetCreationMenuItem outputItem = new WidgetCreationMenuItem("Output", e.getX(), e.getY());
        if (this.getOutputWidget() != null) {
            outputItem.setEnabled(false);
        }
        menu.add(outputItem);
        menu.add(new WidgetCreationMenuItem("Text", e.getX(), e.getY()));
        if (e.isAltDown()) {
            menu.add(new JPopupMenu.Separator());
            menu.add(new WidgetCreationMenuItem("Input Box", e.getX(), e.getY()));
            menu.add(new JPopupMenu.Separator());
        }
        menu.add(new JPopupMenu.Separator());
        JMenuItem copyItem = new JMenuItem("Copy Interface");
        copyItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageSelection(Utils.paintToImage(InterfacePanel.this)), null);
            }
        });
        menu.add(copyItem);
        JMenuItem exportItem = new JMenuItem("Export Interface...");
        exportItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                InterfacePanel.this.exportInterface();
            }
        });
        menu.add(exportItem);
        menu.show(this, e.getX(), e.getY());
    }

    Widget makeWidget(String type) {
        if ((type = type.toUpperCase()).equals("SLIDER")) {
            return new SliderWidget(this.sliderEventOnReleaseOnly);
        }
        if (type.equals("CHOOSER") || type.equals("CHOICE")) {
            return new ChooserWidget();
        }
        if (type.equals("BUTTON")) {
            return new ButtonWidget();
        }
        if (type.equals("PLOT")) {
            return this.workspace.graphManager.createUntitledGraph();
        }
        if (type.equals("SWITCH")) {
            return new SwitchWidget();
        }
        if (type.equals("MONITOR")) {
            return new MonitorWidget();
        }
        if (type.equals("TEXT") || type.equals("TEXTBOX")) {
            return new TextBoxWidget();
        }
        if (type.equals("INPUT BOX") || type.equals("INPUTBOX")) {
            return new InputBoxWidget();
        }
        if (type.equals("OUTPUT")) {
            return new OutputWidget();
        }
        if (type.equals("CC-WINDOW")) {
            return null;
        }
        throw new IllegalStateException("unknown widget type: " + type);
    }

    public void mouseReleased(MouseEvent e) {
        try {
            if (e.isPopupTrigger()) {
                this.doPopup(e);
                return;
            }
            if (Utils.button1Mask(e)) {
                Point p = e.getPoint();
                Rectangle rect = this.getBounds();
                p.x += rect.x;
                p.y += rect.y;
                this.selectionRect = null;
                this.glassPane.setVisible(false);
                if (this.newWidget != null) {
                    this.newWidget.selected(true);
                    this.newWidget.foreground();
                    new EditWidgetEvent(this, null, true).raise();
                    this.newWidget.setCursor(Cursor.getPredefinedCursor(0));
                    this.newWidget = null;
                }
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    void setForegroundWrapper() {
        Component[] comps = this.getComponents();
        int i = 0;
        while (comps.length != i) {
            if (comps[i] instanceof WidgetWrapper && ((WidgetWrapper)comps[i]).selected()) {
                ((WidgetWrapper)comps[i]).foreground();
                return;
            }
            ++i;
        }
    }

    private final void selectWidgets(Rectangle rect) {
        Component[] comps = this.getComponents();
        int i = 0;
        while (comps.length != i) {
            if (comps[i] instanceof WidgetWrapper) {
                boolean selected = false;
                WidgetWrapper wrapper = (WidgetWrapper)comps[i];
                selected = wrapper.selected();
                Rectangle wrapperRect = wrapper.getUnselectedBounds();
                if (!selected) {
                    if (rect.intersects(wrapperRect)) {
                        wrapper.selected(true);
                    }
                } else if (!rect.intersects(wrapperRect) && selected) {
                    wrapper.selected(false);
                }
            }
            ++i;
        }
        this.setForegroundWrapper();
    }

    private final void unselectWidgets() {
        List selectedWrappers = this.selectedWrappers();
        int i = 0;
        while (i < selectedWrappers.size()) {
            WidgetWrapper wrapper = (WidgetWrapper)selectedWrappers.get(i);
            wrapper.selected(false);
            ++i;
        }
    }

    private final WidgetWrapper addWidget(Widget widget, int x, int y, boolean select, boolean loadingWidget) {
        Dimension size = widget.getSize();
        WidgetWrapper wrapper = new WidgetWrapper(widget, this);
        wrapper.setVisible(false);
        this.add((Component)wrapper, DEFAULT_LAYER);
        this.moveToFront(wrapper);
        if (select || !loadingWidget) {
            wrapper.setSize(wrapper.getPreferredSize());
        } else {
            wrapper.setSize(size);
        }
        wrapper.setLocation(x, y);
        wrapper.validate();
        wrapper.setVisible(true);
        this.zoomer.zoomWidget(wrapper, true, loadingWidget, 1.0, this.zoomer.zoomFactor());
        if (select) {
            this.newWidget = wrapper;
            this.newWidget.originalBounds = this.newWidget.getBounds();
            this.newWidget.setCursor(Cursor.getPredefinedCursor(1));
        }
        return wrapper;
    }

    public void editWidgetFinished(Editable target, boolean cancelled) {
        if (target instanceof Component && ((Component)((Object)target)).getParent() instanceof WidgetWrapper) {
            ((WidgetWrapper)((Component)((Object)target)).getParent()).selected(false);
        }
        if (cancelled && this.newWidget != null) {
            this.removeWidget(this.newWidget);
            this.revalidate();
        }
        this.setForegroundWrapper();
        this.loseFocusIfAppropriate();
    }

    public void deleteSelectedWidgets() {
        ArrayList<WidgetWrapper> hitList = new ArrayList<WidgetWrapper>();
        List selectedWrappers = this.selectedWrappers();
        int i = 0;
        while (i < selectedWrappers.size()) {
            WidgetWrapper w = (WidgetWrapper)selectedWrappers.get(i);
            if (w.selected() && w.widget().deleteable()) {
                hitList.add(w);
            }
            ++i;
        }
        this.deleteWidgets(hitList);
    }

    void deleteWidget(WidgetWrapper target) {
        ArrayList<WidgetWrapper> hitList = new ArrayList<WidgetWrapper>();
        hitList.add(target);
        this.deleteWidgets(hitList);
    }

    private final void deleteWidgets(List hitList) {
        boolean needsRecompile = false;
        int i = 0;
        while (i < hitList.size()) {
            WidgetWrapper w = (WidgetWrapper)hitList.get(i);
            this.removeWidget(w);
            if (w.widget() instanceof JobOwner && ((JobOwner)((Object)w.widget())).procedure() == null) {
                needsRecompile = true;
            }
            if (w.widget() instanceof SliderWidget || w.widget() instanceof ChooserWidget || w.widget() instanceof SwitchWidget) {
                needsRecompile = true;
            }
            ++i;
        }
        this.setForegroundWrapper();
        this.revalidate();
        this.repaint();
        if (needsRecompile) {
            new CompileAllEvent(this).raise();
        }
        this.loseFocusIfAppropriate();
    }

    private final void removeWidget(WidgetWrapper wrapper) {
        this.remove(wrapper);
        if (wrapper.widget() instanceof GraphWidget) {
            this.graphManager.forgetGraph((GraphWidget)wrapper.widget());
        }
    }

    public void setWidgetCreator(WidgetCreator widgetCreator) {
        this.widgetCreator = widgetCreator;
    }

    public boolean sliderEventOnReleaseOnly() {
        return this.sliderEventOnReleaseOnly;
    }

    public void sliderEventOnReleaseOnly(boolean sliderEventOnReleaseOnly) {
        this.sliderEventOnReleaseOnly = sliderEventOnReleaseOnly;
    }

    public void handleZoomedEvent(ZoomedEvent e) {
        this.unselectWidgets();
        this.zoomer.zoomWidgets(e.zoomFactor());
        this.revalidate();
    }

    public Widget loadWidget(String[] strings, String modelVersion) {
        try {
            String type = strings[0];
            int x = Integer.parseInt(strings[1]);
            int y = Integer.parseInt(strings[2]);
            if (this.graphicsWidget instanceof GraphicsWidget && !type.equals("GRAPHICS-WINDOW") && Version.olderThan13pre1(modelVersion)) {
                y += ((GraphicsWidget)this.graphicsWidget).getExtraHeight() + ((GraphicsWidget)this.graphicsWidget).controlStrip.getHeight();
            }
            if (type.equals("GRAPHICS-WINDOW")) {
                try {
                    this.graphicsWidget.asWidget().load(strings, modelVersion);
                }
                catch (RuntimeException ex) {
                    Exceptions.handle(ex);
                }
                this.graphicsWidget.asWidget().getParent().setSize(this.graphicsWidget.asWidget().getSize());
                this.enforceMinimumAndMaximumWidgetSizes(this.graphicsWidget.asWidget());
                this.graphicsWidget.asWidget().getParent().setLocation(x, y);
                this.zoomer.zoomWidgetLocation(this.getWrapper(this.graphicsWidget.asWidget()), true, true, 1.0, this.zoomer.zoomFactor());
                this.zoomer.zoomWidgetSize(this.getWrapper(this.graphicsWidget.asWidget()), true, true, 1.0, this.zoomer.zoomFactor());
                this.zoomer.scaleComponentFont(((GraphicsWidget)this.graphicsWidget).graphicsWindow, this.zoomer.zoomFactor(), 1.0, false);
                return this.graphicsWidget.asWidget();
            }
            Widget newGuy = null;
            try {
                newGuy = this.makeWidget(type);
            }
            catch (RuntimeException ex) {
                Exceptions.handle(ex);
            }
            if (newGuy != null) {
                newGuy.load(strings, modelVersion);
                this.enforceMinimumAndMaximumWidgetSizes(newGuy);
                this.addWidget(newGuy, x, y, false, true);
            }
            return newGuy;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
            return null;
        }
    }

    public void handleWidgetEditedEvent(WidgetEditedEvent e) {
        new DirtyEvent(this).raise();
        this.zoomer.updateZoomInfo(e.widget());
    }

    public void handleExportInterfaceEvent(ExportInterfaceEvent e) {
        try {
            ImageIO.write((RenderedImage)Utils.paintToImage(this), "png", e.getStream());
        }
        catch (IOException ex) {
            e.getExceptionBox()[0] = ex;
        }
    }

    private final void exportInterface() {
        try {
            final String exportPath = FileDialog.show(this, "Exporting", 1, "interface.png");
            final IOException[] exception = new IOException[1];
            new ModalProgressTask(Utils.getFrame(this), new Runnable(){

                public final void run() {
                    try {
                        InterfacePanel.this.workspace.exportInterface(exportPath);
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            }, "Exporting...");
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        catch (UserCancelException ex) {
            Exceptions.ignore(ex);
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
    }

    public void handleLoadBeginEvent(LoadBeginEvent e) {
        this.unselectWidgets();
        this.removeAllWidgets();
        this.zoomer.forgetAllZoomInfo();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleLoadSectionEvent(LoadSectionEvent e) {
        if (e.section() != ModelReader.WIDGETS) return;
        try {
            List v = ModelReader.parseWidgets(e.lines());
            if (v != null) {
                this.setVisible(false);
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    List v2 = (List)iter.next();
                    String[] strings = v2.toArray(new String[v2.size()]);
                    this.loadWidget(strings, e.version());
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.setVisible(true);
            this.revalidate();
            throw throwable;
        }
        {
            Object var3_8 = null;
        }
        this.setVisible(true);
        this.revalidate();
    }

    List getWidgetsForSaving() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.graphicsWidget);
        Component[] comps = this.getComponents();
        int i = comps.length - 1;
        while (i >= 0) {
            WidgetWrapper wrapper;
            Widget widget;
            if (comps[i] instanceof WidgetWrapper && !result.contains(widget = (wrapper = (WidgetWrapper)comps[i]).widget())) {
                result.add(widget);
            }
            --i;
        }
        return result;
    }

    OutputWidget getOutputWidget() {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            WidgetWrapper wrapper;
            if (comps[i] instanceof WidgetWrapper && (wrapper = (WidgetWrapper)comps[i]).widget() instanceof OutputWidget) {
                return (OutputWidget)wrapper.widget();
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void removeAllWidgets() {
        try {
            try {
                Component[] comps = this.getComponents();
                this.setVisible(false);
                int i = 0;
                while (comps.length != i) {
                    WidgetWrapper wrapper;
                    if (comps[i] instanceof WidgetWrapper && (wrapper = (WidgetWrapper)comps[i]).widget() != this.graphicsWidget) {
                        this.removeWidget(wrapper);
                    }
                    ++i;
                }
            }
            catch (RuntimeException ex) {
                Exceptions.handle(ex);
            }
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.setVisible(false);
            throw throwable;
        }
        {
            Object var2_7 = null;
        }
        this.setVisible(false);
    }

    private final void enforceMinimumAndMaximumWidgetSizes(Component component) {
        Dimension maximumSize;
        Dimension size = component.getSize();
        boolean changed = false;
        Dimension minimumSize = component.getMinimumSize();
        if (size.width < minimumSize.width) {
            size.width = minimumSize.width;
            changed = true;
        }
        if (size.height < minimumSize.height) {
            size.height = minimumSize.height;
            changed = true;
        }
        if ((maximumSize = component.getMaximumSize()) != null) {
            if (size.width > maximumSize.width && maximumSize.width > 0) {
                size.width = maximumSize.width;
                changed = true;
            }
            if (size.height > maximumSize.height && maximumSize.height > 0) {
                size.height = maximumSize.height;
                changed = true;
            }
        }
        if (changed) {
            component.setSize(size);
        }
    }

    private final void loseFocusIfAppropriate() {
        if (this.hasFocus && !this.isFocusable()) {
            this.transferFocus();
        }
    }

    public boolean isFocusable() {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            ButtonWidget button;
            Widget widget;
            if (comps[i] instanceof WidgetWrapper && (widget = ((WidgetWrapper)comps[i]).widget()) instanceof ButtonWidget && (button = (ButtonWidget)widget).actionKey() != '\u0000') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final ButtonWidget findActionButton(char key) {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            ButtonWidget button;
            Widget widget;
            if (comps[i] instanceof WidgetWrapper && (widget = ((WidgetWrapper)comps[i]).widget()) instanceof ButtonWidget && Character.toUpperCase((button = (ButtonWidget)widget).actionKey()) == Character.toUpperCase(key)) {
                return button;
            }
            ++i;
        }
        return null;
    }

    private final void enableButtonKeys(boolean enabled) {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            Widget widget;
            if (comps[i] instanceof WidgetWrapper && (widget = ((WidgetWrapper)comps[i]).widget()) instanceof ButtonWidget) {
                ButtonWidget button = (ButtonWidget)widget;
                button.keyEnabled(enabled);
            }
            ++i;
        }
    }

    public String getBoundsString(Widget widget) {
        StringBuffer buf = new StringBuffer();
        Rectangle r = this.getUnzoomedBounds(widget);
        buf.append("" + r.x + '\n');
        buf.append("" + r.y + '\n');
        buf.append("" + (r.x + r.width) + '\n');
        buf.append("" + (r.y + r.height) + '\n');
        return buf.toString();
    }

    public Rectangle getUnzoomedBounds(Component component) {
        return this.zoomer.getUnzoomedBounds(component);
    }

    public int getUnzoomedFontSize(Component component) {
        return this.zoomer.getFontForSave(component);
    }

    public void resetZoomInfo(Widget widget) {
        this.zoomer.updateZoomInfo(widget);
    }

    public void resetSizeInfo(Widget widget) {
        this.getWrapper(widget).widgetResized();
    }

    public boolean isZoomed() {
        boolean bl = false;
        if (this.zoomer.zoomFactor() != 1.0) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.zoomer = new Zoomer(this);
        this.glassPane = new JComponent(){

            public final void paintComponent(Graphics g) {
                if (InterfacePanel.this.selectionRect != null) {
                    g.drawRect(((InterfacePanel)InterfacePanel.this).selectionRect.x, ((InterfacePanel)InterfacePanel.this).selectionRect.y, ((InterfacePanel)InterfacePanel.this).selectionRect.width - 1, ((InterfacePanel)InterfacePanel.this).selectionRect.height - 1);
                }
            }
        };
        this.hasFocus = false;
        this.widgetCreator = null;
        this.sliderEventOnReleaseOnly = false;
    }

    public InterfacePanel(GraphicsWidgetInterface graphicsWidget, GUIWorkspace workspace, GraphManager graphManager) {
        this.this();
        this.graphicsWidget = graphicsWidget;
        this.workspace = workspace;
        this.graphManager = graphManager;
        workspace.setWidgetContainer(this);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        this.setAutoscrolls(true);
        this.addWidget((Widget)((Object)graphicsWidget), 0, 0, false, false);
        ((Widget)((Object)graphicsWidget)).deleteable(false);
        this.glassPane.setOpaque(false);
        this.glassPane.setVisible(false);
        this.glassPane.setForeground(Color.GREEN);
        this.add((Component)this.glassPane, DRAG_LAYER);
        this.addKeyListener(new KeyAdapter(){

            public final void keyTyped(KeyEvent e) {
                ButtonWidget button;
                if (e.getKeyChar() != (char)-1 && !e.isActionKey() && (e.getModifiers() & InterfacePanel.this.getToolkit().getMenuShortcutKeyMask()) == 0 && (button = InterfacePanel.this.findActionButton(e.getKeyChar())) != null) {
                    button.keyTriggered();
                }
            }
        });
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class WidgetCreationMenuItem
    extends JMenuItem {
        WidgetCreationMenuItem(final String name, final int x, final int y) {
            super(name);
            this.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    Widget widget = InterfacePanel.this.makeWidget(name);
                    WidgetWrapper wrapper = InterfacePanel.this.addWidget(widget, x, y, true, false);
                    WidgetCreationMenuItem.this.revalidate();
                    wrapper.selected(true);
                    wrapper.foreground();
                    new EditWidgetEvent(InterfacePanel.this, null, true).raise();
                    InterfacePanel.this.newWidget.setCursor(Cursor.getPredefinedCursor(0));
                    InterfacePanel.this.newWidget = null;
                }
            });
        }
    }
}

