/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.nlogo.app.GraphicsPreview;
import org.nlogo.awt.RowLayout;
import org.nlogo.awt.Utils;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.util.Exceptions;
import org.nlogo.util.FileIO;
import org.nlogo.util.UserCancelException;
import org.nlogo.workspace.Library;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class LibraryDialog
extends JDialog
implements TreeSelectionListener,
TreeExpansionListener {
    private static LibraryDialog me = null;
    private final JTree tree;
    private final GraphicsPreview graphicsPreview;
    private final JTextArea textArea;
    private Library.Node selected;
    private String source;
    private String path;
    Action openAction;
    Action toggleOrOpenAction;
    Action cancelAction;
    Action communityAction;

    public static String open(Frame parent) throws UserCancelException {
        if (me == null) {
            me = new LibraryDialog(parent);
            LibraryDialog.me.tree.setSelectionRow(0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                me.tree.requestFocus();
            }
        });
        me.setVisible(true);
        if (LibraryDialog.me.source == null) {
            throw new UserCancelException();
        }
        return LibraryDialog.me.source;
    }

    public static String getModelPath() {
        return LibraryDialog.me.path;
    }

    public void treeExpanded(TreeExpansionEvent e) {
        this.invalidate();
        this.validate();
    }

    public void treeCollapsed(TreeExpansionEvent e) {
        this.invalidate();
        this.validate();
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.tree.getSelectionPath() == null) {
            this.selected = null;
            this.openAction.setEnabled(false);
            this.toggleOrOpenAction.setEnabled(false);
        } else {
            this.selected = (Library.Node)this.tree.getSelectionPath().getLastPathComponent();
            this.openAction.setEnabled(this.selected.isFolder() ^ true);
            this.toggleOrOpenAction.setEnabled(true);
        }
        this.graphicsPreview.setImage(this.selected == null || this.selected.isFolder() ? null : Library.getImagePath(this.selected.getFilePath()));
        String text = "";
        if (this.selected != null) {
            if (this.selected.isFolder()) {
                text = org.nlogo.util.Utils.getResourceAsString("/system/_libraryinfo.txt");
            } else {
                try {
                    text = Library.getInfoWindow(this.selected.getFilePath());
                }
                catch (IOException ex) {
                    Exceptions.handle(ex);
                }
                catch (RuntimeException ex) {
                    Exceptions.handle(ex);
                }
            }
        }
        this.textArea.setText(text);
        this.textArea.setCaretPosition(0);
    }

    public Dimension getMinimumSize() {
        return new Dimension(470, 330);
    }

    static /* synthetic */ String access$3(LibraryDialog libraryDialog) {
        return libraryDialog.source;
    }

    private final /* synthetic */ void this() {
        this.selected = null;
        this.source = null;
        this.path = null;
        this.openAction = new AbstractAction("Open"){

            public final void actionPerformed(ActionEvent e) {
                LibraryDialog.this.path = LibraryDialog.this.selected.getFilePath();
                try {
                    LibraryDialog.this.source = FileIO.file2String(LibraryDialog.this.path);
                    LibraryDialog.this.setVisible(false);
                }
                catch (IOException ex) {
                    Exceptions.handle(ex);
                }
            }
        };
        this.toggleOrOpenAction = new AbstractAction("toggle-or-open"){

            public final void actionPerformed(ActionEvent e) {
                if (LibraryDialog.this.selected.isFolder()) {
                    int row = LibraryDialog.this.tree.getSelectionRows()[0];
                    if (LibraryDialog.this.tree.isExpanded(row)) {
                        LibraryDialog.this.tree.collapseRow(row);
                    } else {
                        LibraryDialog.this.tree.expandRow(row);
                    }
                } else if (LibraryDialog.this.openAction.isEnabled()) {
                    LibraryDialog.this.openAction.actionPerformed(null);
                }
            }
        };
        this.cancelAction = new AbstractAction("Cancel"){

            public final void actionPerformed(ActionEvent e) {
                LibraryDialog.this.source = null;
                LibraryDialog.this.path = null;
                LibraryDialog.this.setVisible(false);
            }
        };
        this.communityAction = new AbstractAction("Go to User Community Models web page"){

            public final void actionPerformed(ActionEvent e) {
                Utils.openURL("http://ccl.northwestern.edu/netlogo/models/community/", false);
            }
        };
    }

    private LibraryDialog(Frame parent) {
        super(parent, "Models Library", true);
        this.this();
        this.setResizable(true);
        this.openAction.setEnabled(false);
        this.toggleOrOpenAction.setEnabled(false);
        JButton communityButton = new JButton(this.communityAction);
        JButton selectButton = new JButton(this.openAction);
        JButton cancelButton = new JButton(this.cancelAction);
        this.getRootPane().setDefaultButton(selectButton);
        this.graphicsPreview = new GraphicsPreview();
        this.textArea = new JTextArea(15, 30);
        this.textArea.setDragEnabled(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font(Utils.platformFont(), 0, 12));
        if (Library.needsModelScan()) {
            new ModalProgressTask(parent, new Runnable(){

                public final void run() {
                    Library.scanForModels();
                }
            }, "Scanning...");
        }
        this.tree = new JTree(Library.rootNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setToggleClickCount(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        if (this.tree.getRowCount() > 1 && ((Library.Node)this.tree.getPathForRow(1).getLastPathComponent()).getName().equals("Curricular Models")) {
            this.tree.expandRow(1);
        }
        if (this.tree.getRowCount() > 0 && ((Library.Node)this.tree.getPathForRow(0).getLastPathComponent()).getName().equals("Sample Models")) {
            this.tree.expandRow(0);
        }
        InputMap inputMap = new InputMap();
        inputMap.setParent(this.tree.getInputMap());
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "none");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle-or-open");
        this.tree.setInputMap(0, inputMap);
        this.tree.getActionMap().put("toggle-or-open", this.toggleOrOpenAction);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeExpansionListener(this);
        this.tree.addMouseListener(new MouseAdapter(){

            public final void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && LibraryDialog.this.openAction.isEnabled()) {
                    LibraryDialog.this.openAction.actionPerformed(null);
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        this.getContentPane().add((Component)topPanel, "Center");
        Box buttonPanelsBox = new Box(0);
        ButtonPanel buttonPanel1 = new ButtonPanel(new JButton[]{communityButton});
        ButtonPanel buttonPanel2 = new ButtonPanel(new JButton[]{selectButton, cancelButton});
        buttonPanelsBox.add(buttonPanel1);
        buttonPanelsBox.add(Box.createGlue());
        buttonPanelsBox.add(buttonPanel2);
        this.getContentPane().add((Component)buttonPanelsBox, "South");
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JScrollPane(this.tree, 22, 31), "West");
        JPanel rightPanel = new JPanel();
        topPanel.add((Component)rightPanel, "Center");
        rightPanel.setLayout(new BorderLayout());
        JPanel picPanel = new JPanel();
        rightPanel.add((Component)picPanel, "North");
        picPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        picPanel.setLayout(new RowLayout(0, 0.5f, 0.5f));
        picPanel.add((Component)this.graphicsPreview, "West");
        rightPanel.add((Component)new JScrollPane(this.textArea, 22, 31), "Center");
        org.nlogo.swing.Utils.addEscKeyAction(this, this.cancelAction);
        this.pack();
        Utils.center(this, parent);
    }
}

