/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.io.IOException;
import java.util.Iterator;
import org.nlogo.agent.Shape;
import org.nlogo.app.Tabs;
import org.nlogo.event.EventLinkComponent;
import org.nlogo.event.ModelSavedEvent;
import org.nlogo.util.Exceptions;
import org.nlogo.util.FileIO;
import org.nlogo.util.Version;
import org.nlogo.window.Widget;

strictfp class ModelSaver
implements EventLinkComponent,
ModelSavedEvent.Raiser {
    private static final String SEPARATOR = "@#$#@#$#@";
    private final Object linkParent;
    private final String filePath;
    private final Tabs tabs;
    private boolean canceled;

    public Object getLinkParent() {
        return this.linkParent;
    }

    static boolean save(Object linkParent, String filePath, Tabs tabs) throws IOException {
        return new ModelSaver(linkParent, filePath, tabs).save();
    }

    boolean canceled() {
        return this.canceled;
    }

    private final boolean save() throws IOException {
        StringBuffer buf = new StringBuffer();
        if (this.tabs.currentTab == this.tabs.errorsTab && this.tabs.errorsTab.sourceOwner() == this.tabs.proceduresTab) {
            buf.append(this.tabs.errorsTab.code.getText());
        } else {
            buf.append(this.tabs.proceduresTab.innerSource());
        }
        if (buf.length() == 0 || buf.charAt(buf.length() - 1) != '\n') {
            buf.append("\n");
        }
        buf.append("@#$#@#$#@\n");
        Iterator keys = this.tabs.interfaceTab.getWidgetsForSaving().iterator();
        while (keys.hasNext()) {
            Widget w = (Widget)keys.next();
            try {
                buf.append(w.save() + '\n');
            }
            catch (RuntimeException ex) {
                Exceptions.handle(ex);
            }
        }
        buf.append("@#$#@#$#@\n");
        buf.append(this.tabs.infoTab.info());
        if (buf.length() == 0 || buf.charAt(buf.length() - 1) != '\n') {
            buf.append("\n");
        }
        buf.append("@#$#@#$#@\n");
        keys = this.tabs.workspace.world.shapeList.getShapes().iterator();
        while (keys.hasNext()) {
            Shape shape = (Shape)keys.next();
            buf.append(shape.toString());
            buf.append("\n\n");
        }
        buf.append("@#$#@#$#@\n");
        buf.append(Version.version() + '\n');
        buf.append("@#$#@#$#@\n");
        if (!this.tabs.workspace.previewCommands.trim().equals("")) {
            buf.append(this.tabs.workspace.previewCommands.trim() + '\n');
        }
        buf.append("@#$#@#$#@\n");
        buf.append("@#$#@#$#@\n");
        if (FileIO.writeFile(this.filePath, buf.toString())) {
            new ModelSavedEvent(this, this.filePath).raise();
            return true;
        }
        return false;
    }

    private ModelSaver(Object linkParent, String filePath, Tabs tabs) {
        this.linkParent = linkParent;
        this.filePath = filePath;
        this.tabs = tabs;
    }
}

