/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.nlogo.app.EditorColorizer;
import org.nlogo.app.ErrorList;
import org.nlogo.app.PopUpIncludesMenu;
import org.nlogo.app.PopUpProceduresMenu;
import org.nlogo.compiler.CompilerException;
import org.nlogo.editor.Actions;
import org.nlogo.editor.EditorArea;
import org.nlogo.event.CompileAllEvent;
import org.nlogo.event.EventLinkComponent;
import org.nlogo.event.PopUpAddedEvent;
import org.nlogo.event.PopUpDestroyEvent;
import org.nlogo.event.PopUpLoadedEvent;
import org.nlogo.event.PopUpNeedsCompileEvent;
import org.nlogo.event.PopUpSavedEvent;
import org.nlogo.event.ZoomedEvent;
import org.nlogo.nvm.LogoException;
import org.nlogo.nvm.SourceOwner;
import org.nlogo.swing.FindDialog;
import org.nlogo.swing.OptionDialog;
import org.nlogo.swing.Printable;
import org.nlogo.swing.PrinterManager;
import org.nlogo.swing.ToolBar;
import org.nlogo.util.Exceptions;
import org.nlogo.util.FileIO;
import org.nlogo.util.UserCancelException;
import org.nlogo.util.Utils;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.ProceduresInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class PopUpEditor
extends JFrame
implements ProceduresInterface,
EventLinkComponent,
CompileAllEvent.Raiser,
PopUpSavedEvent.Raiser,
PopUpLoadedEvent.Raiser,
PopUpAddedEvent.Raiser,
PopUpDestroyEvent.Raiser,
PopUpNeedsCompileEvent.Raiser,
ZoomedEvent.Handler,
Printable {
    private final String fileName;
    private final GUIWorkspace workspace;
    private final EditorArea text;
    private final ToolBar toolbar;
    private ErrorList errorList;
    private boolean dirtyBit;
    private int originalFontSize;
    private double zoomFactor;
    static /* synthetic */ Class class$org$nlogo$app$ErrorsTab;

    public void handleZoomedEvent(ZoomedEvent e) {
        if (this.zoomFactor != e.zoomFactor()) {
            this.zoomFactor = e.zoomFactor();
            if (this.originalFontSize == -1) {
                this.originalFontSize = this.text.getFont().getSize();
            }
            this.text.setFont(this.text.getFont().deriveFont((float)StrictMath.ceil((double)this.originalFontSize * this.zoomFactor)));
        }
    }

    public void requestFocus() {
        this.text.requestFocus();
    }

    public String innerSource() {
        return this.text.getText();
    }

    public void innerSource(String s) {
        this.text.setText(s);
        this.text.setCaretPosition(0);
    }

    public String headerSource() {
        return "";
    }

    void select(int start, int end) {
        this.text.select(start, end);
    }

    public String fileName() {
        return this.fileName;
    }

    public void cleanse() {
        this.dirtyBit = false;
        this.setTitle(this.fileName);
    }

    public boolean isDirty() {
        return this.dirtyBit;
    }

    public void dirty() {
        this.dirtyBit = true;
        this.setTitle("*" + this.fileName + '*');
    }

    public String classDisplayName() {
        return "PopUpEditor";
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex, PrinterManager printer) throws PrinterException {
        return printer.printText(g, pageFormat, pageIndex, this.text.getText());
    }

    public void load() {
        try {
            this.innerSource(Utils.replace(Utils.url2String(this.fileName), "\r\n", "\n"));
            new PopUpAddedEvent(this, this).raise();
        }
        catch (IOException exception) {
            Exceptions.handle(new LogoException("Could not find " + this.fileName));
        }
    }

    public void close() {
        try {
            if (this.dirtyBit && this.userWantsToSaveFirst()) {
                this.save();
            }
            this.setVisible(false);
            this.dispose();
            new PopUpDestroyEvent(this, this).raise();
        }
        catch (UserCancelException ex) {
            Exceptions.ignore(ex);
        }
    }

    public void save() {
        if (this.dirtyBit) {
            try {
                String fileQualifier = "file:/";
                if (this.fileName.indexOf(fileQualifier) != -1) {
                    if (FileIO.writeFile(this.fileName.substring(fileQualifier.length()), this.text.getText())) {
                        this.cleanse();
                    }
                } else if (FileIO.writeFile(this.fileName, this.text.getText())) {
                    this.cleanse();
                } else {
                    Exceptions.handle(new LogoException("Could not save " + this.fileName));
                }
            }
            catch (IOException ex) {
                Exceptions.handle(ex);
            }
        }
    }

    private final boolean userWantsToSaveFirst() throws UserCancelException {
        Object[] options = new String[]{"Save", "Discard", "Cancel"};
        String message = "Do you want to save the changes you made to this file?";
        switch (OptionDialog.show(this, "Warning", message, options)) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        throw new UserCancelException();
    }

    public void addError(String description, CompilerException compilerError, SourceOwner sourceOwner) {
        this.errorList.addError(description, compilerError, sourceOwner);
        this.errorList.setVisible(true);
        this.text.select(compilerError.getStartPosition(), compilerError.getEndPosition());
    }

    public void clearErrors() {
        this.errorList.setVisible(false);
        this.errorList.clearErrors();
    }

    public Object getLinkParent() {
        return this.workspace;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.errorList = new ErrorList();
        this.dirtyBit = false;
        this.originalFontSize = -1;
        this.zoomFactor = 1.0;
    }

    PopUpEditor(GUIWorkspace workspace, String fileName) {
        this.this();
        this.fileName = fileName;
        this.workspace = workspace;
        this.toolbar = new ToolBar(){

            protected final void addControls() {
                this.add(new JButton(new PopUpSaveAction()));
                this.add(new ToolBar.Separator());
                this.add(new JButton(FindDialog.FIND_ACTION));
                this.add(new JButton(FindDialog.FIND_AGAIN_ACTION));
                this.add(new ToolBar.Separator());
                this.add(new JButton(new PopUpCompileAction()));
                this.add(new ToolBar.Separator());
                this.add(new PopUpProceduresMenu(PopUpEditor.this));
                this.add(new PopUpIncludesMenu(PopUpEditor.this));
                this.add(new ToolBar.Separator());
                this.add(new JButton(Actions.commentAction));
                this.add(new JButton(Actions.uncommentAction));
            }
        };
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                PopUpEditor.this.close();
            }
        });
        this.text = new EditorArea(100, 100, true, new TextListener(){

            public final void textValueChanged(TextEvent e) {
                if (!PopUpEditor.this.dirtyBit) {
                    PopUpEditor.this.dirty();
                }
            }
        }, new EditorColorizer(workspace));
        this.text.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(gridbag);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.anchor = 11;
        c.fill = 2;
        c.gridwidth = 0;
        c.gridheight = 1;
        gridbag.setConstraints(this.toolbar, c);
        this.getContentPane().add(this.toolbar);
        gridbag.setConstraints(this.errorList, c);
        this.getContentPane().add(this.errorList);
        this.errorList.setVisible(false);
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.gridheight = 0;
        JScrollPane scrollPane = new JScrollPane(this.text, 22, 32);
        gridbag.setConstraints(scrollPane, c);
        this.getContentPane().add(scrollPane);
        this.pack();
        new PopUpLoadedEvent(this, this).raise();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PopUpCompileAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            new CompileAllEvent(PopUpEditor.this).raise();
        }

        PopUpCompileAction() {
            super("Compile");
            Class clazz = class$org$nlogo$app$ErrorsTab;
            if (clazz == null) {
                clazz = class$org$nlogo$app$ErrorsTab = PopUpEditor.class("[Lorg.nlogo.app.ErrorsTab;", false);
            }
            this.putValue("SmallIcon", new ImageIcon(clazz.getResource("/images/compile.gif")));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PopUpSaveAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            PopUpEditor.this.save();
        }

        PopUpSaveAction() {
            super("Save");
            Class clazz = class$org$nlogo$app$ErrorsTab;
            if (clazz == null) {
                clazz = class$org$nlogo$app$ErrorsTab = PopUpEditor.class("[Lorg.nlogo.app.ErrorsTab;", false);
            }
            this.putValue("SmallIcon", new ImageIcon(clazz.getResource("/images/save.gif")));
        }
    }
}

