/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.util.Enumeration;
import java.util.Hashtable;
import org.nlogo.app.PopUpEditor;
import org.nlogo.app.cc.CommandLine;
import org.nlogo.compiler.CompilerException;
import org.nlogo.event.CompiledEvent;
import org.nlogo.event.PopUpAddedEvent;
import org.nlogo.event.PopUpDestroyEvent;
import org.nlogo.event.PopUpLoadedEvent;
import org.nlogo.event.PopUpOpenEvent;
import org.nlogo.event.PopUpSavedEvent;
import org.nlogo.event.RemoveAllJobsEvent;
import org.nlogo.event.RuntimeErrorEvent;
import org.nlogo.util.Utils;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.PopUpInterface;

public strictfp class PopUpManager
implements CompiledEvent.Handler,
PopUpOpenEvent.Handler,
PopUpSavedEvent.Handler,
PopUpLoadedEvent.Handler,
PopUpAddedEvent.Handler,
PopUpDestroyEvent.Handler,
RemoveAllJobsEvent.Handler,
RuntimeErrorEvent.Handler {
    private final GUIWorkspace workspace;
    private final Hashtable windows;
    private boolean needsCompile;

    public void handlePopUpOpenEvent(PopUpOpenEvent e) {
        String filename = Utils.unescapeSpacesInURL(Utils.makeURLFromFilePath(Utils.replace("/" + e.fileName(), "\\", "/")));
        PopUpEditor editor = (PopUpEditor)this.windows.get(filename);
        if (editor == null) {
            editor = new PopUpEditor(this.workspace, filename);
        } else {
            editor.requestFocus();
        }
    }

    public void init() {
    }

    public void handleCompiledEvent(CompiledEvent e) {
        CompilerException error;
        if (!(e.sourceOwner() instanceof CommandLine) && e.sourceOwner() instanceof PopUpInterface && (error = e.getError()) != null) {
            PopUpEditor editor = (PopUpEditor)this.windows.get(error.getFileName());
            if (editor == null) {
                editor = new PopUpEditor(this.workspace, error.getFileName());
            }
            editor.addError(error.toString(), error, e.sourceOwner());
        }
    }

    public void handleRemoveAllJobsEvent(RemoveAllJobsEvent e) {
        Enumeration i = this.windows.elements();
        while (i.hasMoreElements()) {
            ((PopUpEditor)i.nextElement()).clearErrors();
        }
    }

    public void handlePopUpLoadedEvent(PopUpLoadedEvent e) {
        e.editor().load();
    }

    public void handlePopUpAddedEvent(PopUpAddedEvent e) {
        PopUpEditor editor = e.editor();
        editor.cleanse();
        editor.setVisible(true);
        this.windows.put(editor.fileName(), editor);
        editor.requestFocus();
    }

    public void handlePopUpSavedEvent(PopUpSavedEvent e) {
        e.editor().save();
    }

    public void handlePopUpDestroyEvent(PopUpDestroyEvent e) {
        this.windows.remove(e.editor().fileName());
    }

    public void handleRuntimeErrorEvent(RuntimeErrorEvent e) {
        if (e.sourceOwner() instanceof PopUpInterface && !(e.jobOwner() instanceof MonitorWidget)) {
            String filename = ((PopUpInterface)e.sourceOwner()).getFileName();
            PopUpEditor editor = (PopUpEditor)this.windows.get(filename);
            if (editor == null) {
                editor = new PopUpEditor(this.workspace, filename);
            } else {
                editor.requestFocus();
            }
            editor.select(e.pos(), e.pos() + e.length());
        }
    }

    public PopUpEditor getEditor(String fileName) {
        return (PopUpEditor)this.windows.get(fileName);
    }

    public PopUpManager(GUIWorkspace workspace) {
        this.workspace = workspace;
        this.windows = new Hashtable();
    }
}

