/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.app.PopUpEditor;
import org.nlogo.awt.Utils;
import org.nlogo.compiler.Compiler;
import org.nlogo.swing.ToolBarMenu;

strictfp class PopUpProceduresMenu
extends ToolBarMenu {
    private final PopUpEditor target;
    private Map procsTable;

    protected void populate(JPopupMenu menu) {
        this.procsTable = Compiler.findProcedurePositions(this.target.innerSource());
        ArrayList<String> procs = new ArrayList<String>();
        Iterator procsIter = this.procsTable.values().iterator();
        while (procsIter.hasNext()) {
            procs.add((String)((List)procsIter.next()).get(0));
        }
        if (procs.isEmpty()) {
            JMenuItem nullItem = new JMenuItem("<No Procedures Defined>");
            nullItem.setEnabled(false);
            menu.add(nullItem);
        } else {
            Collections.sort(procs, String.CASE_INSENSITIVE_ORDER);
            int i = 0;
            while (i < procs.size()) {
                final String proc = (String)procs.get(i);
                JMenuItem item = new JMenuItem(proc);
                item.addActionListener(new ActionListener(){

                    public final void actionPerformed(ActionEvent e) {
                        PopUpProceduresMenu.this.menuSelection(proc);
                    }
                });
                menu.add(item);
                ++i;
            }
        }
    }

    protected void menuSelection(final String s) {
        List index = (List)this.procsTable.get(s);
        int toPos = (Integer)index.get(1);
        final int namePos = (Integer)index.get(2);
        int endPos = (Integer)index.get(3);
        this.target.select(endPos, endPos);
        Utils.invokeLater(new Runnable(){

            public final void run() {
                PopUpProceduresMenu.this.target.select(namePos, namePos + s.length());
            }
        });
    }

    PopUpProceduresMenu(PopUpEditor target) {
        super("Procedures");
        this.target = target;
    }
}

