/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.app.ProceduresMenuTarget;
import org.nlogo.awt.Utils;
import org.nlogo.compiler.Compiler;
import org.nlogo.swing.ToolBarMenu;

strictfp class ProceduresMenu
extends ToolBarMenu {
    private final ProceduresMenuTarget target;
    private Map procsTable;

    protected void populate(JPopupMenu menu) {
        this.procsTable = Compiler.findProcedurePositions(this.target.getText());
        ArrayList procs = new ArrayList();
        Iterator procsIter = this.procsTable.values().iterator();
        while (procsIter.hasNext()) {
            procs.add(((List)procsIter.next()).get(0));
        }
        if (procs.isEmpty()) {
            JMenuItem nullItem = new JMenuItem("<No Procedures Defined>");
            nullItem.setEnabled(false);
            menu.add(nullItem);
        } else {
            Collections.sort(procs, String.CASE_INSENSITIVE_ORDER);
            int i = 0;
            while (i < procs.size()) {
                final String proc = (String)procs.get(i);
                JMenuItem item = new JMenuItem(proc);
                item.addActionListener(new ActionListener(){

                    public final void actionPerformed(ActionEvent e) {
                        ProceduresMenu.this.menuSelection(proc);
                    }
                });
                menu.add(item);
                ++i;
            }
        }
    }

    protected void menuSelection(final String s) {
        List index = (List)this.procsTable.get(s);
        final int namePos = (Integer)index.get(2);
        int endPos = (Integer)index.get(3);
        this.target.select(endPos, endPos);
        Utils.invokeLater(new Runnable(){

            public final void run() {
                ProceduresMenu.this.target.select(namePos, namePos + s.length());
            }
        });
    }

    ProceduresMenu(ProceduresMenuTarget target) {
        super("Procedures");
        this.target = target;
    }
}

