/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.nlogo.app.ErrorsTab;
import org.nlogo.app.InfoTab;
import org.nlogo.app.InterfaceTab;
import org.nlogo.app.ProceduresTab;
import org.nlogo.app.TabsMenu;
import org.nlogo.awt.Utils;
import org.nlogo.event.CompiledEvent;
import org.nlogo.event.LoadBeginEvent;
import org.nlogo.event.RuntimeErrorEvent;
import org.nlogo.event.SwitchedTabsEvent;
import org.nlogo.swing.Printable;
import org.nlogo.swing.PrinterManager;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.JobWidget;
import org.nlogo.window.MonitorWidget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class Tabs
extends JTabbedPane
implements ChangeListener,
SwitchedTabsEvent.Raiser,
LoadBeginEvent.Handler,
RuntimeErrorEvent.Handler,
CompiledEvent.Handler {
    final GUIWorkspace workspace;
    Component previousTab;
    Component currentTab;
    final ProceduresTab proceduresTab;
    final InterfaceTab interfaceTab;
    final InfoTab infoTab;
    final ErrorsTab errorsTab;
    TabsMenu tabsMenu;
    public Action printAction;

    void init() {
        this.addTab("Interface", this.interfaceTab);
        this.addTab("Information", this.infoTab);
        this.addTab("Procedures", this.proceduresTab);
        this.addTab("Errors", this.errorsTab);
        this.tabsMenu = new TabsMenu(this);
    }

    public void stateChanged(ChangeEvent e) {
        this.previousTab = this.currentTab;
        this.currentTab = this.getSelectedComponent();
        this.currentTab.requestFocus();
        new SwitchedTabsEvent(this, this.previousTab, this.currentTab).raise();
    }

    public void errorFixed() {
        if (this.currentTab == this.errorsTab) {
            this.setSelectedComponent(this.previousTab);
        }
    }

    public void requestFocus() {
        this.currentTab.requestFocus();
    }

    public void handleLoadBeginEvent(LoadBeginEvent e) {
        this.setSelectedComponent(this.interfaceTab);
    }

    public void handleRuntimeErrorEvent(final RuntimeErrorEvent e) {
        if (e.sourceOwner() == this.proceduresTab && !(e.jobOwner() instanceof MonitorWidget)) {
            this.setSelectedComponent(this.proceduresTab);
            Utils.invokeLater(new Runnable(){

                public final void run() {
                    Tabs.this.proceduresTab.select(e.pos(), e.pos() + e.length());
                }
            });
        }
    }

    public void handleCompiledEvent(CompiledEvent e) {
        if (e.sourceOwner() == this.proceduresTab) {
            boolean bl = false;
            if (e.getError() != null) {
                bl = true;
            }
            this.showErrorInTab(this.proceduresTab, bl);
            if (e.getError() != null) {
                this.setSelectedComponent(this.errorsTab);
            }
        }
        if (!(e.sourceOwner() instanceof JobWidget) || !((JobWidget)e.sourceOwner()).isCommandCenter()) {
            boolean bl = false;
            if (e.getError() != null) {
                bl = true;
            }
            this.showErrorInTab(this.errorsTab, bl);
            if (e.sourceOwner() != this.proceduresTab || e.getError() == null) {
                boolean bl2 = false;
                if (e.getError() != null) {
                    bl2 = true;
                }
                this.showErrorInTab(this.interfaceTab, bl2);
            }
        }
    }

    private final void showErrorInTab(Component component, boolean hasError) {
        int index = this.indexOfComponent(component);
        this.setForegroundAt(index, hasError ? Color.RED : null);
        if (component == this.errorsTab) {
            this.setEnabledAt(index, hasError);
            this.tabsMenu.getItem(index).setEnabled(hasError);
        }
    }

    private final /* synthetic */ void this() {
        this.printAction = new PrintAction();
    }

    Tabs(GUIWorkspace workspace) {
        this.this();
        this.workspace = workspace;
        this.setOpaque(false);
        this.setFocusable(false);
        this.addChangeListener(this);
        this.interfaceTab = new InterfaceTab(workspace);
        this.infoTab = new InfoTab();
        this.errorsTab = new ErrorsTab(workspace, this);
        this.proceduresTab = new ProceduresTab(workspace, this.errorsTab);
        this.previousTab = this.interfaceTab;
        this.currentTab = this.interfaceTab;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class PrintAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (Tabs.this.currentTab instanceof Printable) {
                PrinterManager.print((Printable)((Object)Tabs.this.currentTab), Tabs.this.workspace.modelNameForDisplay());
            }
        }

        PrintAction() {
            super("print-current-tab");
        }
    }
}

