/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.app.InterfacePanel;
import org.nlogo.app.WindowBar;
import org.nlogo.awt.Utils;
import org.nlogo.event.DirtyEvent;
import org.nlogo.event.EditWidgetEvent;
import org.nlogo.event.WidgetForegroundedEvent;
import org.nlogo.event.WidgetSelectedEvent;
import org.nlogo.properties.WidgetWrapperInterface;
import org.nlogo.swing.WrappingPopupMenu;
import org.nlogo.window.Editable;
import org.nlogo.window.TextBoxWidget;
import org.nlogo.window.Widget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class WidgetWrapper
extends JLayeredPane
implements WidgetWrapperInterface,
MouseListener,
MouseMotionListener,
DirtyEvent.Raiser,
EditWidgetEvent.Raiser,
WidgetForegroundedEvent.Raiser,
WidgetForegroundedEvent.Handler,
WidgetSelectedEvent.Raiser {
    private static final double PREFERRED_WIDTH_FUDGE_FACTOR = 0.15;
    private static final Color NON_FOREGROUND_BACKGROUND = new Color(205, 205, 205);
    private static final int MOUSE_IDLE = 0;
    private static final int MOUSE_DRAG = 1;
    static final int BORDER_N = 10;
    static final int BORDER_S = 9;
    static final int BORDER_E = 9;
    static final int BORDER_W = 9;
    static final int HANDLE_WIDTH = 9;
    private static final int MIN_WIDGET_WIDTH = 12;
    private static final int MIN_WIDGET_HEIGHT = 12;
    private boolean verticallyResizable;
    private final MouseListener popupListener;
    private boolean selected;
    private boolean isForeground;
    private final Widget widget;
    private final InterfacePanel interfacePanel;
    private JComponent glass;
    private WindowBar topBar;
    private WindowBar leftBar;
    private WindowBar rightBar;
    private WindowBar bottomBar;
    private int mouseMode;
    public int startPressX;
    public int startPressY;
    public Rectangle originalBounds;
    private boolean constrainToHorizontal;
    private boolean constrainToVertical;

    public boolean isValidateRoot() {
        return true;
    }

    public boolean selected() {
        return this.selected;
    }

    void selected(boolean selected) {
        this.selected(selected, false);
    }

    void selected(boolean selected, boolean temporary) {
        boolean changed = this.selected ^ selected;
        if (changed) {
            this.selected = selected;
            Rectangle bounds = this.getBounds();
            if (selected) {
                bounds.x -= 9;
                bounds.width += 18;
                bounds.y -= 10;
                bounds.height += 19;
            } else {
                this.isForeground(false);
                bounds.x += 9;
                bounds.width -= 18;
                bounds.y += 10;
                bounds.height -= 19;
            }
            this.setBounds(bounds);
            if (!temporary) {
                new WidgetSelectedEvent(this, this.widget, selected).raise();
            }
        }
    }

    private final void revalidateInterfacePanel() {
        if (this.interfacePanel() != null) {
            this.interfacePanel().revalidate();
        }
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean bl = false;
        if (this.getWidth() != width || this.getHeight() != height) {
            bl = true;
        }
        boolean sizeChanged = bl;
        super.setBounds(x, y, width, height);
        if (sizeChanged) {
            this.doLayout();
            this.revalidateInterfacePanel();
        }
    }

    boolean isForeground() {
        return this.isForeground;
    }

    void isForeground(boolean isForeground) {
        this.isForeground = isForeground;
        if (isForeground) {
            this.topBar.setBackground(Color.GRAY);
            this.leftBar.setBackground(Color.GRAY);
            this.rightBar.setBackground(Color.GRAY);
            this.bottomBar.setBackground(Color.GRAY);
            this.topBar.setForeground(Color.BLACK);
            this.leftBar.setForeground(Color.BLACK);
            this.rightBar.setForeground(Color.BLACK);
            this.bottomBar.setForeground(Color.BLACK);
        } else {
            this.topBar.setBackground(NON_FOREGROUND_BACKGROUND);
            this.leftBar.setBackground(NON_FOREGROUND_BACKGROUND);
            this.rightBar.setBackground(NON_FOREGROUND_BACKGROUND);
            this.bottomBar.setBackground(NON_FOREGROUND_BACKGROUND);
            this.topBar.setForeground(Color.GRAY);
            this.leftBar.setForeground(Color.GRAY);
            this.rightBar.setForeground(Color.GRAY);
            this.bottomBar.setForeground(Color.GRAY);
        }
        this.topBar.repaint();
        this.leftBar.repaint();
        this.rightBar.repaint();
        this.bottomBar.repaint();
    }

    void foreground() {
        if (!this.isForeground()) {
            this.isForeground(true);
            new WidgetForegroundedEvent(this, this.widget).raise();
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(this.widget.getUnzoomedPreferredSize());
        if (this.widget instanceof TextBoxWidget) {
            dim = new Dimension(this.widget.getPreferredSize());
        }
        if (this.widget.needsPreferredWidthFudgeFactor()) {
            dim.width = (int)((double)dim.width * 1.15);
        }
        if (this.getParent() instanceof InterfacePanel && !(this.widget instanceof TextBoxWidget)) {
            InterfacePanel iP = (InterfacePanel)this.getParent();
            dim = iP.zoomer.zoomSize(dim);
        }
        if (this.selected()) {
            dim.width += 18;
            dim.height += 19;
        }
        return dim;
    }

    public void doLayout() {
        if (this.selected()) {
            this.topBar.setVisible(true);
            this.leftBar.setVisible(true);
            this.rightBar.setVisible(true);
            this.bottomBar.setVisible(true);
            this.topBar.setBounds(0, 0, this.getWidth(), 10);
            this.widget.setBounds(9, 10, this.getWidth() - 18, this.getHeight() - 19);
            this.leftBar.setBounds(0, 10, 9, this.getHeight() - 10 - 9);
            this.rightBar.setBounds(this.getWidth() - 9, 10, 9, this.getHeight() - 10 - 9);
            this.bottomBar.setBounds(0, this.getHeight() - 9, this.getWidth(), 9);
        } else {
            this.topBar.setVisible(false);
            this.leftBar.setVisible(false);
            this.rightBar.setVisible(false);
            this.bottomBar.setVisible(false);
            this.topBar.setBounds(0, 0, 0, 0);
            this.leftBar.setBounds(0, 0, 0, 0);
            this.rightBar.setBounds(0, 0, 0, 0);
            this.bottomBar.setBounds(0, 0, 0, 0);
            this.widget.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
        this.glass.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.glass.setVisible(this.selected());
    }

    public Widget widget() {
        return this.widget;
    }

    InterfacePanel interfacePanel() {
        return this.interfacePanel;
    }

    private final int mouseMode() {
        return this.mouseMode;
    }

    private final void mouseMode(int mouseMode) {
        this.mouseMode = mouseMode;
    }

    void doResize(int x, int y) {
        Rectangle bounds = new Rectangle(this.originalBounds);
        switch (this.mouseMode()) {
            case 3: {
                y = StrictMath.max(y, 10 - bounds.y);
                bounds.x += x;
                bounds.width -= x;
                bounds.y += y;
                bounds.height -= y;
                break;
            }
            case 2: {
                y = StrictMath.max(y, 10 - bounds.y);
                bounds.width += x;
                bounds.y += y;
                bounds.height -= y;
                break;
            }
            case 5: {
                bounds.x += x;
                bounds.width -= x;
                bounds.height += y;
                break;
            }
            case 7: {
                bounds.x += x;
                bounds.width -= x;
                break;
            }
            case 4: {
                bounds.width += x;
                bounds.height += y;
                break;
            }
            case 8: {
                bounds.width += x;
                break;
            }
            case 6: {
                bounds.height += y;
                break;
            }
            case 9: {
                y = StrictMath.max(y, 10 - bounds.y);
                bounds.y += y;
                bounds.height -= y;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.enforceMinimumSize(bounds);
        this.enforceMaximumSize(bounds);
        this.setBounds(this.widget.constrainDrag(bounds, this.originalBounds, this.mouseMode()));
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
            return;
        }
        if (!Utils.button1Mask(e)) {
            return;
        }
        this.foreground();
        if (e.getClickCount() == 2) {
            new EditWidgetEvent(this, null, false).raise();
            return;
        }
        Dimension d = this.getSize();
        int x = e.getX();
        int y = e.getY();
        Point p = new Point(x, y);
        Utils.convertPointToScreen(p, this);
        this.startPressX = p.x;
        this.startPressY = p.y;
        this.mouseMode(1);
        if (x < 9) {
            if (this.verticallyResizable && y < 10) {
                this.mouseMode(3);
            } else if (this.verticallyResizable && y > d.height - 9) {
                this.mouseMode(5);
            } else if (y <= 10 + (d.height - 9 - 10 - 9) / 2 + 9 && y >= 10 + (d.height - 9 - 10 - 9) / 2) {
                this.mouseMode(7);
            }
        } else if (x > d.width - 9) {
            if (this.verticallyResizable && y < 10) {
                this.mouseMode(2);
            } else if (this.verticallyResizable && y > d.height - 9) {
                this.mouseMode(4);
            } else if (y <= 10 + (d.height - 9 - 10 - 9) / 2 + 9 && y >= 10 + (d.height - 9 - 10 - 9) / 2) {
                this.mouseMode(8);
            }
        } else if (this.verticallyResizable && y > d.height - 9) {
            if (x <= 9 + (d.width - 9 - 9 + 9) / 2 && x >= 9 + (d.width - 9 - 9 - 9) / 2) {
                this.mouseMode(6);
            }
        } else if (this.verticallyResizable && y < 10 && x <= 9 + (d.width - 9 - 9 + 9) / 2 && x >= 9 + (d.width - 9 - 9 - 9) / 2) {
            this.mouseMode(9);
        }
        if (this.mouseMode() == 1) {
            this.interfacePanel().aboutToDragSelectedWidgets(this.startPressX, this.startPressY);
        } else {
            this.aboutToDrag();
        }
    }

    void aboutToDrag() {
        this.selected(false, true);
        this.originalBounds = this.getBounds();
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Point p = new Point(x, y);
        Utils.convertPointToScreen(p, this);
        x = p.x;
        y = p.y;
        if (this.mouseMode() == 1) {
            if ((e.getModifiers() & 1) == 0) {
                this.constrainToHorizontal = false;
                this.constrainToVertical = false;
            } else {
                if (!this.constrainToHorizontal && !this.constrainToVertical && StrictMath.abs(x - this.startPressX) > StrictMath.abs(y - this.startPressY)) {
                    this.constrainToHorizontal = true;
                } else {
                    this.constrainToVertical = true;
                }
                if (this.constrainToHorizontal) {
                    y = this.startPressY;
                } else if (this.constrainToVertical) {
                    x = this.startPressX;
                }
            }
            this.interfacePanel().dragSelectedWidgets(x - this.startPressX, y - this.startPressY);
        } else if (this.mouseMode() == 2 || this.mouseMode() == 3 || this.mouseMode() == 4 || this.mouseMode() == 5 || this.mouseMode() == 6 || this.mouseMode() == 7 || this.mouseMode() == 8 || this.mouseMode() == 9) {
            this.doResize(x - this.startPressX, y - this.startPressY);
        }
    }

    void doDrag(int x, int y) {
        this.setLocation(x + this.originalBounds.x, y + this.originalBounds.y);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
            return;
        }
        if (Utils.button1Mask(e)) {
            if (this.mouseMode() == 1) {
                this.interfacePanel().dropSelectedWidgets();
            } else if (this.mouseMode() == 2 || this.mouseMode() == 3 || this.mouseMode() == 4 || this.mouseMode() == 5 || this.mouseMode() == 6 || this.mouseMode() == 7 || this.mouseMode() == 8 || this.mouseMode() == 9) {
                this.doDrop();
            }
            this.mouseMode(0);
        }
    }

    void doDrop() {
        this.selected(true, true);
        new DirtyEvent(this).raise();
        ((InterfacePanel)this.getParent()).zoomer.updateZoomInfo(this.widget);
    }

    private final void enforceMinimumSize(Rectangle r) {
        if (this.widget() != null) {
            Dimension minWidgetSize = this.widget().getMinimumSize();
            if (this.getParent() instanceof InterfacePanel) {
                InterfacePanel iP = (InterfacePanel)this.getParent();
                minWidgetSize = iP.zoomer.zoomSize(minWidgetSize);
            }
            if (minWidgetSize == null) {
                minWidgetSize = new Dimension(12, 12);
            }
            if (minWidgetSize.width < 12) {
                minWidgetSize.width = 12;
            }
            if (minWidgetSize.height < 12) {
                minWidgetSize.height = 12;
            }
            switch (this.mouseMode()) {
                case 6: {
                    if (r.height >= minWidgetSize.height) break;
                    r.height = minWidgetSize.height;
                    break;
                }
                case 5: {
                    if (r.width < minWidgetSize.width) {
                        r.x -= minWidgetSize.width - r.width;
                        r.width = minWidgetSize.width;
                    }
                    if (r.height >= minWidgetSize.height) break;
                    r.height = minWidgetSize.height;
                    break;
                }
                case 4: {
                    if (r.width < minWidgetSize.width) {
                        r.width = minWidgetSize.width;
                    }
                    if (r.height >= minWidgetSize.height) break;
                    r.height = minWidgetSize.height;
                    break;
                }
                case 8: {
                    if (r.width >= minWidgetSize.width) break;
                    r.width = minWidgetSize.width;
                    break;
                }
                case 3: {
                    if (r.width < minWidgetSize.width) {
                        r.x -= minWidgetSize.width - r.width;
                        r.width = minWidgetSize.width;
                    }
                    if (r.height >= minWidgetSize.height) break;
                    r.y -= minWidgetSize.height - r.height;
                    r.height = minWidgetSize.height;
                    break;
                }
                case 7: {
                    if (r.width >= minWidgetSize.width) break;
                    r.x -= minWidgetSize.width - r.width;
                    r.width = minWidgetSize.width;
                    break;
                }
                case 2: {
                    if (r.width < minWidgetSize.width) {
                        r.width = minWidgetSize.width;
                    }
                    if (r.height >= minWidgetSize.height) break;
                    r.y -= minWidgetSize.height - r.height;
                    r.height = minWidgetSize.height;
                    break;
                }
                case 9: {
                    if (r.height >= minWidgetSize.height) break;
                    r.y -= minWidgetSize.height - r.height;
                    r.height = minWidgetSize.height;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private final void enforceMaximumSize(Rectangle r) {
        if (this.widget() != null) {
            Dimension maxWidgetSize = this.widget().getMaximumSize();
            if (maxWidgetSize == null) {
                return;
            }
            if (maxWidgetSize.height <= 0) {
                maxWidgetSize.height = 10000;
            }
            if (maxWidgetSize.width <= 0) {
                maxWidgetSize.width = 10000;
            }
            if (this.getParent() instanceof InterfacePanel) {
                InterfacePanel iP = (InterfacePanel)this.getParent();
                maxWidgetSize = iP.zoomer.zoomSize(maxWidgetSize);
            }
            switch (this.mouseMode()) {
                case 6: {
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    break;
                }
                case 5: {
                    if (r.width > maxWidgetSize.width) {
                        r.width = maxWidgetSize.width;
                    }
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    break;
                }
                case 4: {
                    if (r.width > maxWidgetSize.width) {
                        r.width = maxWidgetSize.width;
                        r.x = this.getBounds().x + this.getBounds().width - r.width;
                    }
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    break;
                }
                case 8: {
                    if (r.width <= maxWidgetSize.width) break;
                    r.width = maxWidgetSize.width;
                    r.x = this.getBounds().x + this.getBounds().width - r.width;
                    break;
                }
                case 3: {
                    if (r.width > maxWidgetSize.width) {
                        r.width = maxWidgetSize.width;
                    }
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    r.y = this.getBounds().y + this.getBounds().height - r.height;
                    break;
                }
                case 7: {
                    if (r.width <= maxWidgetSize.width) break;
                    r.width = maxWidgetSize.width;
                    break;
                }
                case 2: {
                    if (r.width > maxWidgetSize.width) {
                        r.width = maxWidgetSize.width;
                        r.x = this.getBounds().x + this.getBounds().width - r.width;
                    }
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    r.y = this.getBounds().y + this.getBounds().height - r.height;
                    break;
                }
                case 9: {
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    r.y = this.getBounds().y + this.getBounds().height - r.height;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    void widgetResized() {
        Rectangle rect = this.getBounds();
        rect.width = this.widget().getWidth();
        rect.height = this.widget().getHeight();
        if (this.selected()) {
            rect.width += 18;
            rect.height += 19;
        }
        super.setBounds(rect);
        this.revalidateInterfacePanel();
    }

    public void handleWidgetForegroundedEvent(WidgetForegroundedEvent e) {
        if (!e.widget().equals(this.widget)) {
            this.isForeground(false);
        }
    }

    Point getUnselectedLocation() {
        Point result = this.getLocation();
        if (this.selected()) {
            result.x += 9;
            result.y += 10;
        }
        return result;
    }

    Rectangle getUnselectedBounds() {
        Rectangle result = this.getBounds();
        if (this.selected()) {
            result.x += 9;
            result.y += 10;
            result.width -= 18;
            result.height -= 19;
        }
        return result;
    }

    private final void doPopup(MouseEvent e) {
        if (this.interfacePanel() != null) {
            WrappingPopupMenu menu = new WrappingPopupMenu();
            this.populateContextMenu(menu, e.getPoint());
            if (menu.getSubElements().length > 0) {
                ((JPopupMenu)menu).show((Component)e.getSource(), e.getX(), e.getY());
            }
            e.consume();
        }
    }

    private final void populateContextMenu(JPopupMenu menu, Point p) {
        if (this.widget() instanceof Editable) {
            JMenuItem editItem = new JMenuItem("Edit...");
            editItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    WidgetWrapper.this.selected(true);
                    WidgetWrapper.this.foreground();
                    new EditWidgetEvent(WidgetWrapper.this, null, false).raise();
                }
            });
            menu.add(editItem);
        }
        if (this.selected()) {
            JMenuItem unselectItem = new JMenuItem("Unselect");
            unselectItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    WidgetWrapper.this.selected(false);
                    WidgetWrapper.this.interfacePanel().setForegroundWrapper();
                }
            });
            menu.add(unselectItem);
        } else {
            JMenuItem selectItem = new JMenuItem("Select");
            selectItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    WidgetWrapper.this.selected(true);
                    WidgetWrapper.this.foreground();
                }
            });
            menu.add(selectItem);
        }
        if (this.widget().deleteable()) {
            JMenuItem deleteItem = new JMenuItem("Delete");
            deleteItem.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    WidgetWrapper.this.interfacePanel().deleteWidget(WidgetWrapper.this);
                }
            });
            menu.add(new JPopupMenu.Separator());
            menu.add(deleteItem);
        }
        if (this.widget().hasContextMenu()) {
            menu.add(new JPopupMenu.Separator());
            this.widget().populateContextMenu(menu, p);
        }
    }

    private final /* synthetic */ void this() {
        this.verticallyResizable = true;
        this.popupListener = new MouseAdapter(){

            public final void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    WidgetWrapper.this.doPopup(e);
                }
            }

            public final void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    WidgetWrapper.this.doPopup(e);
                }
            }
        };
        this.selected = false;
        this.isForeground = false;
        this.mouseMode = 0;
        this.constrainToHorizontal = false;
        this.constrainToVertical = false;
    }

    WidgetWrapper(Widget widget, InterfacePanel interfacePanel) {
        this.this();
        this.widget = widget;
        this.interfacePanel = interfacePanel;
        this.setOpaque(true);
        if (widget.getMaximumSize() != null && widget.getMaximumSize().height == widget.getMinimumSize().height) {
            this.verticallyResizable = false;
        }
        this.topBar = new WindowBar(0, 9, 9, this.verticallyResizable);
        this.leftBar = new WindowBar(2);
        this.rightBar = new WindowBar(2);
        this.bottomBar = new WindowBar(1, 9, 9, this.verticallyResizable);
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.glass = new JComponent(){};
        this.glass.setOpaque(false);
        this.glass.addMouseListener(this);
        this.glass.addMouseMotionListener(this);
        widget.addPopupListeners(this.popupListener);
        this.setCursor(Cursor.getDefaultCursor());
        this.setLayout(null);
        this.setBackground(widget.getBackground());
        this.add((Component)this.glass, JLayeredPane.DRAG_LAYER);
        this.add(widget);
        this.add(this.topBar);
        this.add(this.leftBar);
        this.add(this.rightBar);
        this.add(this.bottomBar);
        this.doLayout();
    }
}

