/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPanel;
import org.nlogo.awt.Utils;

strictfp class WindowBar
extends JPanel {
    static final int TYPE_TOP = 0;
    static final int TYPE_BOTTOM = 1;
    static final int TYPE_SIDE = 2;
    private final int type;
    private final boolean handles;
    private int eastBorder;
    private int westBorder;

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        switch (this.type) {
            case 0: {
                this.paintTop(g);
                break;
            }
            case 1: {
                this.paintBottom(g);
                break;
            }
            case 2: {
                this.paintSide(g);
                break;
            }
            default: {
                throw new IllegalStateException("type = " + this.type);
            }
        }
    }

    private final void paintTop(Graphics g) {
        Rectangle b = this.getBounds();
        if (b.width == 0 || b.height == 0) {
            return;
        }
        int bleed = 5;
        if (this.westBorder == 0) {
            this.drawConvexRect(g, new Rectangle(-5, b.y, b.width + 5, b.height + 5));
        } else {
            this.drawConvexRect(g, new Rectangle(0, b.y, b.width, b.height + 5));
        }
        Shape oldClip = g.getClip();
        g.setClip(this.westBorder - 2, b.height - 3, this.getWidth() - this.eastBorder - this.westBorder + 3, 3);
        this.drawConvexRect(g, new Rectangle(-5, 0, b.width + 10, b.height));
        g.setClip(oldClip);
        if (this.handles) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.westBorder, b.height);
            g.fillRect(this.westBorder + (b.width - this.eastBorder - this.westBorder - 9) / 2, 0, 9, b.height);
            g.fillRect(b.width - this.eastBorder, 0, this.eastBorder, b.height);
        }
    }

    private final void paintBottom(Graphics g) {
        Shape oldClip = g.getClip();
        Rectangle r = new Rectangle(this.getBounds());
        if (r.width == 0 || r.height == 0) {
            return;
        }
        r.x = 0;
        r.y = -5;
        r.height += 5;
        this.drawConvexRect(g, r);
        r = new Rectangle(this.getBounds());
        r.x = 0;
        r.y = 0;
        g.setClip(this.eastBorder - 1, 0, this.getWidth() - this.eastBorder - this.westBorder + 2, 3);
        this.drawConvexRect(g, r);
        g.setClip(oldClip);
        if (this.handles) {
            Rectangle b = this.getBounds();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.westBorder, b.height);
            g.fillRect(this.westBorder + (b.width - this.eastBorder - this.westBorder - 9) / 2, 0, 9, b.height);
            g.fillRect(b.width - this.eastBorder, 0, this.eastBorder, b.height);
        }
    }

    private final void paintSide(Graphics g) {
        Rectangle r = new Rectangle(this.getBounds());
        if (r.width == 0 || r.height == 0) {
            return;
        }
        r.x = 0;
        r.y = -5;
        r.height += 10;
        this.drawConvexRect(g, r);
        Rectangle b = this.getBounds();
        g.setColor(Color.BLACK);
        g.fillRect(0, (b.height - 9) / 2, b.width, 9);
    }

    private final void drawConvexRect(Graphics g, Rectangle r) {
        g.setColor(Utils.mixColors(this.getForeground(), this.getBackground(), 0.5));
        g.drawLine(r.x, r.y, r.x + r.width - 1, r.y);
        g.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
        g.setColor(Color.WHITE);
        g.drawLine(r.x + 2, r.y + 2, r.x + r.width - 4, r.y + 2);
        g.drawLine(r.x + 2, r.y + 2, r.x + 2, r.y + r.height - 4);
        g.setColor(this.getForeground());
        g.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
        g.drawLine(r.x + r.width - 1, r.y, r.x + r.width - 1, r.y + r.height - 1);
        g.setColor(Utils.mixColors(this.getForeground(), this.getBackground(), 0.75));
        g.drawLine(r.x + 1, r.y + r.height - 2, r.x + r.width - 2, r.y + r.height - 2);
        g.drawLine(r.x + r.width - 2, r.y + 1, r.x + r.width - 2, r.y + r.height - 2);
        g.setColor(Utils.mixColors(this.getForeground(), this.getBackground(), 0.25));
        g.drawLine(r.x + 2, r.y + r.height - 3, r.x + r.width - 3, r.y + r.height - 3);
        g.drawLine(r.x + r.width - 3, r.y + 2, r.x + r.width - 3, r.y + r.height - 3);
    }

    WindowBar(int type) {
        this.type = type;
        this.eastBorder = 0;
        this.westBorder = 0;
        this.handles = true;
        this.setBackground(Color.GRAY);
        this.setOpaque(true);
    }

    WindowBar(int type, int eastBorder, int westBorder, boolean handles) {
        this.type = type;
        this.eastBorder = eastBorder;
        this.westBorder = westBorder;
        this.handles = handles;
        this.setBackground(Color.GRAY);
        this.setOpaque(true);
    }
}

