/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.agentmon;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JWindow;
import javax.swing.LayoutFocusTraversalPolicy;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Observer;
import org.nlogo.app.agentmon.AgentMonitor;
import org.nlogo.app.agentmon.MonitorManager;
import org.nlogo.app.agentmon.ObserverMonitor;
import org.nlogo.app.agentmon.PatchMonitor;
import org.nlogo.app.agentmon.TurtleMonitor;
import org.nlogo.event.Event;
import org.nlogo.event.EventLinkComponent;
import org.nlogo.event.LoadBeginEvent;
import org.nlogo.event.PatchesCreatedEvent;
import org.nlogo.event.PeriodicUpdateEvent;
import org.nlogo.swing.Utils;
import org.nlogo.swing.WindowDragger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class MonitorWindow
extends JWindow
implements EventLinkComponent,
PeriodicUpdateEvent.Handler,
PatchesCreatedEvent.Handler,
LoadBeginEvent.Handler {
    private static final boolean NEEDS_BORDER = System.getProperty("os.name").startsWith("Mac") ^ true;
    private AgentMonitor monitor;
    private MonitorManager manager;
    private final WindowDragger dragger;
    private boolean wasShiftDownOnCloseBox;
    private boolean dead;
    private String lastAliveTitle;
    static /* synthetic */ Class class$org$nlogo$agent$Observer;
    static /* synthetic */ Class class$org$nlogo$agent$Turtle;

    public Object getLinkParent() {
        return this.manager;
    }

    public void requestFocus() {
        this.monitor.requestFocus();
    }

    public Agent agent() {
        return this.monitor.agent();
    }

    void close() {
        this.setVisible(false);
        this.manager.remove(this);
        this.dispose();
        Event.rehash();
    }

    void refresh() {
        if (!this.dead && this.agent() != null && this.agent().id == -1) {
            this.dead = true;
            this.dragger.setTitle(this.title());
        }
        Dimension oldPref = this.monitor.getPreferredSize();
        this.monitor.refresh();
        Dimension newPref = this.monitor.getPreferredSize();
        if (!oldPref.equals(newPref)) {
            this.pack();
        }
    }

    String title() {
        Class clazz = this.monitor.agentClass();
        Class clazz2 = class$org$nlogo$agent$Observer;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Observer = MonitorWindow.class("[Lorg.nlogo.agent.Observer;", false);
        }
        if (clazz == clazz2) {
            return "Globals";
        }
        Class clazz3 = this.monitor.agentClass();
        Class clazz4 = class$org$nlogo$agent$Turtle;
        if (clazz4 == null) {
            clazz4 = class$org$nlogo$agent$Turtle = MonitorWindow.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        if (clazz3 == clazz4) {
            if (this.agent() == null) {
                return "(no turtle)";
            }
            if (this.agent().id == -1) {
                return this.lastAliveTitle + " (dead)";
            }
            this.lastAliveTitle = this.agent().toString();
            return this.lastAliveTitle;
        }
        return this.agent() == null ? "(no patch)" : this.agent().toString();
    }

    public void agentChangeNotify(Agent oldAgent) {
        boolean bl = false;
        if (this.agent() != null && this.agent().id == -1) {
            bl = true;
        }
        this.dead = bl;
        this.dragger.setTitle(this.title());
        this.manager.agentChangeNotify(this, oldAgent);
        this.pack();
    }

    public void handleLoadBeginEvent(LoadBeginEvent e) {
        this.close();
    }

    public void handlePeriodicUpdateEvent(PeriodicUpdateEvent e) {
        this.refresh();
    }

    public void handlePatchesCreatedEvent(PatchesCreatedEvent e) {
        if (!(this.agent() instanceof Observer)) {
            this.close();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.dragger = new WindowDragger(this);
        this.wasShiftDownOnCloseBox = false;
        this.dead = false;
    }

    MonitorWindow(Class agentClass, Agent agent, final MonitorManager manager, Frame frame) {
        super(frame);
        this.this();
        this.manager = manager;
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = MonitorWindow.class("[Lorg.nlogo.agent.Observer;", false);
        }
        if (agentClass == clazz) {
            this.monitor = new ObserverMonitor(manager.workspace);
        } else {
            Class clazz2 = class$org$nlogo$agent$Turtle;
            if (clazz2 == null) {
                clazz2 = class$org$nlogo$agent$Turtle = MonitorWindow.class("[Lorg.nlogo.agent.Turtle;", false);
            }
            this.monitor = agentClass == clazz2 ? new TurtleMonitor(manager.workspace) : new PatchMonitor(manager.workspace);
        }
        this.monitor.agent(agent);
        if (NEEDS_BORDER) {
            this.getRootPane().setBorder(BorderFactory.createRaisedBevelBorder());
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.monitor, "Center");
        this.getContentPane().add((Component)this.dragger, "North");
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                if (!MonitorWindow.this.wasShiftDownOnCloseBox) {
                    MonitorWindow.this.close();
                } else {
                    manager.closeAll();
                }
            }
        });
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            public final Component getFirstComponent(Container focusCycleRoot) {
                return ((MonitorWindow)MonitorWindow.this).monitor.commandLine.textField;
            }
        });
        this.dragger.getCloseBox().addMouseListener(new MouseAdapter(){

            public final void mousePressed(MouseEvent e) {
                MonitorWindow.this.wasShiftDownOnCloseBox = e.isShiftDown();
            }
        });
        Utils.addEscKeyAction(this, (Action)new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                MonitorWindow.this.close();
            }
        });
        this.agentChangeNotify(null);
    }
}

