/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.awt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.roydesign.mac.MRJAdapter;
import org.nlogo.util.BrowserLauncher;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class Utils {
    static /* synthetic */ Class class$org$nlogo$awt$Utils;

    public static void printComponentTree(Component root) {
        Utils.walkComponentTree(root, 0, new ComponentTreeWalker(){

            public final void touch(Component comp, int level) {
                System.out.println(Utils.indent(level * 2) + comp.getClass() + ", bounds: " + comp.getBounds());
            }
        });
    }

    private static final String indent(int n) {
        StringBuffer result = new StringBuffer(n);
        int i = 0;
        while (i < n) {
            result.append(' ');
            ++i;
        }
        return result.toString();
    }

    private static final void walkComponentTree(Component comp, int level, ComponentTreeWalker walker) {
        walker.touch(comp, level);
        if (comp instanceof Container) {
            Component[] components = ((Container)comp).getComponents();
            int i = 0;
            while (i < components.length) {
                Utils.walkComponentTree(components[i], level + 1, walker);
                ++i;
            }
        }
    }

    public static void convertPointToScreen(Point p, Component c) {
        do {
            int y;
            int x;
            if (c instanceof Applet || c instanceof Window) {
                Point pp = c.getLocationOnScreen();
                x = pp.x;
                y = pp.y;
            } else {
                x = c.getLocation().x;
                y = c.getLocation().y;
            }
            p.x += x;
            p.y += y;
        } while (!(c instanceof Window) && !(c instanceof Applet) && (c = c.getParent()) != null);
    }

    public static void convertPointFromScreen(Point p, Component c) {
        do {
            int y;
            int x;
            if (c instanceof Applet || c instanceof Window) {
                Point pp = c.getLocationOnScreen();
                x = pp.x;
                y = pp.y;
            } else {
                x = c.getLocation().x;
                y = c.getLocation().y;
            }
            p.x -= x;
            p.y -= y;
        } while (!(c instanceof Window) && !(c instanceof Applet) && (c = c.getParent()) != null);
    }

    public static Point getLocationOnScreen(Component c) {
        Point result = new Point(0, 0);
        Utils.convertPointToScreen(result, c);
        return result;
    }

    public static Point subtractPoints(Point p1, Point p2) {
        return new Point(p1.x - p2.x, p1.y - p2.y);
    }

    public static Frame getFrame(Component comp) {
        Component top = Utils.getTopAncestor(comp);
        if (top instanceof Frame) {
            return (Frame)top;
        }
        if (top instanceof Window && top.getParent() != null) {
            return Utils.getFrame(top.getParent());
        }
        return null;
    }

    public static Window getWindow(Component comp) {
        Component top = Utils.getTopAncestor(comp);
        if (top instanceof Window) {
            return (Window)top;
        }
        return null;
    }

    public static Component getTopAncestor(Component comp) {
        Component top = comp;
        Container parent = top.getParent();
        while (!(top instanceof Window) && parent != null) {
            top = parent;
            parent = top.getParent();
        }
        return top;
    }

    public static boolean hasAncestorOfClass(Component component, Class theClass) {
        boolean bl = false;
        if (component != null && (theClass.isInstance(component) || Utils.hasAncestorOfClass(component.getParent(), theClass))) {
            bl = true;
        }
        return bl;
    }

    public static Container findAncestorOfClass(Component component, Class theClass) {
        if (component == null) {
            return null;
        }
        if (theClass.isInstance(component)) {
            return (Container)component;
        }
        return Utils.findAncestorOfClass(component.getParent(), theClass);
    }

    public static boolean loadImage(Image image) {
        MediaTracker mt = new MediaTracker(new Component(){});
        mt.addImage(image, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException ex) {
            Exceptions.handle(ex);
        }
        return mt.isErrorAny() ^ true;
    }

    public static Image loadImageResource(String path) {
        Image image;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class clazz = class$org$nlogo$awt$Utils;
        if (clazz == null) {
            clazz = class$org$nlogo$awt$Utils = Utils.class("[Lorg.nlogo.awt.Utils;", false);
        }
        return Utils.loadImage(image = toolkit.getImage(clazz.getResource(path))) ? image : null;
    }

    public static Image loadImageFile(String path, boolean cache) {
        Image image = cache ? Toolkit.getDefaultToolkit().getImage(path) : Toolkit.getDefaultToolkit().createImage(path);
        return Utils.loadImage(image) ? image : null;
    }

    public static Color mixColors(Color c1, Color c2, double mix) {
        mix = StrictMath.min(mix, 1.0);
        mix = StrictMath.max(mix, 0.0);
        return new Color((int)((double)c1.getRed() * mix + (double)c2.getRed() * (1.0 - mix)), (int)((double)c1.getGreen() * mix + (double)c2.getGreen() * (1.0 - mix)), (int)((double)c1.getBlue() * mix + (double)c2.getBlue() * (1.0 - mix)));
    }

    public static String shortenStringToFit(String name, int availableWidth, FontMetrics metrics) {
        if (metrics.stringWidth(name) > availableWidth) {
            name = name + "...";
            while (metrics.stringWidth(name) > availableWidth && name.length() > 3) {
                name = name.substring(0, name.length() - 4) + "...";
            }
        }
        return name;
    }

    public static MouseEvent translateMouseEvent(MouseEvent e, Component target, Point offsets) {
        return new MouseEvent(target, e.getID(), e.getWhen(), e.getModifiers(), e.getX() + offsets.x, e.getY() + offsets.y, e.getClickCount(), e.isPopupTrigger());
    }

    public static List breakLines(String text, FontMetrics metrics, int width) {
        ArrayList<String> result = new ArrayList<String>();
        while (text.length() > 0) {
            int spaceIndex;
            int index = 0;
            while (index < text.length() && (metrics.stringWidth(text.substring(0, index + 1)) < width || text.charAt(index) == ' ')) {
                if (text.charAt(index) == '\n') {
                    text = text.substring(0, index) + ' ' + text.substring(index + 1);
                    ++index;
                    break;
                }
                ++index;
            }
            if (index < text.length() && (spaceIndex = text.substring(0, index).lastIndexOf(32)) >= 0) {
                index = spaceIndex + 1;
            }
            String thisLine = text.substring(0, index);
            text = index < text.length() ? text.substring(index, text.length()) : "";
            result.add(thisLine);
        }
        if (result.isEmpty()) {
            result.add("");
        }
        return result;
    }

    public static void center(Window window, Window parent) {
        int y;
        int x;
        if (parent == null) {
            Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            x = center.x - window.getWidth() / 2;
            y = center.y - window.getHeight() / 2;
        } else {
            x = parent.getLocation().x + parent.getWidth() / 2 - window.getPreferredSize().width / 2;
            y = parent.getLocation().y + parent.getHeight() / 2 - window.getPreferredSize().height / 2;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static void moveNextTo(Component c1, Component c2) {
        int SPACE = 4;
        int right = c2.getBounds().x + c2.getBounds().width + 4;
        int below = c2.getBounds().y + c2.getBounds().height + 4;
        int left = c2.getBounds().x - c1.getBounds().width - 4;
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        if (s.width - right - c1.getBounds().width > 0) {
            c1.setLocation(right, c2.getLocation().y);
        } else if (left > 0) {
            c1.setLocation(left, c2.getLocation().y);
        } else if (s.height - below - c1.getBounds().height > 0) {
            c1.setLocation(c2.getLocation().x, below);
        } else {
            c1.setLocation(s.width - c1.getBounds().width, c2.getLocation().y);
        }
    }

    public static boolean button1Mask(MouseEvent e) {
        boolean bl = false;
        if ((e.getModifiers() & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    public static String platformFont() {
        if (System.getProperty("os.name").startsWith("Mac")) {
            return "Lucida Grande";
        }
        return "Sans-serif";
    }

    public static String platformMonospacedFont() {
        if (System.getProperty("os.name").startsWith("Mac")) {
            return "Monaco";
        }
        return "Monospaced";
    }

    public static void adjustDefaultFont(Component comp) {
        if (System.getProperty("os.name").startsWith("Mac")) {
            comp.setFont(new Font(Utils.platformFont(), 0, 11));
        }
    }

    public static void adjustDefaultMonospacedFont(Component comp) {
        if (System.getProperty("os.name").startsWith("Mac")) {
            comp.setFont(new Font(Utils.platformMonospacedFont(), 0, 12));
        }
    }

    public static void mustBeEventDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("not event thread: " + Thread.currentThread());
        }
    }

    public static void cantBeEventDispatchThread() {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException();
        }
    }

    public static String getClipboardAsString(Object requester) {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = kit.getSystemClipboard();
        Transferable transferable = clipboard.getContents(requester);
        if (transferable == null) {
            return null;
        }
        try {
            return (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (IOException ex) {
            return null;
        }
        catch (UnsupportedFlavorException ex) {
            return null;
        }
    }

    public static void openURL(String urlString, boolean local) {
        try {
            if (local) {
                urlString = org.nlogo.util.Utils.makeURLFromFile(new File(urlString));
            }
            if (System.getProperty("os.name").startsWith("Mac")) {
                MRJAdapter.openURL(urlString);
            } else {
                BrowserLauncher.openURL(urlString);
            }
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    public static void invokeLater(Runnable r) {
        EventQueue.invokeLater(r);
    }

    public static void invokeAndWait(Runnable r) throws InterruptedException {
        try {
            EventQueue.invokeAndWait(r);
        }
        catch (InvocationTargetException ex) {
            Exceptions.handle(ex);
        }
    }

    public static BufferedImage paintToImage(Component comp) {
        BufferedImage image = new BufferedImage(comp.getWidth(), comp.getHeight(), 2);
        comp.paint(image.getGraphics());
        return image;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Utils() {
        throw new IllegalStateException();
    }

    private static interface ComponentTreeWalker {
        public void touch(Component var1, int var2);
    }
}

