/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import org.nlogo.agent.AgentSet;
import org.nlogo.agent.LogoList;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.compiler.Compiler;
import org.nlogo.compiler.CompilerException;
import org.nlogo.compiler.Token;
import org.nlogo.compiler.TokenReader;
import org.nlogo.compiler.TokenVector;
import org.nlogo.prim._patch;
import org.nlogo.prim._patches;
import org.nlogo.prim._turtle;
import org.nlogo.prim._turtles;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class ConstantParser {
    private static final String BAD_AGENT = "Not an agent";
    private static final String BAD_PATCH_SET_ARGS = "Patch agentsets are given by a set of 2 element integer lists containing a patch's pxcor and pycor";
    private static final String BAD_PATCH_ARGS = "pxcor and pycor must be floats";
    private static final String BAD_TURTLE_SET_ARGS = "Turtle agentsets are given by a set of turtles' who's (integers)";
    private static final String BAD_TURTLE_ARG = "a turtle's who must be an integer";
    private static final String EXPECTED_BREED = "Expected breed";
    private static final String EXPECTED_CLOSE_BRACE = "Expected closing brace.";
    private static final String EXPECTED_CLOSE_BRACKET = "Expected closing bracket.";
    private static final String EXPECTED_CLOSE_PAREN = "Expected a closing parenthesis.";
    private static final String EXPECTED_CONSTANT = "Expected a constant.";
    private static final String EXPECTED_INT_ETC = "Expected integer, float, list, string or boolean";
    private static final String EXPECTED_OPEN_BRACE = "Expected open brace.";
    private static final String EXPECTED_OPEN_BRACKET = "Internal error: Expected an opening bracket here.";
    private static final String EXTRA_STUFF_AFTER_CONSTANT = "Extra characters after constant.";
    private static final String ILLEGAL_AGENT_CONSTANT = "Can only have constant agents and agentsets if importing.";
    private static final String MISSING_CLOSE_BRACKET = "No closing bracket for this open bracket.";
    private static final String NOT_AN_AGENTSET = " is not an agentset";
    private static final String NOT_A_BREED = " is not a breed";
    private static final String SET_TYPE_ALLPATCHES = "ALL-PATCHES";
    private static final String SET_TYPE_ALLTURTLES = "ALL-TURTLES";
    private static final String SET_TYPE_BREED = "BREED";
    private static final String SET_TYPE_OBSERVER = "OBSERVER";
    static /* synthetic */ Class class$org$nlogo$agent$Observer;
    static /* synthetic */ Class class$org$nlogo$agent$Turtle;
    static /* synthetic */ Class class$org$nlogo$agent$Patch;

    static Object getConstantValue(TokenVector tokens, World world) throws CompilerException {
        Object result = ConstantParser.readConstantPrefix(tokens, world);
        boolean bl = false;
        if (tokens.lookAhead().getType() == 1) {
            bl = true;
        }
        Compiler.cAssert(bl, EXTRA_STUFF_AFTER_CONSTANT, tokens.lookAhead());
        return result;
    }

    static Object getConstantFromFile(TokenReader tokens, World world) throws CompilerException {
        return ConstantParser.readConstantPrefix(tokens, world);
    }

    private static final Object readConstantPrefix(TokenVector tokens, World world) throws CompilerException {
        Object result = null;
        Token token = tokens.lookAhead();
        switch (token.getType()) {
            case 8: {
                tokens.getNextToken();
                result = token.getValue();
                break;
            }
            case 4: {
                result = ConstantParser.parseConstantList(tokens, world);
                boolean bl = false;
                if (tokens.lookAhead().getType() == 5) {
                    bl = true;
                }
                Compiler.cAssert(bl, EXPECTED_CLOSE_BRACKET, tokens.lookAhead());
                tokens.getNextToken();
                break;
            }
            case 6: {
                result = ConstantParser.parseConstantAgentSet(tokens, world);
                token = tokens.lookAhead();
                boolean bl = false;
                if (token.getType() == 7) {
                    bl = true;
                }
                Compiler.cAssert(bl, EXPECTED_CLOSE_BRACE, token);
                tokens.getNextToken();
                break;
            }
            case 2: {
                tokens.getNextToken();
                result = ConstantParser.readConstantPrefix(tokens, world);
                token = tokens.lookAhead();
                boolean bl = false;
                if (token.getType() == 3) {
                    bl = true;
                }
                Compiler.cAssert(bl, EXPECTED_CLOSE_PAREN, token);
                tokens.getNextToken();
                break;
            }
            case 11: {
                boolean bl = false;
                if (world != null) {
                    bl = true;
                }
                Compiler.cAssert(bl, EXPECTED_INT_ETC, token);
                result = ConstantParser.parseConstantAgent(tokens, world);
                break;
            }
            default: {
                throw new CompilerException(EXPECTED_CONSTANT, token);
            }
        }
        return result;
    }

    static LogoList parseConstantList(TokenVector tokens, World world) throws CompilerException {
        Token openBracket = tokens.lookAhead();
        boolean bl = false;
        if (openBracket.getType() == 4) {
            bl = true;
        }
        Compiler.cAssert(bl, EXPECTED_OPEN_BRACKET, openBracket);
        tokens.getNextToken();
        LogoList list = new LogoList();
        boolean done = false;
        while (!done) {
            Token token = tokens.lookAhead();
            switch (token.getType()) {
                case 5: {
                    done = true;
                    break;
                }
                case 1: {
                    throw new CompilerException(MISSING_CLOSE_BRACKET, openBracket);
                }
                default: {
                    list.add(ConstantParser.readConstantPrefix(tokens, world));
                }
            }
        }
        return list;
    }

    private static final Object parseConstantAgent(TokenVector tokens, World world) throws CompilerException {
        Token token = tokens.lookAhead();
        boolean bl = false;
        if (world != null) {
            bl = true;
        }
        Compiler.cAssert(bl, ILLEGAL_AGENT_CONSTANT, token);
        Object agentType = token.getValue();
        if (agentType instanceof _patch) {
            tokens.getNextToken();
            double pxcor = ConstantParser.parsePcor(tokens);
            double pycor = ConstantParser.parsePcor(tokens);
            Patch patch = world.getPatchAt(pxcor, pycor);
            return patch;
        }
        if (agentType instanceof _turtle) {
            tokens.getNextToken();
            token = tokens.lookAhead();
            if (token.getType() == 8 && token.getValue() instanceof Integer) {
                Integer id = (Integer)token.getValue();
                tokens.getNextToken();
                Turtle turtle = world.getOrCreateTurtle(id);
                return turtle;
            }
            throw new CompilerException(BAD_TURTLE_ARG, token);
        }
        throw new CompilerException(BAD_AGENT, token);
    }

    private static final double parsePcor(TokenVector tokens) throws CompilerException {
        Token token = tokens.lookAhead();
        boolean bl = false;
        if (token.getType() == 8 && token.getValue() instanceof Number) {
            bl = true;
        }
        Compiler.cAssert(bl, BAD_PATCH_ARGS, token);
        Number pcor = (Number)token.getValue();
        tokens.getNextToken();
        return pcor.doubleValue();
    }

    private static final Object parseConstantAgentSet(TokenVector tokens, World world) throws CompilerException {
        Token token = tokens.lookAhead();
        boolean bl = false;
        if (world != null) {
            bl = true;
        }
        Compiler.cAssert(bl, ILLEGAL_AGENT_CONSTANT, token);
        boolean bl2 = false;
        if (token.getType() == 6) {
            bl2 = true;
        }
        Compiler.cAssert(bl2, EXPECTED_OPEN_BRACE, token);
        tokens.getNextToken();
        token = tokens.lookAhead();
        boolean bl3 = false;
        if (token.getType() == 9 || token.getType() == 11) {
            bl3 = true;
        }
        Compiler.cAssert(bl3, EXPECTED_BREED, token);
        if (token.getType() == 9) {
            tokens.getNextToken();
            String agentsetTypeString = (String)token.getValue();
            if (agentsetTypeString.equalsIgnoreCase(SET_TYPE_BREED)) {
                Token breedToken = tokens.getNextToken();
                boolean bl4 = false;
                if (breedToken.getType() == 9) {
                    bl4 = true;
                }
                Compiler.cAssert(bl4, EXPECTED_BREED, breedToken);
                boolean bl5 = false;
                if (tokens.lookAhead().getType() == 7) {
                    bl5 = true;
                }
                Compiler.cAssert(bl5, EXPECTED_CLOSE_BRACE, tokens.lookAhead());
                String breedString = (String)breedToken.getValue();
                AgentSet breed = world.getBreed(breedString);
                boolean bl6 = false;
                if (breed != null) {
                    bl6 = true;
                }
                Compiler.cAssert(bl6, breedString + NOT_A_BREED, token);
                return breed;
            }
            if (agentsetTypeString.equalsIgnoreCase(SET_TYPE_ALLTURTLES) || agentsetTypeString.equalsIgnoreCase(SET_TYPE_ALLPATCHES)) {
                boolean bl7 = false;
                if (tokens.lookAhead().getType() == 7) {
                    bl7 = true;
                }
                Compiler.cAssert(bl7, EXPECTED_CLOSE_BRACE, tokens.lookAhead());
                if (agentsetTypeString.equalsIgnoreCase(SET_TYPE_ALLTURTLES)) {
                    return world.turtles();
                }
                return world.patches();
            }
            if (agentsetTypeString.equalsIgnoreCase(SET_TYPE_OBSERVER)) {
                boolean bl8 = false;
                if (tokens.lookAhead().getType() == 7) {
                    bl8 = true;
                }
                Compiler.cAssert(bl8, EXPECTED_CLOSE_BRACE, tokens.lookAhead());
                Class clazz = class$org$nlogo$agent$Observer;
                if (clazz == null) {
                    clazz = class$org$nlogo$agent$Observer = ConstantParser.class("[Lorg.nlogo.agent.Observer;", false);
                }
                AgentSet agentset = new AgentSet(clazz, 1, false, world);
                agentset.add(world.observer());
                return agentset;
            }
            throw new CompilerException(agentsetTypeString + NOT_AN_AGENTSET, token);
        }
        if (token.getValue() instanceof _turtles) {
            tokens.getNextToken();
            Class clazz = class$org$nlogo$agent$Turtle;
            if (clazz == null) {
                clazz = class$org$nlogo$agent$Turtle = ConstantParser.class("[Lorg.nlogo.agent.Turtle;", false);
            }
            AgentSet agentset = new AgentSet(clazz, 1, false, world);
            token = tokens.lookAhead();
            while (token.getType() != 7) {
                Object val = ConstantParser.readConstantPrefix(tokens, world);
                Compiler.cAssert(val instanceof Integer, BAD_TURTLE_SET_ARGS, token);
                agentset.add(world.getOrCreateTurtle((Integer)val));
                token = tokens.lookAhead();
            }
            return agentset;
        }
        if (token.getValue() instanceof _patches) {
            tokens.getNextToken();
            Class clazz = class$org$nlogo$agent$Patch;
            if (clazz == null) {
                clazz = class$org$nlogo$agent$Patch = ConstantParser.class("[Lorg.nlogo.agent.Patch;", false);
            }
            AgentSet agentset = new AgentSet(clazz, 1, false, world);
            token = tokens.lookAhead();
            while (token.getType() != 7) {
                boolean bl9 = false;
                if (token.getType() == 4) {
                    bl9 = true;
                }
                Compiler.cAssert(bl9, BAD_PATCH_SET_ARGS, token);
                LogoList listVal = (LogoList)ConstantParser.readConstantPrefix(tokens, world);
                boolean bl10 = false;
                if (listVal.size() == 2 && listVal.get(0) instanceof Integer && listVal.get(1) instanceof Integer) {
                    bl10 = true;
                }
                Compiler.cAssert(bl10, BAD_PATCH_SET_ARGS, token);
                agentset.add(world.getPatchAt(((Integer)listVal.get(0)).doubleValue(), ((Integer)listVal.get(1)).doubleValue()));
                token = tokens.lookAhead();
            }
            return agentset;
        }
        if (token.getValue() instanceof _turtle || token.getValue() instanceof _patch) {
            Object result = ConstantParser.parseConstantAgent(tokens, world);
            boolean bl11 = false;
            if (tokens.lookAhead().getType() == 7) {
                bl11 = true;
            }
            Compiler.cAssert(bl11, EXPECTED_CLOSE_BRACE, tokens.lookAhead());
            return result;
        }
        throw new CompilerException(token.getName() + NOT_AN_AGENTSET, token);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private ConstantParser() {
        throw new IllegalStateException();
    }
}

