/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import org.nlogo.compiler.AstNode;
import org.nlogo.compiler.AstVisitor;
import org.nlogo.compiler.CompilerException;
import org.nlogo.compiler.Expression;
import org.nlogo.compiler.Syntax;

strictfp class ReporterBlock
implements Expression,
AstNode {
    private Expression expr;
    private int startPos;
    private int endPos;
    private String fileName;

    public int getStartPosition() {
        return this.startPos;
    }

    public int getEndPosition() {
        return this.endPos;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setStartPosition(int startPos) {
        this.startPos = startPos;
    }

    public void setEndPosition(int endPos) {
        this.endPos = endPos;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getType() {
        int exprType = this.expr.getType();
        int blockType = exprType == 4 ? 4096 : (exprType == 3 || exprType == 1 || exprType == 2 ? 8192 : (Syntax.typesAreCompatible(exprType, 4) || Syntax.typesAreCompatible(exprType, 3) ? 28672 : 16384));
        return blockType;
    }

    Expression getExpression() {
        return this.expr;
    }

    public Object[] toObjectArray() {
        return new Object[]{this.expr.toObjectArray()};
    }

    public String toString() {
        return "[" + this.expr.toString() + ']';
    }

    public void accept(AstVisitor v) throws CompilerException {
        v.visitReporterBlock(this);
    }

    ReporterBlock(Expression expr, int startPos, int endPos, String fileName) {
        this.expr = expr;
        this.startPos = startPos;
        this.endPos = endPos;
        this.fileName = fileName;
    }
}

