/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.util.List;
import org.nlogo.command.Procedure;
import org.nlogo.compiler.ApplyTemplateVisitor;
import org.nlogo.compiler.AstNode;
import org.nlogo.compiler.CompilerException;
import org.nlogo.compiler.DefaultAstVisitor;
import org.nlogo.compiler.ReporterApp;
import org.nlogo.compiler.Statement;
import org.nlogo.prim._apply;
import org.nlogo.prim._filter;
import org.nlogo.prim._foreach;
import org.nlogo.prim._map;
import org.nlogo.prim._nvalues;
import org.nlogo.prim._reduce;
import org.nlogo.prim._sortby;
import org.nlogo.prim._templatevariable;
import org.nlogo.prim._valuesto;

strictfp class TemplateVisitor
extends DefaultAstVisitor {
    static final String OUT_OF_SCOPE = "this special variable is not defined here";
    private int currentIndex;
    private int numberBound;
    private Procedure procedure;

    public void visitReporterApp(ReporterApp expr) throws CompilerException {
        if (expr.getReporter() instanceof _apply) {
            this.visitApply((_apply)expr.getReporter(), expr.getArguments());
        } else if (expr.getReporter() instanceof _map) {
            this.visitMap((_map)expr.getReporter(), expr.getArguments());
        } else if (expr.getReporter() instanceof _filter) {
            this.visitFilter((_filter)expr.getReporter(), expr.getArguments());
        } else if (expr.getReporter() instanceof _nvalues) {
            this.visitNValues((_nvalues)expr.getReporter(), expr.getArguments());
        } else if (expr.getReporter() instanceof _sortby) {
            this.visitSortby((_sortby)expr.getReporter(), expr.getArguments());
        } else if (expr.getReporter() instanceof _reduce) {
            this.visitReduce((_reduce)expr.getReporter(), expr.getArguments());
        } else if (expr.getReporter() instanceof _templatevariable) {
            this.visitVariable((_templatevariable)expr.getReporter());
        } else {
            super.visitReporterApp(expr);
        }
    }

    public void visitStatement(Statement stmt) throws CompilerException {
        if (stmt.getCommand() instanceof _foreach) {
            this.visitForeach((_foreach)stmt.getCommand(), stmt.getArguments());
        } else if (stmt.getCommand() instanceof _valuesto) {
            this.visitValuesTo((_valuesto)stmt.getCommand(), stmt.getArguments());
        } else {
            super.visitStatement(stmt);
        }
    }

    private final void visitMap(_map ins, List args) throws CompilerException {
        int temp = this.numberBound;
        this.numberBound = args.size() - 1;
        this.currentIndex += this.numberBound;
        while (this.currentIndex > this.procedure.getNumSlots() - 1) {
            ++this.procedure.templateVars;
        }
        ins.setFirstVarIndex(this.currentIndex - this.numberBound + 1);
        ((AstNode)args.get(0)).accept(this);
        this.currentIndex -= this.numberBound;
        this.numberBound = temp;
        int i = 1;
        while (i < args.size()) {
            ((AstNode)args.get(i)).accept(this);
            ++i;
        }
    }

    private final void visitApply(_apply ins, List args) throws CompilerException {
        int temp = this.numberBound;
        ApplyTemplateVisitor atv = new ApplyTemplateVisitor();
        ((AstNode)args.get(0)).accept(atv);
        this.numberBound = atv.getHighestTemplateVariable();
        this.currentIndex += this.numberBound;
        while (this.currentIndex > this.procedure.getNumSlots() - 1) {
            ++this.procedure.templateVars;
        }
        ins.setFirstVarIndex(this.currentIndex - this.numberBound + 1);
        ins.setNumberSlots(this.numberBound);
        ((AstNode)args.get(0)).accept(this);
        this.currentIndex -= this.numberBound;
        this.numberBound = temp;
        ((AstNode)args.get(1)).accept(this);
    }

    private final void visitForeach(_foreach ins, List args) throws CompilerException {
        int i = 0;
        while (i < args.size() - 1) {
            ((AstNode)args.get(i)).accept(this);
            ++i;
        }
        int temp = this.numberBound;
        this.numberBound = args.size() - 1;
        this.currentIndex += this.numberBound;
        while (this.currentIndex > this.procedure.getNumSlots() - 1) {
            ++this.procedure.templateVars;
        }
        ins.setFirstVarIndex(this.currentIndex - this.numberBound + 1);
        ((AstNode)args.get(args.size() - 1)).accept(this);
        this.currentIndex -= this.numberBound;
        this.numberBound = temp;
    }

    private final void visitSortby(_sortby ins, List args) throws CompilerException {
        int temp = this.numberBound;
        this.numberBound = 2;
        this.currentIndex += 2;
        while (this.currentIndex > this.procedure.getNumSlots() - 1) {
            ++this.procedure.templateVars;
        }
        ins.setLeftVarIndex(this.currentIndex - 1);
        ins.setRightVarIndex(this.currentIndex);
        ((AstNode)args.get(0)).accept(this);
        this.currentIndex -= 2;
        this.numberBound = temp;
        ((AstNode)args.get(1)).accept(this);
    }

    private final void visitReduce(_reduce ins, List args) throws CompilerException {
        int temp = this.numberBound;
        this.numberBound = 2;
        this.currentIndex += 2;
        while (this.currentIndex > this.procedure.getNumSlots() - 1) {
            ++this.procedure.templateVars;
        }
        ins.setLeftVarIndex(this.currentIndex - 1);
        ins.setRightVarIndex(this.currentIndex);
        ((AstNode)args.get(0)).accept(this);
        this.currentIndex -= 2;
        this.numberBound = temp;
        ((AstNode)args.get(1)).accept(this);
    }

    private final void visitNValues(_nvalues ins, List args) throws CompilerException {
        ((AstNode)args.get(0)).accept(this);
        int temp = this.numberBound;
        this.numberBound = 1;
        ++this.currentIndex;
        if (this.currentIndex > this.procedure.getNumSlots() - 1) {
            ++this.procedure.templateVars;
        }
        ins.setVarIndex(this.currentIndex);
        ((AstNode)args.get(1)).accept(this);
        --this.currentIndex;
        this.numberBound = temp;
    }

    private final void visitValuesTo(_valuesto ins, List args) throws CompilerException {
        ((AstNode)args.get(0)).accept(this);
        ((AstNode)args.get(1)).accept(this);
        int temp = this.numberBound;
        this.numberBound = 1;
        ++this.currentIndex;
        if (this.currentIndex > this.procedure.getNumSlots() - 1) {
            ++this.procedure.templateVars;
        }
        ins.setVarIndex(this.currentIndex);
        ((AstNode)args.get(2)).accept(this);
        --this.currentIndex;
        this.numberBound = temp;
    }

    private final void visitFilter(_filter ins, List args) throws CompilerException {
        int temp = this.numberBound;
        this.numberBound = 1;
        ++this.currentIndex;
        if (this.currentIndex > this.procedure.getNumSlots() - 1) {
            ++this.procedure.templateVars;
        }
        ins.setVarIndex(this.currentIndex);
        ((AstNode)args.get(0)).accept(this);
        --this.currentIndex;
        this.numberBound = temp;
        ((AstNode)args.get(1)).accept(this);
    }

    private final void visitVariable(_templatevariable ins) throws CompilerException {
        if (ins.getVarNumber() > this.numberBound) {
            throw new CompilerException(OUT_OF_SCOPE, ins.token());
        }
        ins.setSlotNumber(this.currentIndex - this.numberBound + ins.getVarNumber());
    }

    TemplateVisitor(Procedure procedure) {
        this.procedure = procedure;
        this.currentIndex = procedure.getNumSlots() - 1;
        this.numberBound = 0;
    }
}

