/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.nlogo.agent.Color;
import org.nlogo.agent.Nobody;
import org.nlogo.command.Instruction;
import org.nlogo.compiler.Keyword;
import org.nlogo.util.Exceptions;
import org.nlogo.util.Utils;
import org.nlogo.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class TokenMapper {
    private static final String TOKENS_PATH = "/system/tokens.txt";
    private static final String[] KEYWORDS = new String[]{"TO", "TO-REPORT", "LOCALS", "END", "BREEDS", "GLOBALS", "TURTLES-OWN", "PATCHES-OWN", "__EXTENSIONS", "__INCLUDE"};
    private static final Object[] CONSTANTS = new Object[]{"FALSE", Boolean.FALSE, "TRUE", Boolean.TRUE, "NOBODY", Nobody.NOBODY, "E", new Double(Math.E), "PI", new Double(Math.PI), "BLACK", Color.BOXED_BLACK, "GRAY", new Double(5), "GREY", new Double(5), "WHITE", Color.BOXED_WHITE, "RED", new Double(15.0), "ORANGE", new Double(25.0), "BROWN", new Double(35.0), "YELLOW", new Double(45.0), "GREEN", new Double(55.0), "LIME", new Double(65.0), "TURQUOISE", new Double(75.0), "CYAN", new Double(85.0), "SKY", new Double(95.0), "BLUE", new Double(105.0), "VIOLET", new Double(115.0), "MAGENTA", new Double(125.0), "PINK", new Double(135.0)};
    public static final TokenMapper TOKEN_MAPPER = new TokenMapper();
    private final Map commandMap;
    private final Map reporterMap;
    private final Map constantMap;
    private final Map keywordMap;

    public boolean isCommand(String command) {
        return this.commandMap.containsKey(command.toUpperCase());
    }

    Instruction getCommand(String command) {
        try {
            String name = (String)this.commandMap.get(command.toUpperCase());
            if (name == null) {
                return null;
            }
            Class<?> thing = Class.forName(name);
            return (Instruction)thing.newInstance();
        }
        catch (ClassNotFoundException ex) {
            Exceptions.handle(ex);
        }
        catch (InstantiationException ex) {
            Exceptions.handle(ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.handle(ex);
        }
        return null;
    }

    public boolean isReporter(String command) {
        return this.reporterMap.containsKey(command.toUpperCase());
    }

    Instruction getReporter(String command) {
        try {
            String name = (String)this.reporterMap.get(command.toUpperCase());
            if (name == null) {
                return null;
            }
            Class<?> thing = Class.forName(name);
            return (Instruction)thing.newInstance();
        }
        catch (ClassNotFoundException ex) {
            Exceptions.handle(ex);
        }
        catch (InstantiationException ex) {
            Exceptions.handle(ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.handle(ex);
        }
        return null;
    }

    public boolean isKeyword(String command) {
        boolean bl = false;
        if (this.keywordMap.containsKey(command.toUpperCase()) || command.toUpperCase().endsWith("-OWN")) {
            bl = true;
        }
        return bl;
    }

    Keyword getKeyword(String command) {
        Keyword result = (Keyword)this.keywordMap.get(command.toUpperCase());
        if (result == null) {
            result = new Keyword(command.toUpperCase());
        }
        return result;
    }

    public boolean isConstant(String command) {
        return this.constantMap.containsKey(command.toUpperCase());
    }

    Object getConstant(String command) {
        return this.constantMap.get(command.toUpperCase());
    }

    private final void buildMaps() {
        this.buildKeywordMap();
        this.buildConstantMap();
        try {
            this.buildInstructionMaps();
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
    }

    private final void buildKeywordMap() {
        int i = 0;
        while (i < KEYWORDS.length) {
            this.keywordMap.put(KEYWORDS[i], new Keyword(KEYWORDS[i]));
            ++i;
        }
    }

    private final void buildConstantMap() {
        int i = 0;
        while (i < CONSTANTS.length) {
            this.constantMap.put(CONSTANTS[i++], CONSTANTS[i++]);
        }
    }

    private final void buildInstructionMaps() throws IOException {
        String[] lines = Utils.getResourceAsStringArray(TOKENS_PATH);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            String type = tokenizer.nextToken();
            String key = tokenizer.nextToken().toUpperCase();
            String value = "org.nlogo.prim." + tokenizer.nextToken();
            if (!value.startsWith("org.nlogo.prim.cities.") || Version.isCities()) {
                if (type.equals("C")) {
                    this.commandMap.put(key, value);
                } else if (type.equals("R")) {
                    this.reporterMap.put(key, value);
                } else {
                    throw new RuntimeException("bad line in tokens.txt: " + line);
                }
            }
            ++i;
        }
    }

    void checkInstructionMaps() {
        Iterator it = this.commandMap.keySet().iterator();
        while (it.hasNext()) {
            this.getCommand((String)it.next());
        }
        it = this.reporterMap.keySet().iterator();
        while (it.hasNext()) {
            this.getReporter((String)it.next());
        }
    }

    private final /* synthetic */ void this() {
        this.commandMap = new HashMap();
        this.reporterMap = new HashMap();
        this.constantMap = new HashMap();
        this.keywordMap = new HashMap();
    }

    private TokenMapper() {
        this.this();
        this.buildMaps();
    }
}

