/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.nlogo.editor.EditorArea;

public strictfp class Actions {
    public static Action commentAction = new CommentAction();
    public static Action uncommentAction = new UncommentAction();
    public static Action shiftLeftAction = new ShiftLeftAction();
    public static Action shiftRightAction = new ShiftRightAction();
    static Action insertTabAction = new InsertTabAction();

    static void setEnabled(boolean enabled) {
        commentAction.setEnabled(enabled);
        uncommentAction.setEnabled(enabled);
        shiftLeftAction.setEnabled(enabled);
        shiftRightAction.setEnabled(enabled);
    }

    private Actions() {
        throw new IllegalStateException();
    }

    strictfp static class CommentAction
    extends TextAction {
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component instanceof EditorArea) {
                ((EditorArea)component).insertBeforeEachSelectedLine(";");
            }
        }

        CommentAction() {
            super("comment-line");
        }
    }

    strictfp static class UncommentAction
    extends TextAction {
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component instanceof EditorArea) {
                ((EditorArea)component).uncomment();
            }
        }

        UncommentAction() {
            super("uncomment-line");
        }
    }

    strictfp static class ShiftLeftAction
    extends TextAction {
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component instanceof EditorArea) {
                ((EditorArea)component).shiftLeft();
            }
        }

        ShiftLeftAction() {
            super("shift-line-left");
        }
    }

    strictfp static class ShiftRightAction
    extends TextAction {
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component instanceof EditorArea) {
                ((EditorArea)component).insertBeforeEachSelectedLine(" ");
            }
        }

        ShiftRightAction() {
            super("shift-line-right");
        }
    }

    strictfp static class InsertTabAction
    extends TextAction {
        public void actionPerformed(ActionEvent e) {
            this.getTextComponent(e).replaceSelection("  ");
        }

        InsertTabAction() {
            super("insert-tab");
        }
    }
}

