/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.EditorArea;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class BracketMatcher
implements CaretListener {
    private static final Color GOOD_COLOR = Color.GRAY;
    private static final Color BAD_COLOR = Color.RED;
    private final Colorizer colorizer;
    private String oldText;
    private int[] tokenTypes;
    private String oldLineText;
    private int[] lineTokenTypes;
    private final BracketHighlightPainter goodPainter;
    private final BracketHighlightPainter badPainter;

    public void caretUpdate(CaretEvent e) {
        EditorArea source = (EditorArea)e.getSource();
        Highlighter highlighter = source.getHighlighter();
        this.removeOldHighlights(highlighter);
        int dot = e.getDot();
        if (dot != e.getMark() || dot == 0) {
            return;
        }
        try {
            int lineNumber;
            PlainDocument doc;
            int lineDot;
            String lineText = source.getLineText(dot);
            if (!lineText.equals(this.oldLineText)) {
                this.lineTokenTypes = this.colorizer.getCharacterTokenTypes(lineText);
                this.oldLineText = lineText;
            }
            if ((lineDot = dot - source.lineToStartOffset(doc = (PlainDocument)source.getDocument(), lineNumber = source.offsetToLine(doc, dot))) == 0 || !this.colorizer.isOpener(this.lineTokenTypes[lineDot - 1]) && !this.colorizer.isCloser(this.lineTokenTypes[lineDot - 1])) {
                return;
            }
            String text = source.getText();
            if (!text.equals(this.oldText)) {
                this.tokenTypes = this.colorizer.getCharacterTokenTypes(text);
                this.oldText = text;
            }
            this.doHighlighting(highlighter, this.colorizer.isOpener(this.lineTokenTypes[lineDot - 1]), this.tokenTypes, dot);
        }
        catch (BadLocationException ex) {
            Exceptions.handle(ex);
        }
    }

    void focusLost(EditorArea source) {
        this.removeOldHighlights(source.getHighlighter());
        this.oldText = "";
        this.tokenTypes = new int[0];
        this.oldLineText = "";
        this.lineTokenTypes = new int[0];
    }

    private final void doHighlighting(Highlighter highlighter, boolean isOpener, int[] tokens, int dot) throws BadLocationException {
        if (isOpener) {
            int closer = BracketMatcher.findCloser(this.colorizer, tokens, dot - 1);
            if (closer != -1 && this.colorizer.isMatch(tokens[dot - 1], tokens[closer])) {
                this.highlightGood(highlighter, closer);
            }
        } else {
            int opener = BracketMatcher.findOpener(this.colorizer, tokens, dot - 1);
            if (opener != -1) {
                if (this.colorizer.isMatch(tokens[opener], tokens[dot - 1])) {
                    this.highlightGood(highlighter, opener);
                } else {
                    this.highlightBad(highlighter, opener);
                }
            } else {
                this.highlightBad(highlighter, dot - 1);
            }
        }
    }

    static int findCloser(Colorizer colorizer, int[] tokens, int opener) throws BadLocationException {
        int parenCount = 1;
        int i = opener + 1;
        while (i < tokens.length) {
            if (colorizer.isOpener(tokens[i])) {
                ++parenCount;
            } else if (colorizer.isCloser(tokens[i])) {
                --parenCount;
            }
            if (parenCount == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int findOpener(Colorizer colorizer, int[] tokens, int closer) throws BadLocationException {
        int parenCount = 1;
        int i = closer - 1;
        while (i >= 0) {
            if (colorizer.isCloser(tokens[i])) {
                ++parenCount;
            } else if (colorizer.isOpener(tokens[i])) {
                --parenCount;
            }
            if (parenCount == 0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private final void removeOldHighlights(Highlighter highlighter) {
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        int i = 0;
        while (i < highlights.length) {
            if (highlights[i].getPainter() == this.goodPainter || highlights[i].getPainter() == this.badPainter) {
                highlighter.removeHighlight(highlights[i]);
            }
            ++i;
        }
    }

    private final void highlightGood(Highlighter highlighter, int pos) throws BadLocationException {
        highlighter.addHighlight(pos, pos + 1, this.goodPainter);
    }

    private final void highlightBad(Highlighter highlighter, int pos) throws BadLocationException {
        highlighter.addHighlight(pos, pos + 1, this.badPainter);
    }

    private final /* synthetic */ void this() {
        this.oldText = "";
        this.tokenTypes = new int[0];
        this.oldLineText = "";
        this.lineTokenTypes = new int[0];
    }

    BracketMatcher(Colorizer colorizer) {
        this.this();
        this.colorizer = colorizer;
        this.goodPainter = new BracketHighlightPainter(GOOD_COLOR);
        this.badPainter = new BracketHighlightPainter(BAD_COLOR);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BracketHighlightPainter
    implements Highlighter.HighlightPainter {
        private final Color color;

        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
            try {
                g.setColor(this.color);
                Rectangle rect = c.getUI().modelToView(c, p0).union(c.getUI().modelToView(c, p1));
                g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            }
            catch (BadLocationException ex) {
                Exceptions.handle(ex);
            }
        }

        BracketHighlightPainter(Color color) {
            this.color = color;
        }
    }
}

