/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.nlogo.editor.BracketMatcher;
import org.nlogo.editor.Colorizer;
import org.nlogo.util.Exceptions;

strictfp class DoubleClickCaret
extends DefaultCaret {
    private final Colorizer colorizer;

    public void mouseClicked(MouseEvent e) {
        if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
            JTextComponent source = (JTextComponent)e.getSource();
            try {
                if (!this.handleDoubleClick(source, this.colorizer.getCharacterTokenTypes(source.getText()), source.getCaretPosition())) {
                    super.mouseClicked(e);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.handle(ex);
            }
        } else {
            super.mouseClicked(e);
        }
    }

    private final boolean handleDoubleClick(JTextComponent textComponent, int[] tokens, int dot) throws BadLocationException {
        int opener;
        if (dot < tokens.length && this.colorizer.isOpener(tokens[dot])) {
            int closer = BracketMatcher.findCloser(this.colorizer, tokens, dot);
            if (closer != -1 && this.colorizer.isMatch(tokens[dot], tokens[closer])) {
                textComponent.select(dot, closer + 1);
                return true;
            }
        } else if (dot > 0 && this.colorizer.isCloser(tokens[dot - 1]) && (opener = BracketMatcher.findOpener(this.colorizer, tokens, dot - 1)) != -1 && this.colorizer.isMatch(tokens[opener], tokens[dot - 1])) {
            textComponent.select(opener, dot);
            return true;
        }
        return false;
    }

    DoubleClickCaret(Colorizer colorizer) {
        this.colorizer = colorizer;
    }
}

