/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;
import org.nlogo.awt.Utils;
import org.nlogo.editor.Actions;
import org.nlogo.editor.BracketMatcher;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.DoubleClickCaret;
import org.nlogo.editor.HighlightEditorKit;
import org.nlogo.swing.FindDialog;
import org.nlogo.swing.UndoManager;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class EditorArea
extends JEditorPane
implements FocusListener {
    private final int rows;
    private final int columns;
    protected final boolean disableFocusTraversalKeys;
    private final BracketMatcher bracketMatcher;
    private final UndoManager undoManager;
    private final Colorizer colorizer;
    private boolean mouseEvent;

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), new Action[]{Actions.commentAction, Actions.uncommentAction, Actions.shiftLeftAction, Actions.shiftRightAction});
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        dimension = dimension != null ? dimension : new Dimension(400, 400);
        dimension.width = this.columns != 0 ? this.columns * this.getColumnWidth() : dimension.width;
        dimension.height = this.rows != 0 ? this.rows * this.getRowHeight() : dimension.height;
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = dimension = dimension == null ? new Dimension(400, 400) : dimension;
        if (this.columns != 0) {
            dimension.width = StrictMath.max(dimension.width, this.columns * this.getColumnWidth());
        }
        if (this.rows != 0) {
            dimension.height = StrictMath.max(dimension.height, this.rows * this.getRowHeight());
        }
        return dimension;
    }

    private final int getColumnWidth() {
        return this.getFontMetrics(this.getFont()).charWidth('m');
    }

    private final int getRowHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    public void setText(String text) {
        if (!text.equals(this.getText())) {
            super.setText(text);
            this.undoManager.discardAllEdits();
        }
    }

    String getLineText(int offset) throws BadLocationException {
        PlainDocument doc = (PlainDocument)this.getDocument();
        int currentLine = this.offsetToLine(doc, offset);
        int lineStart = this.lineToStartOffset(doc, currentLine);
        int lineEnd = this.lineToEndOffset(doc, currentLine);
        return doc.getText(lineStart, lineEnd - lineStart);
    }

    int lineToStartOffset(PlainDocument doc, int line) {
        return doc.getDefaultRootElement().getElement(line).getStartOffset();
    }

    int lineToEndOffset(PlainDocument doc, int line) {
        return doc.getDefaultRootElement().getElement(line).getEndOffset();
    }

    int offsetToLine(PlainDocument doc, int offset) {
        return doc.getDefaultRootElement().getElementIndex(offset);
    }

    void insertBeforeEachSelectedLine(String insertion) {
        PlainDocument doc = (PlainDocument)this.getDocument();
        try {
            int currentLine = this.offsetToLine(doc, this.getSelectionStart());
            int endLine = this.offsetToLine(doc, this.getSelectionEnd());
            if (endLine > currentLine && this.getSelectionEnd() == this.lineToStartOffset(doc, endLine)) {
                --endLine;
            }
            while (currentLine <= endLine) {
                doc.insertString(this.lineToStartOffset(doc, currentLine), insertion, null);
                ++currentLine;
            }
        }
        catch (BadLocationException ex) {
            Exceptions.handle(ex);
        }
    }

    void uncomment() {
        PlainDocument doc = (PlainDocument)this.getDocument();
        try {
            int currentLine = this.offsetToLine(doc, this.getSelectionStart());
            int endLine = this.offsetToLine(doc, this.getSelectionEnd());
            if (endLine > currentLine && this.getSelectionEnd() == this.lineToStartOffset(doc, endLine)) {
                --endLine;
            }
            while (currentLine <= endLine) {
                int lineEnd;
                int lineStart = this.lineToStartOffset(doc, currentLine);
                String text = doc.getText(lineStart, (lineEnd = this.lineToEndOffset(doc, currentLine)) - lineStart);
                int semicolonPos = text.indexOf(59);
                if (semicolonPos != -1) {
                    boolean allSpaces = true;
                    int i = 0;
                    while (i < semicolonPos) {
                        if (!Character.isWhitespace(text.charAt(i))) {
                            allSpaces = false;
                            break;
                        }
                        ++i;
                    }
                    if (allSpaces) {
                        doc.remove(lineStart + semicolonPos, 1);
                    }
                }
                ++currentLine;
            }
        }
        catch (BadLocationException ex) {
            Exceptions.handle(ex);
        }
    }

    void shiftLeft() {
        PlainDocument doc = (PlainDocument)this.getDocument();
        try {
            int currentLine = this.offsetToLine(doc, this.getSelectionStart());
            int endLine = this.offsetToLine(doc, this.getSelectionEnd());
            if (endLine > currentLine && this.getSelectionEnd() == this.lineToStartOffset(doc, endLine)) {
                --endLine;
            }
            while (currentLine <= endLine) {
                int lineEnd;
                int lineStart = this.lineToStartOffset(doc, currentLine);
                String text = doc.getText(lineStart, (lineEnd = this.lineToEndOffset(doc, currentLine)) - lineStart);
                if (text.length() > 0 && text.charAt(0) == ' ') {
                    doc.remove(lineStart, 1);
                }
                ++currentLine;
            }
        }
        catch (BadLocationException ex) {
            Exceptions.handle(ex);
        }
    }

    public void focusGained(FocusEvent fe) {
        if (!this.mouseEvent && !this.disableFocusTraversalKeys) {
            this.selectAll();
        }
        Actions.setEnabled(true);
        if (this.shouldEnableFindActions()) {
            FindDialog.setActionsEnabled(true);
        }
        UndoManager.setCurrentManager(this.undoManager);
    }

    boolean shouldEnableFindActions() {
        return true;
    }

    public void focusLost(FocusEvent fe) {
        if (!this.disableFocusTraversalKeys) {
            this.select(0, 0);
        }
        this.mouseEvent = fe.isTemporary();
        this.bracketMatcher.focusLost(this);
        FindDialog.setActionsEnabled(false);
        this.colorizer.reset();
        if (!fe.isTemporary()) {
            Actions.setEnabled(false);
            UndoManager.setCurrentManager(null);
        }
    }

    public void processMouseEvent(MouseEvent me) {
        if (me.getID() == 501) {
            this.mouseEvent = true;
        }
        super.processMouseEvent(me);
    }

    private final /* synthetic */ void this() {
        this.undoManager = new UndoManager();
        this.mouseEvent = false;
    }

    public EditorArea(int rows, int columns, boolean disableFocusTraversalKeys, TextListener listener, Colorizer colorizer) {
        this.this();
        this.rows = rows;
        this.columns = columns;
        this.disableFocusTraversalKeys = disableFocusTraversalKeys;
        this.colorizer = colorizer;
        this.enableEvents(16L);
        this.addFocusListener(this);
        this.bracketMatcher = new BracketMatcher(colorizer);
        this.addCaretListener(this.bracketMatcher);
        int blinkRate = this.getCaret().getBlinkRate();
        DoubleClickCaret caret = new DoubleClickCaret(colorizer);
        caret.setBlinkRate(blinkRate);
        this.setCaret(caret);
        this.setDragEnabled(false);
        this.setFocusTraversalKeysEnabled(disableFocusTraversalKeys ^ true);
        if (!disableFocusTraversalKeys) {
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), new TransferFocusAction());
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), new TransferFocusBackwardAction());
        } else {
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), Actions.insertTabAction);
        }
        this.setFont(new Font(Utils.platformMonospacedFont(), 0, 12));
        this.setEditorKit(new HighlightEditorKit(listener, colorizer));
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), new EnterAction());
        this.getDocument().putProperty("tabSize", new Integer(2));
        this.getDocument().putProperty("__EndOfLine__", "\n");
        this.getDocument().addUndoableEditListener(this.undoManager);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TransferFocusAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            EditorArea.this.transferFocus();
        }

        private TransferFocusAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TransferFocusBackwardAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            EditorArea.this.transferFocusBackward();
        }

        private TransferFocusBackwardAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class EnterAction
    extends TextAction {
        public void actionPerformed(ActionEvent e) {
            PlainDocument doc = (PlainDocument)EditorArea.this.getDocument();
            try {
                int currentLine = EditorArea.this.offsetToLine(doc, EditorArea.this.getSelectionStart());
                int lineStart = EditorArea.this.lineToStartOffset(doc, currentLine);
                int lineEnd = EditorArea.this.lineToEndOffset(doc, currentLine);
                String text = doc.getText(lineStart, lineEnd - lineStart);
                StringBuffer spaces = new StringBuffer("\n");
                int i = 0;
                while (i < text.length() && lineStart + i < EditorArea.this.getSelectionStart()) {
                    char c = text.charAt(i);
                    if (!Character.isWhitespace(c)) break;
                    spaces.append(c);
                    ++i;
                }
                EditorArea.this.replaceSelection(spaces.toString());
            }
            catch (BadLocationException ex) {
                Exceptions.handle(ex);
            }
        }

        EnterAction() {
            super("enter");
        }
    }
}

