/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.nlogo.editor.Colorizer;
import org.nlogo.util.Exceptions;

strictfp class HighlightView
extends PlainView {
    private static final boolean LEAVE_COLORS_ALONE = System.getProperty("os.name").startsWith("Mac");
    private static final Color SELECTED_BACKGROUND_COLOR = UIManager.getDefaults().getColor("textHighlight");
    private static final Color UNSELECTED_TEXT_COLOR = UIManager.getDefaults().getColor("textText");
    private static final Color SELECTED_TEXT_COLOR = UIManager.getDefaults().getColor("textHighlightText");
    private final JEditorPane pane;
    private final Colorizer colorizer;
    private int lineStart;
    private int lineEnd;
    private Color[] charColors;

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        try {
            this.studyLine(lineIndex);
            super.drawLine(lineIndex, g, x, y);
        }
        catch (BadLocationException ex) {
            Exceptions.handle(ex);
        }
    }

    private final void studyLine(int lineIndex) throws BadLocationException {
        Element element = this.getElement().getElement(lineIndex);
        PlainDocument doc = (PlainDocument)this.getDocument();
        Segment text = this.getLineBuffer();
        this.lineStart = element.getStartOffset();
        this.lineEnd = element.getEndOffset();
        doc.getText(this.lineStart, this.lineEnd - this.lineStart, text);
        this.charColors = this.colorizer.getCharacterColors(text.toString());
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        return this.drawText(g, x, y, p0, p1, false);
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        return this.drawText(g, x, y, p0, p1, true);
    }

    private final int drawText(Graphics g, int x, int y, int p0, int p1, boolean isSelected) throws BadLocationException {
        PlainDocument doc = (PlainDocument)this.getDocument();
        Segment text = this.getLineBuffer();
        while (p0 < p1) {
            doc.getText(p0, 1, text);
            Color color = this.charColors[p0 - this.lineStart];
            if (!this.pane.isEnabled()) {
                color = this.lightenColor(color, 0.5f);
            }
            g.setColor(isSelected && !LEAVE_COLORS_ALONE ? this.selectedColor(color) : color);
            x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, p0);
            ++p0;
        }
        return x;
    }

    private final Color selectedColor(Color color) {
        if (color.getRGB() == UNSELECTED_TEXT_COLOR.getRGB()) {
            return SELECTED_TEXT_COLOR;
        }
        if (this.isDarkSelectionColor()) {
            return this.lightenColor(color, 0.75f);
        }
        return this.darkenColor(color, 0.75f);
    }

    private final boolean isDarkSelectionColor() {
        int red = SELECTED_BACKGROUND_COLOR.getRed();
        int green = SELECTED_BACKGROUND_COLOR.getGreen();
        int blue = SELECTED_BACKGROUND_COLOR.getBlue();
        boolean bl = false;
        if (red + green + blue < 375) {
            bl = true;
        }
        return bl;
    }

    private final Color lightenColor(Color color, float amount) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return new Color((int)((float)red + (float)(255 - red) * amount), (int)((float)green + (float)(255 - green) * amount), (int)((float)blue + (float)(255 - blue) * amount));
    }

    private final Color darkenColor(Color color, float amount) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return new Color((int)((float)red * amount), (int)((float)green * amount), (int)((float)blue * amount));
    }

    HighlightView(JEditorPane pane, Element element, Colorizer colorizer) {
        super(element);
        this.pane = pane;
        this.colorizer = colorizer;
    }
}

