/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nlogo.agent.LogoList;
import org.nlogo.agent.Shape;
import org.nlogo.hubnet.ExitMessageBox;
import org.nlogo.hubnet.HubNetException;
import org.nlogo.hubnet.MessageBox;
import org.nlogo.hubnet.NodeConnection;
import org.nlogo.hubnet.NodeConnectionFactory;
import org.nlogo.hubnet.ServerGraphManager;
import org.nlogo.hubnet.calculator.CalcConnection;
import org.nlogo.hubnet.computer.client.ClientApplet;
import org.nlogo.hubnet.computer.server.CompConnection;
import org.nlogo.util.Utils;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.workspace.HubNetInterface;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class HubNetManager
implements HubNetInterface {
    private static final String NO_DATA_WAITING = "There is no data waiting.  Always check for data using HUBNET-MESSAGE-WAITING? before fetching data with HUBNET-FETCH-MESSAGE.";
    private static final String NO_DATA_FETCHED = "The data has not been fetched.  Always fetch the data with HUBNET-FETCH-MESSAGE before you try to access the data with HUBNET-MESSAGE or HUBNET-MESSAGE-SOURCE or HUBNET-MESSAGE-TAG";
    private static final String CALC_HUBNET_DISABLED_MSG = "Calculator HubNet has been disabled for this release.";
    private static final boolean CALC_HUBNET_DISABLED = false;
    public static boolean debug = false;
    public static final boolean INTERNAL_DEBUG = false;
    private final Workspace workspace;
    private final GUIWorkspace guiWorkspace;
    private final ServerGraphManager hnGraphManager;
    final Map connections;
    private final Map ncFactories;
    private final List messagesList;
    private MessageBox messageBox;
    private final Map shapesHash;
    private String uniqueId;

    public void registerNodeConnectionFactory(String nodeType, NodeConnectionFactory factory) {
        this.ncFactories.put(nodeType, factory);
    }

    protected Workspace workspace() {
        return this.workspace;
    }

    public GUIWorkspace guiWorkspace() {
        return this.guiWorkspace;
    }

    public boolean addNarrowCastPlot(String plotName) {
        return this.hnGraphManager.addNarrowCastPlot(plotName);
    }

    public void hubNetPlot(String clientId, double y) {
        this.hnGraphManager.narrowCastPlot(clientId, y);
    }

    public void hubNetPlot(String clientId, double x, double y) {
        this.hnGraphManager.narrowCastPlot(clientId, x, y);
    }

    public void hubNetClearPlot(String clientId) {
        this.hnGraphManager.narrowCastClear(clientId);
    }

    public void hubNetPenDown(String clientId, boolean penDown) {
        this.hnGraphManager.narrowCastPenDown(clientId, penDown);
    }

    public void hubNetPenMode(String clientId, int plotPenMode) {
        this.hnGraphManager.narrowCastPlotPenMode(clientId, plotPenMode);
    }

    public void hubNetSetHistogramNumBars(String clientId, int num) {
        this.hnGraphManager.narrowCastSetHistogramNumBars(clientId, num);
    }

    public void hubNetSetInterval(String clientId, double interval) {
        this.hnGraphManager.narrowCastSetInterval(clientId, interval);
    }

    void enqueueMessage(MessageBox message) {
        this.messagesList.add(message);
    }

    public boolean messageWaiting() throws HubNetException {
        return this.messagesList.isEmpty() ^ true;
    }

    public boolean enterMessage() throws HubNetException {
        this.checkRunningStatus();
        return this.messageBox.isEnterMessage();
    }

    public boolean exitMessage() throws HubNetException {
        this.checkRunningStatus();
        return this.messageBox.isExitMessage();
    }

    public void fetchMessage() throws HubNetException {
        this.checkRunningStatus();
        this.messageBox = null;
        if (!this.messagesList.isEmpty()) {
            this.messageBox = (MessageBox)this.messagesList.get(0);
            this.messagesList.remove(0);
            if (this.messageBox.isErrorMessage()) {
                HubNetException e = new HubNetException((String)this.messageBox.getMessage());
                this.messageBox = null;
                throw e;
            }
        } else {
            throw new HubNetException(NO_DATA_WAITING);
        }
    }

    private final MessageBox getMessageBox() throws HubNetException {
        this.checkRunningStatus();
        if (this.messageBox == null) {
            throw new HubNetException(NO_DATA_FETCHED);
        }
        return this.messageBox;
    }

    public Object getMessage() throws HubNetException {
        return this.getMessageBox().getMessage();
    }

    public String getMessageSource() throws HubNetException {
        return this.getMessageBox().getSource();
    }

    public String getMessageTag() throws HubNetException {
        return this.getMessageBox().getTag();
    }

    public void send(List nodes, String tag, Object message) throws HubNetException {
        this.checkRunningStatus();
        this.sendNormal(nodes, tag, message);
    }

    public boolean send(String node, String tag, Object message) throws HubNetException {
        boolean validNode = false;
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            NodeConnection nodeConnection = (NodeConnection)it.next();
            if (nodeConnection.canNarrowCast() && (validNode = nodeConnection.send(node, tag, message))) break;
        }
        return validNode;
    }

    public void broadcast(String tag, Object message) throws HubNetException {
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            NodeConnection connection = (NodeConnection)it.next();
            if (!connection.getRunning()) continue;
            connection.broadcast(tag, message);
        }
    }

    public boolean validTag(String tag) {
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            if (!((NodeConnection)it.next()).validTag(tag)) continue;
            return true;
        }
        return false;
    }

    public void disconnect() {
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            ((NodeConnection)it.next()).shutdown();
        }
        this.connections.clear();
        this.messagesList.removeAll(this.messagesList);
    }

    public boolean connectionsExist() {
        return this.connections.isEmpty() ^ true;
    }

    private final void checkRunningStatus() throws HubNetException {
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            if (!((NodeConnection)it.next()).getRunning()) continue;
            return;
        }
        throw new HubNetException("Not logged in.  Please use the hubnet-reset command.");
    }

    public void reset() throws HubNetException {
        if (this.connections.size() < 1) {
            throw new HubNetException("You have not specified what type of HubNet you wish to use.  Please use the hubnet-set-client-interface primitive.");
        }
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            NodeConnection c = (NodeConnection)it.next();
            if (c.getRunning()) {
                c.shutdown();
            }
            c.startup();
        }
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId == null ? "" : uniqueId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getModelName() {
        return this.workspace().modelNameForDisplay();
    }

    public void setClientInterface(String interfaceType, LogoList interfaceInfo) throws HubNetException {
        NodeConnection connection = (NodeConnection)this.connections.get(interfaceType);
        if (connection == null) {
            NodeConnectionFactory factory = (NodeConnectionFactory)this.ncFactories.get(interfaceType);
            if (factory == null) {
                throw new HubNetException(interfaceType + " is not a valid node type.");
            }
            if (this.connections.size() > 0) {
                throw new HubNetException("At this time only 1 type of HubNet (Calculator or Computer) can be used at a time.  Make sure you use hubnet-set-client-interface with only 1 HubNet type for a model.");
            }
            connection = factory.createConnection(this);
            this.connections.put(interfaceType, connection);
        }
        connection.setClientInterface(interfaceInfo);
    }

    public void newClient() {
        String host;
        ClientApplet clientApplet = new ClientApplet();
        try {
            host = InetAddress.getLocalHost().getHostAddress().toString();
        }
        catch (UnknownHostException ex) {
            host = null;
        }
        CompConnection con = this.getCompConnection();
        if (host != null && con != null) {
            clientApplet.startup(host, "" + this.getCompConnection().getPortNumber());
        } else {
            clientApplet.startup(true);
        }
    }

    public void newClient(int waitTime) {
        new ClientApplet().startup(true, waitTime);
    }

    private final boolean someNodesHaveGraphics() {
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            if (!((NodeConnection)it.next()).nodesHaveGraphics()) continue;
            return true;
        }
        return false;
    }

    void fullUpdateDisplay() {
        if (this.someNodesHaveGraphics()) {
            Iterator it = this.connections.values().iterator();
            while (it.hasNext()) {
                ((NodeConnection)it.next()).fullUpdateDisplay();
            }
        }
    }

    void fullUpdateDisplay(List nodes) throws HubNetException {
        if (this.someNodesHaveGraphics()) {
            int i = 0;
            while (i < nodes.size()) {
                this.fullUpdateDisplay((String)nodes.get(i));
                ++i;
            }
        }
    }

    public void updateDisplay() {
        if (this.someNodesHaveGraphics()) {
            Iterator it = this.connections.values().iterator();
            while (it.hasNext()) {
                ((NodeConnection)it.next()).updateDisplay();
            }
        }
    }

    private final void fullUpdateDisplay(String node) throws HubNetException {
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            if (!((NodeConnection)it.next()).fullUpdateDisplay(node)) continue;
            return;
        }
        this.simulateFailedExitMessage(node);
        if (debug) {
            System.out.println(node + " is not a logged in user or has no graphics window.");
        }
    }

    public void sendGW(List nodes) throws HubNetException {
        this.checkRunningStatus();
        this.fullUpdateDisplay(nodes);
    }

    public void broadcastGW() throws HubNetException {
        this.checkRunningStatus();
        this.fullUpdateDisplay();
    }

    public void showControlCenter() {
        if (this.guiWorkspace == null) {
            return;
        }
        this.getCompConnection().showControlCenter();
    }

    public CompConnection getCompConnection() {
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            NodeConnection connection = (NodeConnection)it.next();
            if (!(connection instanceof CompConnection)) continue;
            return (CompConnection)connection;
        }
        return null;
    }

    public double getOutQueueSize() throws HubNetException {
        this.checkRunningStatus();
        int totalQueueSize = 0;
        int totalClients = 0;
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            NodeConnection node = (NodeConnection)it.next();
            List queueSizes = node.clientSendQueueSizes();
            totalClients += queueSizes.size();
            int j = 0;
            while (j < queueSizes.size()) {
                totalQueueSize += ((Integer)queueSizes.get(j)).intValue();
                ++j;
            }
        }
        return totalClients == 0 ? 0.0 : (double)(totalQueueSize / totalClients);
    }

    public int getInQueueSize() throws HubNetException {
        this.checkRunningStatus();
        return this.messagesList.size();
    }

    private final void sendNormal(List nodes, String tag, Object message) throws HubNetException {
        int i = 0;
        while (i < nodes.size()) {
            if (!this.send((String)nodes.get(i), tag, message)) {
                this.simulateFailedExitMessage((String)nodes.get(i));
                if (debug) {
                    System.out.println((String)nodes.get(i) + " is not a logged in user.");
                }
            }
            ++i;
        }
    }

    private final void simulateFailedExitMessage(String clientId) {
        this.enqueueMessage(new ExitMessageBox(clientId));
    }

    public int shapeIndex(String shapeName) {
        Integer shapeIndex = (Integer)this.shapesHash.get(shapeName);
        if (shapeIndex == null) {
            shapeIndex = (Integer)this.shapesHash.get("default");
        }
        return shapeIndex;
    }

    public void makeShapesHash(List shapesList) {
        this.shapesHash.clear();
        String defaultShapeName = "default";
        this.shapesHash.put(defaultShapeName, Utils.ZERO);
        int i = 1;
        while (i < shapesList.size()) {
            String shapeName = ((Shape)shapesList.get(i)).getName();
            if (!shapeName.equals(defaultShapeName)) {
                this.shapesHash.put(shapeName, Utils.reuseInteger(i));
            }
            ++i;
        }
    }

    static /* synthetic */ boolean access$0() {
        return false;
    }

    static /* synthetic */ String access$1() {
        return CALC_HUBNET_DISABLED_MSG;
    }

    private final /* synthetic */ void this() {
        this.connections = new HashMap();
        this.ncFactories = new HashMap();
        this.messagesList = Collections.synchronizedList(new LinkedList());
        this.shapesHash = new HashMap();
        this.uniqueId = "";
    }

    public HubNetManager(Workspace workspace) {
        this.this();
        this.workspace = workspace;
        if (workspace instanceof GUIWorkspace) {
            this.guiWorkspace = (GUIWorkspace)workspace;
            this.hnGraphManager = new ServerGraphManager(this.guiWorkspace);
            this.guiWorkspace.graphManager.listener(this.hnGraphManager);
        } else {
            this.hnGraphManager = null;
            this.guiWorkspace = null;
        }
        this.registerNodeConnectionFactory("COMPUTER", new NodeConnectionFactory(){

            public final NodeConnection createConnection(HubNetManager manager) throws HubNetException {
                return new CompConnection(manager);
            }
        });
        this.registerNodeConnectionFactory("TI-83+", new NodeConnectionFactory(){

            public final NodeConnection createConnection(HubNetManager manager) throws HubNetException {
                return new CalcConnection(manager);
            }
        });
    }
}

