/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.hubnet.HubNetException;
import org.nlogo.hubnet.HubNetGraphPoint;
import org.nlogo.hubnet.computer.server.CompUtils;
import org.nlogo.nvm.LogoException;
import org.nlogo.util.Exceptions;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.graphing.GraphException;
import org.nlogo.window.graphing.GraphListener;
import org.nlogo.workspace.HubNetInterface;

public strictfp class ServerGraphManager
implements GraphListener {
    private GUIWorkspace guiWorkspace;
    private List narrowCastPlots;

    private final void broadcastToClients(Object obj) {
        if (!this.guiWorkspace.graphManager.currentGraphNull() && this.guiWorkspace.computerHubNetRunning() && CompUtils.plotMirroring) {
            try {
                String plotName = this.guiWorkspace.graphManager.currentGraph().plotName();
                HubNetInterface hubNetManager = this.guiWorkspace.getHubNetManager();
                if (!this.narrowCastPlots.contains(plotName) && hubNetManager.validTag(plotName)) {
                    hubNetManager.broadcast(plotName, obj);
                }
            }
            catch (HubNetException hnex) {
                Exceptions.handle(hnex);
            }
            catch (LogoException loex) {
                Exceptions.ignore(loex);
            }
        }
    }

    private final void sendToClient(String clientId, Object obj) {
        if (!this.guiWorkspace.graphManager.currentGraphNull() && this.guiWorkspace.computerHubNetRunning()) {
            try {
                String plotName = this.guiWorkspace.graphManager.currentGraph().plotName();
                HubNetInterface hubNetManager = this.guiWorkspace.getHubNetManager();
                if (this.narrowCastPlots.contains(plotName) && hubNetManager.validTag(plotName)) {
                    hubNetManager.send(clientId, plotName, obj);
                }
            }
            catch (HubNetException hnex) {
                Exceptions.handle(hnex);
            }
            catch (LogoException loex) {
                Exceptions.ignore(loex);
            }
        }
    }

    public boolean addNarrowCastPlot(String plotName) {
        if (this.guiWorkspace.graphManager.hasGraph(plotName)) {
            this.narrowCastPlots.add(plotName);
            return true;
        }
        return false;
    }

    public void clearAll() {
        this.broadcastToClients(new Character('a'));
    }

    public void clear() {
        this.broadcastToClients(new Character('c'));
    }

    public void plotName(String name) {
    }

    public void xLabel(String label) {
    }

    public void yLabel(String label) {
    }

    public void defaultXMin(double defaultXMin) {
        this.xMin(defaultXMin);
    }

    public void defaultYMin(double defaultYMin) {
        this.yMin(defaultYMin);
    }

    public void defaultXMax(double defaultXMax) {
        this.xMax(defaultXMax);
    }

    public void defaultYMax(double defaultYMax) {
        this.yMax(defaultYMax);
    }

    public void defaultAutoPlotOn(boolean defaultAutoPlotOn) {
        this.autoPlotOn(defaultAutoPlotOn);
    }

    public void editPlotPens(List plotPens) {
    }

    public void histogram(List bars) {
        this.broadcastToClients(bars);
    }

    public void autoPlotOn(boolean flag) {
        if (flag) {
            this.broadcastToClients(new Character('n'));
        } else {
            this.broadcastToClients(new Character('f'));
        }
    }

    public void plotPenMode(int plotPenMode) {
        this.broadcastToClients(new Short((short)plotPenMode));
    }

    public void plot(double x, double y) {
        this.broadcastToClients(new HubNetGraphPoint(x, y));
    }

    public void narrowCastPlot(String clientId, double y) {
        this.sendToClient(clientId, new HubNetGraphPoint(y));
    }

    public void narrowCastPlot(String clientId, double x, double y) {
        this.sendToClient(clientId, new HubNetGraphPoint(x, y));
    }

    public void narrowCastClear(String clientId) {
        this.sendToClient(clientId, new Character('c'));
    }

    public void narrowCastPenDown(String clientId, boolean penDown) {
        this.sendToClient(clientId, new Boolean(penDown));
    }

    public void narrowCastPlotPenMode(String clientId, int plotPenMode) {
        this.sendToClient(clientId, new Short((short)plotPenMode));
    }

    public void narrowCastSetInterval(String clientId, double interval) {
        this.sendToClient(clientId, new Double(interval));
    }

    public void narrowCastSetHistogramNumBars(String clientId, int num) {
        try {
            this.narrowCastSetInterval(clientId, (this.guiWorkspace.graphManager.currentGraph().xMax() - this.guiWorkspace.graphManager.currentGraph().xMin()) / (double)num);
        }
        catch (GraphException ex) {
            Exceptions.handle(ex);
        }
    }

    public void resetPen(boolean resetPoints) {
        if (resetPoints) {
            this.broadcastToClients(new Character('r'));
        } else {
            this.broadcastToClients(new Character('p'));
        }
    }

    public void penDown(boolean penDown) {
        this.broadcastToClients(new Boolean(penDown));
    }

    public void setHistogramNumBars(int num) {
        try {
            this.setInterval(this.guiWorkspace.graphManager.currentPen().plotInterval());
        }
        catch (GraphException ex) {
            Exceptions.handle(ex);
        }
    }

    public void setPen(String s) {
        this.broadcastToClients(s);
    }

    public void setPenColor(Color color) {
        this.broadcastToClients(new Integer(color.getRGB()));
    }

    public void setInterval(double interval) {
        this.broadcastToClients(new Double(interval));
    }

    public void xRange(double min, double max) {
        ArrayList<Comparable<Character>> l = new ArrayList<Comparable<Character>>(3);
        l.add(new Character('x'));
        l.add(new Double(min));
        l.add(new Double(max));
        this.broadcastToClients(l);
    }

    public void yRange(double min, double max) {
        ArrayList<Comparable<Character>> l = new ArrayList<Comparable<Character>>(3);
        l.add(new Character('y'));
        l.add(new Double(min));
        l.add(new Double(max));
        this.broadcastToClients(l);
    }

    public void xMin(double min) {
        try {
            this.xRange(min, this.guiWorkspace.graphManager.currentGraph().xMax());
        }
        catch (GraphException ex) {
            Exceptions.handle(ex);
        }
    }

    public void xMax(double max) {
        try {
            this.xRange(this.guiWorkspace.graphManager.currentGraph().xMin(), max);
        }
        catch (GraphException ex) {
            Exceptions.handle(ex);
        }
    }

    public void yMin(double min) {
        try {
            this.yRange(min, this.guiWorkspace.graphManager.currentGraph().yMax());
        }
        catch (GraphException ex) {
            Exceptions.handle(ex);
        }
    }

    public void yMax(double max) {
        try {
            this.yRange(this.guiWorkspace.graphManager.currentGraph().yMin(), max);
        }
        catch (GraphException ex) {
            Exceptions.handle(ex);
        }
    }

    public ServerGraphManager(GUIWorkspace guiWorkspace) {
        this.guiWorkspace = guiWorkspace;
        this.narrowCastPlots = new ArrayList();
    }
}

