/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.calculator;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.nlogo.agent.Dump;
import org.nlogo.agent.LogoList;
import org.nlogo.awt.Utils;
import org.nlogo.hubnet.ErrorMessageBox;
import org.nlogo.hubnet.HubNetException;
import org.nlogo.hubnet.HubNetManager;
import org.nlogo.hubnet.MessageBox;
import org.nlogo.hubnet.NodeConnection;
import org.nlogo.hubnet.calculator.CalcUtils;
import org.nlogo.hubnet.calculator.PropertiesDialog;
import org.nlogo.hubnet.calculator.com.ti.cn.network.LoginNecessaryException;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkException;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkFacade;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkSettings;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class CalcConnection
extends NodeConnection {
    private HubNetException loginErr;
    private PropertiesDialog hubNetProps;
    protected int millisecondsBetweenChecks;
    private boolean loggedIn;
    private NetworkFacade facade;
    private String userId;
    private String password;
    private String hostName;
    private String proxyHost;
    private int proxyPort;
    private int serverPort;
    private int tagIndexFromLastInfo;
    private final String badFormatForClientInterface;
    private List tags;
    private int currentTag;
    private String lastRowReceived;
    private Object putDataLock;

    private final HubNetException loginErr() {
        return this.loginErr;
    }

    private final void loginErr(HubNetException loginErr) {
        this.loginErr = loginErr;
    }

    private final void getProps() {
        Utils.mustBeEventDispatchThread();
        this.userId(PropertiesDialog.userId());
        this.password(PropertiesDialog.password());
        this.hostName(PropertiesDialog.hostName());
        this.proxyHost = PropertiesDialog.proxyHost();
        this.proxyPort = PropertiesDialog.proxyPort();
    }

    public String nodeType() {
        return "TI-83+";
    }

    public void updateDisplay() {
    }

    public void fullUpdateDisplay() {
    }

    public boolean fullUpdateDisplay(String node) {
        return false;
    }

    public boolean nodesHaveGraphics() {
        return false;
    }

    protected boolean validTag(String tag) {
        return CalcUtils.validCalcVarName(tag);
    }

    public void run() {
        try {
            while (this.loggedIn()) {
                if (this.checkForData()) {
                    this.millisecondsBetweenChecks = this.getInitialCheckInterval();
                    continue;
                }
                this.millisecondsBetweenChecks += this.slowDown();
                Thread.sleep(this.millisecondsBetweenChecks);
            }
        }
        catch (InterruptedException ex) {
            Exceptions.ignore(ex);
        }
    }

    protected boolean doStartup() {
        Utils.mustBeEventDispatchThread();
        boolean displayPropertiesDialog = false;
        boolean anotherLoginAttempt = true;
        while (anotherLoginAttempt) {
            if (displayPropertiesDialog || PropertiesDialog.cancelledLastTime()) {
                this.hubNetProps.display();
            }
            if (PropertiesDialog.attemptLogin()) {
                if (this.loggedIn()) {
                    this.shutdown();
                }
                try {
                    anotherLoginAttempt = this.doLogin() ^ true;
                }
                catch (HubNetException ex) {
                    Object[] options = new String[]{"Yes", "No"};
                    String message = "Your login failed!  The failure was caused by:\n" + ex.getMessage() + "\n\nDo you want to edit your login information?";
                    if (1 == OptionDialog.show(this.guiWorkspace().getFrame(), "Failed Login", message, options)) {
                        anotherLoginAttempt = false;
                        PropertiesDialog.cancelledLastTime(true);
                        continue;
                    }
                    displayPropertiesDialog = true;
                }
                continue;
            }
            anotherLoginAttempt = false;
        }
        return this.loggedIn();
    }

    private final boolean doLogin() throws HubNetException {
        new ModalProgressTask(this.guiWorkspace().getFrame(), new Runnable(){

            public final void run() {
                CalcConnection.this.loggedIn(CalcConnection.this.navigatorLogin());
            }
        }, "Connecting to Navigator...");
        if (!this.loggedIn()) {
            throw this.loginErr();
        }
        return this.loggedIn();
    }

    private final boolean loggedIn() {
        return this.loggedIn;
    }

    private final void loggedIn(boolean login) {
        this.loggedIn = login;
    }

    private final void userId(String userId) {
        Utils.mustBeEventDispatchThread();
        if (!userId.equals(this.userId)) {
            this.userId = userId;
            this.shutdown();
        }
    }

    private final void password(String password) {
        Utils.mustBeEventDispatchThread();
        if (!password.equals(this.password)) {
            this.password = password;
            this.shutdown();
        }
    }

    private final void hostName(String hostName) {
        Utils.mustBeEventDispatchThread();
        while (hostName.endsWith("/")) {
            hostName = hostName.substring(0, hostName.length() - 1);
        }
        if (hostName.startsWith("http://")) {
            hostName = hostName.substring(7, hostName.length());
        }
        this.hostName = hostName;
    }

    private final boolean navigatorLogin() {
        Utils.mustBeEventDispatchThread();
        this.getProps();
        try {
            this.facade = this.proxyHost.equals("") ? new NetworkFacade(new NetworkSettings("http://" + this.hostName, this.serverPort)) : new NetworkFacade(new NetworkSettings("http://" + this.hostName, this.serverPort, this.proxyHost, this.proxyPort));
            this.facade.login(this.userId, this.password);
            if (HubNetManager.debug) {
                System.out.println("HubNet: TI-83+: " + new Date() + ": login successful");
            }
            return true;
        }
        catch (LoginNecessaryException lne) {
            this.loginErr(new HubNetException("Invalid password or user id"));
        }
        catch (NetworkException nnde) {
            this.loginErr(new HubNetException(this.hostName + " could not be reached."));
        }
        catch (UnknownHostException uhe) {
            this.loginErr(new HubNetException(this.hostName + " does not resolve to a valid IP address."));
        }
        catch (IOException ex) {
            this.loginErr(new HubNetException("Unknown cause (" + ex + ')'));
        }
        catch (RuntimeException ex) {
            this.loginErr(new HubNetException("Unknown cause (" + ex + ')'));
        }
        this.shutdown();
        if (HubNetManager.debug) {
            System.out.println("HubNet: TI-83+: " + new Date() + " login failed");
        }
        return false;
    }

    protected void doShutdown() {
        try {
            this.loggedIn(false);
            while (this.nodeThread.isAlive()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    Exceptions.ignore(ie);
                }
            }
            if (this.facade != null) {
                this.facade.logoff();
                if (HubNetManager.debug) {
                    System.out.println("HubNet: TI-83+: " + new Date() + ": logged off");
                }
            }
        }
        catch (NetworkException ex) {
            Exceptions.handle(ex);
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    private final int getInitialCheckInterval() {
        return 100;
    }

    private final int slowDown() {
        return this.millisecondsBetweenChecks < 5000 && this.tagIndexFromLastInfo == this.currentTag - 1 ? 100 : 0;
    }

    private final void setTags(LogoList tagsList) throws HubNetException {
        Utils.mustBeEventDispatchThread();
        if (tagsList.size() == 0) {
            throw new HubNetException(this.badFormatForClientInterface);
        }
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < tagsList.size()) {
            Object tagObj = tagsList.get(i);
            if (!(tagObj instanceof String)) {
                throw new HubNetException(this.badFormatForClientInterface + "  However, item " + i + " in " + Dump.logoObject(tagsList) + " is not a string.");
            }
            String tag = (String)tagObj;
            if (!CalcUtils.validCalcVarName(tag)) {
                throw new HubNetException("Item " + i + " in " + Dump.logoObject(tagsList) + ", " + tag + ", is not a valid TI-83+ variable.");
            }
            l.add(tag);
            ++i;
        }
        this.tags = l;
        this.currentTag = 0;
    }

    private final String nextTag() {
        if (this.tags == null) {
            return null;
        }
        if (this.currentTag >= this.tags.size()) {
            this.currentTag = 0;
        }
        return (String)this.tags.get(this.currentTag++);
    }

    protected void setClientInterface(LogoList interfaceInfo) throws HubNetException {
        Utils.mustBeEventDispatchThread();
        if (interfaceInfo.size() != 2 || !(interfaceInfo.get(0) instanceof String) || !(interfaceInfo.get(1) instanceof LogoList)) {
            throw new HubNetException("Since the first input to hubnet-set-client-interface is " + this.nodeType() + ", the second input must be a list with the first item a string and the second item a list of one or more strings.");
        }
        this.setTags((LogoList)interfaceInfo.get(1));
        this.resetNavigatorNotice((String)interfaceInfo.get(0));
    }

    private final void resetNavigatorNotice(String appropriateActivityName) {
        Utils.mustBeEventDispatchThread();
        Object[] options = new String[]{"Close"};
        String message = "Before closing this dialog, please do the following:\n  -Open the TISchool site in your web browser.\n  -Enable activity " + appropriateActivityName + "\n  -Open the teacher console and press the ERASE ALL DATA button.";
        OptionDialog.show(this.guiWorkspace().getFrame(), "Notice", message, options);
    }

    private final boolean checkForData() {
        try {
            Vector listOfRows;
            String variableName = this.nextTag();
            if (variableName == null) {
                return false;
            }
            if (HubNetManager.debug) {
                System.out.println(this.nodeType() + "HubNet at " + new Date() + " polling server for " + variableName);
            }
            if ((listOfRows = this.facade.getClassData(variableName, this.lastRowReceived)).size() > 0) {
                int i = 0;
                while (i < listOfRows.size()) {
                    Map row = (Map)listOfRows.get(i);
                    MessageBox messageBox = this.parseMessage(row);
                    this.enqueueMessage(messageBox);
                    if (HubNetManager.debug) {
                        System.out.println(this.getMessageDebugOutput(messageBox));
                    }
                    this.lastRowReceived = (String)row.get("Row ID");
                    ++i;
                }
                this.tagIndexFromLastInfo = this.currentTag - 1;
                return true;
            }
        }
        catch (IOException ex) {
            this.displayTroubleConnectingError(ex);
        }
        catch (NetworkException ex) {
            this.displayTroubleConnectingError(ex);
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
        return false;
    }

    private final void displayTroubleConnectingError(Exception ex) {
        Object[] options = new String[]{"Close"};
        String message = "Trouble connecting to the Navigator server.\n\nCheck the network connections and settings to make sure that the computers are still connected.";
        OptionDialog.show(this.guiWorkspace().getFrame(), "Error Connecting To Server", message, options);
        ex.printStackTrace();
    }

    private final MessageBox parseMessage(Map row) {
        String tag = (String)row.get("Variable Name");
        String source = (String)row.get("User ID");
        String message = (String)row.get("Variable String Value");
        Object content = null;
        if (CalcUtils.validBuiltInCalcVarName(tag, CalcUtils.calcBuiltInStringNames)) {
            content = message;
        } else if (CalcUtils.validCalcVarNameForList(tag) && message.startsWith("{")) {
            content = CalcUtils.dismantleListString(message);
        } else if (CalcUtils.validBuiltInCalcVarName(tag, CalcUtils.calcBuiltInNumberNames)) {
            try {
                content = Integer.valueOf(message);
            }
            catch (NumberFormatException e) {
                try {
                    content = Double.valueOf(message);
                }
                catch (NumberFormatException e2) {
                    Exceptions.ignore(e2);
                }
            }
        } else {
            return new ErrorMessageBox(source, "internal error: " + message + " is an invalid HubNet type for the tag " + tag);
        }
        return new MessageBox(tag, source, content);
    }

    private final void stopModel() {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("cannot be called on event thread");
        }
        this.shutdown();
        this.workspace().jobManager.waitForFinishedJobs();
        try {
            Utils.invokeAndWait(new Runnable(){

                public final void run() {
                    ((CalcConnection)CalcConnection.this).workspace().world.displayOn(true);
                }
            });
        }
        catch (InterruptedException iex) {
            Exceptions.handle(iex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void broadcast(final String tag, Object message) throws HubNetException {
        try {
            final Object massagedData = CalcUtils.massageData(message);
            if (massagedData == null) throw new HubNetException(Dump.logoObject(message) + " is an unknown data type for the calculators.  See HubNet documentation for valid data types.");
            if (!CalcUtils.validCalcData(massagedData)) {
                throw new HubNetException(Dump.logoObject(message) + " is an unknown data type for the calculators.  See HubNet documentation for valid data types.");
            }
            if (!CalcUtils.validCalcVarNameForData(tag, massagedData)) {
                throw new HubNetException(tag + " in the calculator cannot hold data of this type: " + Dump.logoObject(message));
            }
            final String TROUBLE_SENDING_DATA = "Could not send " + (massagedData.equals(" ") || massagedData.equals("") ? "data" : massagedData) + " due to ";
            Object object = this.putDataLock;
            synchronized (object) {
                Thread backgroundThread = new Thread("org.nlogo.hubnet.CalcConnection.putData"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public final void run() {
                        try {
                            Object object = CalcConnection.this.putDataLock;
                            synchronized (object) {
                                CalcConnection.this.facade.putData(tag, massagedData);
                                if (!HubNetManager.debug) return;
                                System.out.println(CalcConnection.this.sendMessageDebugOutput(tag, massagedData));
                                return;
                            }
                        }
                        catch (LoginNecessaryException lne) {
                            CalcConnection.this.stopModel();
                            Exceptions.handle(new HubNetException(TROUBLE_SENDING_DATA + "trouble accessing the website for the activity.\nBe sure to log into the website, enable the appropriate activity, and open the teacher console."));
                            return;
                        }
                        catch (NetworkException ne) {
                            CalcConnection.this.stopModel();
                            if (ne.getMessage().equalsIgnoreCase("socket was closed")) {
                                Exceptions.handle(new HubNetException(TROUBLE_SENDING_DATA + "trouble connecting to the Host Name, " + CalcConnection.this.hostName + ".\nBe sure to log into the website, enable the appropriate activity, and open the teacher console."));
                                return;
                            }
                            Exceptions.handle(new HubNetException(TROUBLE_SENDING_DATA + "an unknown error (" + ne + ')'));
                            return;
                        }
                        catch (IOException ex) {
                            CalcConnection.this.stopModel();
                            Exceptions.handle(new HubNetException(TROUBLE_SENDING_DATA + "I/O trouble connecting to the Host Name, " + CalcConnection.this.hostName + ".\nBe sure to log into the website, enable the appropriate activity, and open the teacher console."));
                            return;
                        }
                        catch (RuntimeException ex) {
                            Exceptions.handle(ex);
                        }
                    }
                };
                backgroundThread.start();
                return;
            }
        }
        catch (HubNetException he) {
            void ex;
            throw ex;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    protected final boolean canNarrowCast() {
        return false;
    }

    public boolean send(String node, String tag, Object message) throws HubNetException {
        return false;
    }

    protected List clientSendQueueSizes() {
        return new ArrayList();
    }

    private final /* synthetic */ void this() {
        this.millisecondsBetweenChecks = this.getInitialCheckInterval();
        this.loggedIn = false;
        this.proxyPort = 80;
        this.serverPort = 80;
        this.tagIndexFromLastInfo = 0;
        this.badFormatForClientInterface = "Since the first input to hubnet-set-client-interface is " + this.nodeType() + ", the second input must be a list of a single string followed by a list of one or more strings.";
        this.currentTag = -1;
        this.lastRowReceived = "-1";
        this.putDataLock = new Object();
    }

    public CalcConnection(HubNetManager manager) throws HubNetException {
        super(manager);
        this.this();
        this.nodeThread.setName("org.nlogo.hubnet.calculator.CalcConnection");
        this.hubNetProps = new PropertiesDialog(this.guiWorkspace());
    }
}

