/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.calculator;

import java.util.StringTokenizer;
import java.util.Vector;
import org.nlogo.agent.LogoList;

strictfp final class CalcUtils {
    static String[] calcBuiltInListNames = new String[]{"L1", "L2", "L3", "L4", "L5", "L6"};
    static String[] calcBuiltInStringNames = new String[]{"STR0", "STR1", "STR2", "STR3", "STR4", "STR5", "STR6", "STR7", "STR8", "STR9"};
    static String[] calcBuiltInMatrixNames = new String[]{"[A]", "[B]", "[C]", "[D]", "[E]", "[F]", "[G]", "[H]", "[I]", "[J]"};
    static String[] calcBuiltInNumberNames = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    static final boolean validCalcData(Object data) {
        if (data instanceof Double || data instanceof String) {
            return true;
        }
        if (!(data instanceof Vector)) {
            return false;
        }
        Vector vec = (Vector)data;
        if (vec.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < vec.size()) {
            if (!(vec.elementAt(i) instanceof Double) || !(vec.elementAt(0) instanceof Double)) {
                if (!(vec.elementAt(i) instanceof Vector) || !(vec.elementAt(0) instanceof Vector)) {
                    return false;
                }
                Vector innerVec = (Vector)vec.elementAt(i);
                if (innerVec.size() <= 0) {
                    return false;
                }
                int j = 0;
                while (j < innerVec.size()) {
                    if (!(innerVec.elementAt(j) instanceof Double)) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    static final boolean validCalcVarNameForData(String varName, Object data) {
        if (data instanceof Vector) {
            if (((Vector)data).elementAt(0) instanceof Double) {
                return CalcUtils.validCalcVarNameForList(varName);
            }
            return CalcUtils.validBuiltInCalcVarName(varName, calcBuiltInMatrixNames);
        }
        if (data instanceof String) {
            return CalcUtils.validBuiltInCalcVarName(varName, calcBuiltInStringNames);
        }
        return CalcUtils.validBuiltInCalcVarName(varName, calcBuiltInNumberNames);
    }

    static final boolean validBuiltInCalcVarName(String varName, String[] validBuiltInNamesForType) {
        int i = 0;
        while (i < validBuiltInNamesForType.length) {
            if (varName.equals(validBuiltInNamesForType[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static final boolean validCalcVarNameForList(String varName) {
        char ch;
        if (CalcUtils.validBuiltInCalcVarName(varName, calcBuiltInListNames)) {
            return true;
        }
        if (CalcUtils.validBuiltInCalcVarName(varName, calcBuiltInStringNames) || CalcUtils.validBuiltInCalcVarName(varName, calcBuiltInMatrixNames)) {
            return false;
        }
        if (varName.length() <= 5 && varName.length() >= 1 && Character.isLetter(ch = varName.charAt(0)) && Character.isUpperCase(ch)) {
            int i = 1;
            while (i < varName.length()) {
                ch = varName.charAt(i);
                if (!(Character.isLetter(ch) && Character.isUpperCase(ch) || Character.isDigit(ch))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    static final boolean validCalcVarName(String varName) {
        return CalcUtils.validCalcVarNameForList(varName) || CalcUtils.validBuiltInCalcVarName(varName, calcBuiltInStringNames) || CalcUtils.validBuiltInCalcVarName(varName, calcBuiltInMatrixNames) || CalcUtils.validBuiltInCalcVarName(varName, calcBuiltInNumberNames);
    }

    static final Object massageData(Object data) {
        if (data instanceof String) {
            return data;
        }
        if (data instanceof Number) {
            return new Double(((Number)data).doubleValue());
        }
        if (data instanceof LogoList) {
            Object[] dataList = ((LogoList)data).toArray();
            Vector<Object> result = new Vector<Object>();
            int i = 0;
            while (i < dataList.length) {
                if (dataList[i] instanceof Number) {
                    result.addElement(new Double(((Number)dataList[i]).doubleValue()));
                } else {
                    if (!(dataList[i] instanceof LogoList)) {
                        return null;
                    }
                    result.addElement(CalcUtils.massageData(dataList[i]));
                }
                ++i;
            }
            return result;
        }
        return null;
    }

    static final LogoList dismantleListString(String s) {
        LogoList result = new LogoList();
        StringTokenizer tokenizer = new StringTokenizer(s, ",");
        while (tokenizer.hasMoreTokens()) {
            int index;
            String t = tokenizer.nextToken().trim();
            if (t.startsWith("{")) {
                t = t.substring(1).trim();
            }
            if (-1 != (index = t.indexOf("}"))) {
                t = t.substring(0, index).trim();
                result.add(Double.valueOf(t));
                break;
            }
            result.add(Double.valueOf(t));
        }
        return result;
    }

    private CalcUtils() {
        throw new IllegalStateException();
    }
}

