/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.calculator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.nlogo.awt.RowLayout;
import org.nlogo.awt.Utils;
import org.nlogo.hubnet.HubNetManager;
import org.nlogo.swing.OptionDialog;
import org.nlogo.swing.TextField;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class PropertiesDialog
extends JDialog
implements ActionListener {
    private static final String NAME = "TI-Navigator Login";
    private static String userId = "";
    private static String password = "";
    private static String hostName = "www.tischool.net";
    private static String proxyHost = "";
    private static int proxyPort = 80;
    private static boolean attemptLogin = false;
    private static boolean cancelledLastTime = true;
    private Workspace workspace;
    private JCheckBox debugCheckbox;
    private JButton cancelButton;
    private JButton loginButton;
    private TextField userIdField;
    private JPasswordField passwordField;
    private TextField hostNameField;
    private TextField proxyHostField;
    private TextField proxyPortField;
    private int tempProxyPort;

    void display() {
        this.debugCheckbox.setSelected(HubNetManager.debug);
        this.setVisible(true);
    }

    Workspace workspace() {
        return this.workspace;
    }

    static String userId() {
        return userId;
    }

    static String password() {
        return password;
    }

    static String hostName() {
        return hostName;
    }

    static String proxyHost() {
        return proxyHost;
    }

    static int proxyPort() {
        return proxyPort;
    }

    static boolean attemptLogin() {
        return attemptLogin;
    }

    static boolean cancelledLastTime() {
        return cancelledLastTime;
    }

    static void cancelledLastTime(boolean cancelled) {
        cancelledLastTime = cancelled;
    }

    private final void addWidgets() {
        BorderLayout border = new BorderLayout(5, 5);
        this.getContentPane().setLayout(border);
        JPanel hubNetPropertiesContainer = new JPanel();
        GridBagLayout hubNetGridbag = new GridBagLayout();
        GridBagConstraints hubNetConstraints = this.getConstraints();
        hubNetPropertiesContainer.setLayout(hubNetGridbag);
        hubNetConstraints.gridy = 0;
        hubNetConstraints.gridx = 0;
        JPanel calcPropertiesContainer = this.addCalcWidgets();
        hubNetGridbag.setConstraints(calcPropertiesContainer, hubNetConstraints);
        hubNetPropertiesContainer.add(calcPropertiesContainer);
        this.getContentPane().add((Component)hubNetPropertiesContainer, "Center");
        JPanel buttonContainer = new JPanel();
        buttonContainer.setLayout(new RowLayout(10, 1.0f, 0.5f));
        buttonContainer.add(this.cancelButton);
        buttonContainer.add(this.loginButton);
        this.getContentPane().add((Component)buttonContainer, "South");
        this.loginButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.loginButton);
        this.repaint();
    }

    GridBagConstraints getConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.1;
        c.anchor = 17;
        c.insets = new Insets(3, 3, 3, 3);
        return c;
    }

    private final JPanel addCalcWidgets() {
        JPanel p = new JPanel();
        GridBagLayout calcGridbag = new GridBagLayout();
        GridBagConstraints calcConstraints = this.getConstraints();
        p.setLayout(calcGridbag);
        JPanel[] calcContainers = new JPanel[6];
        int i = 0;
        while (i < calcContainers.length) {
            calcContainers[i] = new JPanel();
            calcContainers[i].setLayout(new BorderLayout(5, 0));
            ++i;
        }
        calcConstraints.gridy = 0;
        calcConstraints.gridx = 0;
        calcContainers[0].add((Component)new JLabel("User ID"), "West");
        calcContainers[0].add((Component)this.userIdField, "Center");
        calcGridbag.setConstraints(calcContainers[0], calcConstraints);
        p.add(calcContainers[0]);
        ++calcConstraints.gridx;
        calcContainers[1].add((Component)new JLabel("Password"), "West");
        calcContainers[1].add((Component)this.passwordField, "Center");
        calcGridbag.setConstraints(calcContainers[1], calcConstraints);
        p.add(calcContainers[1]);
        ++calcConstraints.gridy;
        calcConstraints.gridx = 0;
        calcContainers[2].add((Component)new JLabel("Host Name"), "West");
        calcContainers[2].add((Component)this.hostNameField, "Center");
        calcGridbag.setConstraints(calcContainers[2], calcConstraints);
        p.add(calcContainers[2]);
        ++calcConstraints.gridx;
        calcContainers[3].add((Component)new JLabel("Web Proxy Host Name"), "West");
        calcContainers[3].add((Component)this.proxyHostField, "Center");
        calcGridbag.setConstraints(calcContainers[3], calcConstraints);
        p.add(calcContainers[3]);
        ++calcConstraints.gridx;
        calcContainers[4].add((Component)new JLabel("Web Proxy Port #"), "West");
        calcContainers[4].add((Component)this.proxyPortField, "Center");
        calcGridbag.setConstraints(calcContainers[4], calcConstraints);
        p.add(calcContainers[4]);
        ++calcConstraints.gridy;
        calcConstraints.gridx = 0;
        calcGridbag.setConstraints(this.debugCheckbox, calcConstraints);
        p.add(this.debugCheckbox);
        return p;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.loginButton)) {
            if (this.validEnties()) {
                this.setInternalVars();
                attemptLogin = true;
                cancelledLastTime = false;
                this.setVisible(false);
            }
        } else if (e.getSource().equals(this.cancelButton)) {
            this.cancel();
        }
    }

    private final void cancel() {
        attemptLogin = false;
        cancelledLastTime = true;
        this.setVisible(false);
        this.resetWidgetValues();
    }

    private final boolean validEnties() {
        boolean bl = false;
        if (this.validProxyPortNum() && this.nonEmptyTextFieldValue(this.hostNameField, "Host Name", "Calculator") && this.nonEmptyTextFieldValue(this.userIdField, "User ID", "Calculator")) {
            bl = true;
        }
        return bl;
    }

    private final boolean validProxyPortNum() {
        try {
            Integer foo = new Integer(this.proxyPortField.getText());
            this.tempProxyPort = foo;
        }
        catch (NumberFormatException ex) {
            this.showError("Invalid value for the Proxy Port Number");
            return false;
        }
        return true;
    }

    private final boolean nonEmptyTextFieldValue(TextField field, String fieldName, String hubNetType) {
        if (field.getText().equals("")) {
            this.showError("You must have some " + fieldName + " given to use " + hubNetType + " HubNet.");
            return false;
        }
        return true;
    }

    private final void showError(String errorMessage) {
        Object[] options = new String[]{"OK"};
        OptionDialog.show(((GUIWorkspace)this.workspace).getFrame(), "Invalid Entry", errorMessage, options);
    }

    private final void setInternalVars() {
        HubNetManager.debug = this.debugCheckbox.isSelected();
        userId = this.userIdField.getText();
        password = String.valueOf(this.passwordField.getPassword());
        hostName = this.hostNameField.getText();
        proxyHost = this.proxyHostField.getText();
        proxyPort = this.tempProxyPort;
    }

    private final void resetWidgetValues() {
        this.debugCheckbox.setSelected(HubNetManager.debug);
        this.userIdField.setText(userId);
        this.passwordField.setText(password);
        this.hostNameField.setText(hostName);
        this.proxyHostField.setText(proxyHost);
        this.proxyPortField.setText(String.valueOf(proxyPort));
    }

    public String toString() {
        return "TI-Navigator Login:" + userId + ' ' + hostName + (proxyHost.equals("") ? "" : " " + proxyHost) + ' ' + proxyPort;
    }

    private final /* synthetic */ void this() {
        this.workspace = null;
        this.debugCheckbox = new JCheckBox("Debug", HubNetManager.debug);
        this.cancelButton = new JButton("Cancel");
        this.loginButton = new JButton("Login");
        this.userIdField = new TextField(userId, 10);
        this.passwordField = new JPasswordField(password, 10);
        this.hostNameField = new TextField(hostName, 18);
        this.proxyHostField = new TextField(proxyHost, 13);
        this.proxyPortField = new TextField(String.valueOf(proxyPort), 3);
        this.tempProxyPort = proxyPort;
    }

    PropertiesDialog(GUIWorkspace workspace) {
        super(workspace.getFrame(), NAME, true);
        this.this();
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                PropertiesDialog.this.cancel();
            }
        });
        this.workspace = workspace;
        this.addWidgets();
        this.pack();
        Utils.center(this, workspace.getFrame());
    }
}

