/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.calculator.com.ti.cn.network;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.nlogo.hubnet.calculator.com.ti.cn.network.LoginNecessaryException;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkException;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkInterface;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkResponse;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkSettings;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NoNetworkDataException;
import org.nlogo.hubnet.calculator.com.ti.cn.network.Session;
import org.nlogo.hubnet.calculator.com.ti.cn.network.User;
import org.nlogo.hubnet.calculator.com.ti.cn.network.Variable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class NetworkFacade {
    public static final String ROW_ID = "Row ID";
    public static final String TIMESTAMP = "Timestamp";
    public static final String FIRST_NAME = "First Name";
    public static final String LAST_NAME = "Last Name";
    public static final String VARIABLE_NAME = "Variable Name";
    public static final String VARIABLE_STRING_VALUE = "Variable String Value";
    public static final String USER_ID = "User ID";
    private static final String CLASS_DATA_URI = "/TISchoolNet/ClassData";
    private static final String GET_DATA_URI = "/TISchoolNet/DownloadData";
    private static final String GET_ACTIVITY_URI = "/TISchoolNet/DownloadActivity";
    private static final String GET_COMPONENT_URI = "/TISchoolNet/DownloadComponent";
    private static final String PUT_DATA_URI = "/TISchoolNet/UploadData";
    private static final String DATA_ITEM_NAME = "DataItemName";
    private static final String DATA_ITEM_TYPE = "DataItemType";
    private static final String DATA_ITEM_VALUE = "DataItemValue";
    private static final String DATA_ITEM_AGENT = "DataItemAgent";
    private static final String DATA_ITEM_USER = "DataItemUser";
    private static final String DATA_ITEM_COMMAND = "DataItemCommand";
    private static final String LAST_DATA_RECEIVED = "LastDataReceived";
    private static final String ACTIVITY_ID = "APN";
    private static final String ACTIVITY_VERSION = "AVN";
    private static final String COMPONENT_ID = "CDD";
    private static final String COMPONENT_VERSION = "CDDVN";
    private static final String WEB_AGENT = "Web";
    private String mlastDataReceived;
    private Session msession;
    private NetworkInterface mnetworkInterface;

    public NetworkSettings getNetworkSettings() {
        return this.mnetworkInterface.getNetworkSettings();
    }

    public void login(String userName, String password) throws NetworkException, IOException {
        this.msession = new Session(this.mnetworkInterface, userName, password);
    }

    public void logoff() throws NetworkException {
        this.msession = null;
    }

    public Object getData(String varName, int varType, String command, User user) throws NetworkException, IOException {
        try {
            this.verifyLoginStatus();
            String urlString = GET_DATA_URI;
            Hashtable<String, String> parameters = new Hashtable<String, String>();
            parameters.put(DATA_ITEM_NAME, varName);
            parameters.put(DATA_ITEM_TYPE, Integer.toString(varType));
            parameters.put(DATA_ITEM_AGENT, WEB_AGENT);
            if (command != null) {
                parameters.put(DATA_ITEM_COMMAND, command);
            }
            if (user != null) {
                parameters.put(DATA_ITEM_USER, user.toString());
            }
            NetworkResponse nr = this.msession.doHTTPPost(urlString, parameters);
            return Variable.decode(nr.getContent(), varType, command);
        }
        catch (NoNetworkDataException e) {
            return null;
        }
    }

    public Object getActivity() throws NetworkException, IOException {
        try {
            return this.getActivity(null, null);
        }
        catch (NoNetworkDataException e) {
            return null;
        }
    }

    public Object getActivity(String id, String version) throws NetworkException, IOException {
        try {
            this.verifyLoginStatus();
            String urlString = GET_ACTIVITY_URI;
            Hashtable<String, String> parameters = new Hashtable<String, String>();
            if (id != null) {
                parameters.put(ACTIVITY_ID, id);
            }
            if (version != null) {
                parameters.put(ACTIVITY_VERSION, version);
            }
            NetworkResponse nr = this.msession.doHTTPPost(urlString, parameters);
            return nr.getContent();
        }
        catch (NoNetworkDataException e) {
            return null;
        }
    }

    public Object getComponent(String id, String version) throws NetworkException, IOException {
        try {
            this.verifyLoginStatus();
            String urlString = GET_COMPONENT_URI;
            Hashtable<String, String> parameters = new Hashtable<String, String>();
            if (id != null) {
                parameters.put(COMPONENT_ID, id);
            }
            if (version != null) {
                parameters.put(COMPONENT_VERSION, version);
            }
            NetworkResponse nr = this.msession.doHTTPPost(urlString, parameters);
            return nr.getContent();
        }
        catch (NoNetworkDataException e) {
            return null;
        }
    }

    public void putData(String varName, Object value) throws NetworkException, IOException {
        this.putData(varName, Variable.getType(value), value);
    }

    protected void putData(String varName, int varType, Object value) throws NetworkException, IOException {
        this.verifyLoginStatus();
        String urlString = PUT_DATA_URI;
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        parameters.put(DATA_ITEM_NAME, varName);
        parameters.put(DATA_ITEM_TYPE, Integer.toString(varType));
        parameters.put(DATA_ITEM_VALUE, Variable.encode(value, varType));
        parameters.put(DATA_ITEM_AGENT, WEB_AGENT);
        this.msession.doHTTPPost(urlString, parameters);
    }

    public Vector getClassData(String varName, String lastDataReceived) throws NetworkException, IOException {
        this.verifyLoginStatus();
        String urlString = CLASS_DATA_URI;
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        parameters.put(DATA_ITEM_NAME, varName);
        parameters.put(LAST_DATA_RECEIVED, lastDataReceived == null ? this.mlastDataReceived : lastDataReceived);
        parameters.put(DATA_ITEM_AGENT, WEB_AGENT);
        NetworkResponse nr = this.msession.doHTTPPost(urlString, parameters);
        Vector v = new Vector();
        StringTokenizer st = new StringTokenizer(nr.getContent(), "\n");
        while (st.hasMoreElements()) {
            String line = (String)st.nextElement();
            Hashtable<String, String> h = new Hashtable<String, String>();
            StringTokenizer lt = new StringTokenizer(line, ",");
            h.put(ROW_ID, lt.nextToken());
            h.put(TIMESTAMP, lt.nextToken());
            h.put(FIRST_NAME, lt.nextToken());
            h.put(LAST_NAME, lt.nextToken());
            h.put(VARIABLE_NAME, lt.nextToken());
            StringBuffer restsb = new StringBuffer();
            boolean first = true;
            while (lt.hasMoreTokens()) {
                if (!first) {
                    restsb.append(",");
                }
                restsb.append(lt.nextToken());
                first = false;
            }
            String rest = restsb.toString();
            int lastComma = rest.lastIndexOf(",");
            h.put(VARIABLE_STRING_VALUE, rest.substring(0, lastComma));
            h.put(USER_ID, rest.substring(lastComma + 1));
            v.addElement(h);
        }
        return v;
    }

    protected void verifyLoginStatus() throws NetworkException {
        if (this.msession == null) {
            throw new LoginNecessaryException("Not Logged In");
        }
    }

    public String getVersion() {
        return "0.1.1";
    }

    private final /* synthetic */ void this() {
        this.mlastDataReceived = "-1";
        this.msession = null;
    }

    public NetworkFacade(NetworkSettings ns) {
        this.this();
        this.mnetworkInterface = new NetworkInterface(ns);
    }
}

