/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.calculator.com.ti.cn.network;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.nlogo.hubnet.calculator.com.ti.cn.network.LoginNecessaryException;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkException;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkInterface;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkResponse;

strictfp class Session {
    private static final String LOGIN_URI = "/Authenticate";
    private static final String TICKET_NAME = "Ticket";
    private static final String LOGIN_NAME = "LoginName";
    private static final String LOGIN_PASSWORD = "LoginPassword";
    private static final String NEED_TO_REAUTHENTICATE = "<REAUTHORIZE></REAUTHORIZE>";
    protected String muserName;
    protected String mpassword;
    protected NetworkInterface mnetworkInterface;
    protected Hashtable mcookies;

    protected void logoff() {
        this.mcookies = new Hashtable();
        this.mcookies.put(TICKET_NAME, "-1");
    }

    protected void login() throws NetworkException, IOException {
        this.login(this.muserName, this.mpassword);
    }

    protected void login(String loginName, String password) throws NetworkException, IOException {
        this.logoff();
        this.muserName = loginName;
        this.mpassword = password;
        String urlString = LOGIN_URI;
        Properties parameters = new Properties();
        ((Hashtable)parameters).put(LOGIN_NAME, loginName);
        ((Hashtable)parameters).put(LOGIN_PASSWORD, password);
        NetworkResponse nr = this.mnetworkInterface.doHTTPPost(urlString, this.mcookies, parameters);
        this.setSessionID(nr.getHeader("Set-Cookie"));
    }

    /*
     * WARNING - void declaration
     */
    public NetworkResponse doHTTPPost(String urlString, Hashtable parameters) throws NetworkException, IOException {
        try {
            void e;
            NetworkResponse nr = this.mnetworkInterface.doHTTPPost(urlString, this.mcookies, parameters);
            if (nr.getContent().indexOf(NEED_TO_REAUTHENTICATE) != -1) {
                System.out.println("---");
                System.out.println("LOGGIN IN AGAIN...");
                this.login();
                nr = this.mnetworkInterface.doHTTPPost(urlString, this.mcookies, parameters);
                if (nr.getContent().indexOf(NEED_TO_REAUTHENTICATE) != -1) {
                    System.out.println("LOGGIN IN AGAIN FAILURE...");
                    throw new LoginNecessaryException("Cannot re-login");
                }
                System.out.println("LOGGIN IN AGAIN SUCCESSFUL...");
            }
            this.setSessionID(nr.getHeader("Set-Cookie"));
            return e;
        }
        catch (MalformedURLException e) {
            throw new NetworkException(e + "  Internal error.  Report to software provider");
        }
    }

    protected void setSessionID(String setCookies) throws NetworkException {
        if (setCookies != null) {
            StringTokenizer st = new StringTokenizer(setCookies, ";");
            while (st.hasMoreTokens()) {
                String cookie = st.nextToken();
                if (!cookie.startsWith(TICKET_NAME)) continue;
                int eindex = cookie.indexOf("=") + 1;
                String ticketVal = cookie.substring(eindex);
                this.mcookies.put(TICKET_NAME, ticketVal);
                return;
            }
        }
        if (this.mcookies.get(TICKET_NAME).equals("-1")) {
            throw new LoginNecessaryException("Not Logged In");
        }
    }

    protected Hashtable getCookies() {
        return this.mcookies;
    }

    public Session(NetworkInterface networkInterface, String userName, String password) throws NetworkException, IOException {
        this.mnetworkInterface = networkInterface;
        this.login(userName, password);
    }
}

