/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.calculator.com.ti.cn.network;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.nlogo.hubnet.calculator.com.ti.cn.network.NetworkException;
import org.nlogo.util.Base64Encoder;

public strictfp class Variable {
    public static final int REAL = 0;
    public static final int REAL_LIST = 1;
    public static final int REAL_MATRIX = 2;
    public static final int STRING = 5;

    protected static String encode(Object data, int dataType) {
        String stringRep = null;
        boolean flag = false;
        switch (dataType) {
            case 0: {
                stringRep = Variable.b64encode(Variable.tokenize(data.toString()));
                break;
            }
            case 1: {
                StringBuffer sb = new StringBuffer();
                sb.append("{");
                flag = false;
                Enumeration e = ((Vector)data).elements();
                while (e.hasMoreElements()) {
                    if (flag) {
                        sb.append(",");
                    }
                    sb.append(e.nextElement().toString());
                    flag = true;
                }
                sb.append("}");
                stringRep = Variable.b64encode(Variable.tokenize(sb.toString()));
                break;
            }
            case 2: {
                StringBuffer sb = new StringBuffer();
                sb.append("[");
                Enumeration e = ((Vector)data).elements();
                while (e.hasMoreElements()) {
                    Vector v = (Vector)e.nextElement();
                    sb.append("[");
                    flag = false;
                    Enumeration e1 = v.elements();
                    while (e1.hasMoreElements()) {
                        if (flag) {
                            sb.append(",");
                        }
                        sb.append(e1.nextElement().toString());
                        flag = true;
                    }
                    sb.append("]");
                }
                sb.append("]");
                stringRep = Variable.b64encode(Variable.tokenize(sb.toString()));
                break;
            }
            case 5: {
                stringRep = Variable.b64encode(Variable.tokenize(data.toString()));
                break;
            }
        }
        return stringRep;
    }

    protected static String tokenize(String data) {
        data = data.replace('-', '\u00b0');
        data = data.replace('.', ':');
        data = data.replace('{', '\b');
        data = data.replace('}', '\t');
        data = data.replace('[', '\u0006');
        data = data.replace(']', '\u0007');
        data = data.replace(',', '+');
        return data;
    }

    protected static int getType(Object obj) throws NetworkException {
        if (obj instanceof Double) {
            return 0;
        }
        if (obj instanceof Vector) {
            if (((Vector)obj).elementAt(0) instanceof Double) {
                return 1;
            }
            if (((Vector)obj).elementAt(0) instanceof Vector) {
                return 2;
            }
        } else if (obj instanceof String) {
            return 5;
        }
        throw new NetworkException("Unknown Data Type");
    }

    protected static String b64encode(String data) {
        return Base64Encoder.encode(data);
    }

    protected static Object decode(String data, int dataType, String command) throws NetworkException {
        Vector<Serializable> returnValue = null;
        if (command == "Collate") {
            switch (dataType) {
                case 0: {
                    dataType = 1;
                    break;
                }
                case 1: {
                    dataType = 2;
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    throw new NetworkException("Invalid collation data type");
                }
            }
        }
        if (dataType == 0) {
            returnValue = Double.valueOf(data);
        } else if (dataType == 1) {
            returnValue = new Vector();
            StringTokenizer st = new StringTokenizer(data.substring(1, data.length() - 2), ",");
            while (st.hasMoreTokens()) {
                returnValue.addElement(Double.valueOf(st.nextToken()));
            }
        } else if (dataType == 2) {
            returnValue = new Vector<Serializable>();
            StringTokenizer st = new StringTokenizer(data.substring(1, data.length() - 2), "][");
            while (st.hasMoreTokens()) {
                Vector<Double> v = new Vector<Double>();
                String tok = st.nextToken();
                StringTokenizer st1 = new StringTokenizer(tok, ",");
                while (st1.hasMoreTokens()) {
                    v.addElement(Double.valueOf(st1.nextToken()));
                }
                returnValue.addElement(v);
            }
        } else {
            returnValue = data;
        }
        return returnValue;
    }

    private Variable() {
        throw new IllegalStateException();
    }
}

