/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.client;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.nlogo.hubnet.computer.client.ClientFrame;
import org.nlogo.hubnet.computer.client.ClientPanel;
import org.nlogo.hubnet.computer.client.MacHandlers;
import org.nlogo.swing.Utils;
import org.nlogo.util.Exceptions;
import org.nlogo.window.RuntimeErrorDialog;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class ClientApplet
extends JPanel {
    private static int testIndex = 1;
    private boolean isLocal;
    private boolean isRoboClient;
    private long roboClientWaitTime;
    private String userID;
    private String hostIP;
    private String portNumber;
    private ClientPanel clientPanel;
    protected ClientFrame frame;

    public static void main(String[] args) {
        Workspace.isApp(true);
        Workspace.isApplet(false);
        Utils.detectBadJVMs();
        try {
            ClientApplet applet = new ClientApplet();
            if (System.getProperty("os.name").startsWith("Mac")) {
                MacHandlers.init(applet);
            }
            applet.processCommandLineArguments(args);
            if (applet.isRoboClient) {
                applet.startup(false, applet.roboClientWaitTime);
            } else {
                applet.startup(false);
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    public void startup(final boolean isLocal) {
        this.isLocal = isLocal;
        org.nlogo.awt.Utils.invokeLater(new Runnable(){

            public final void run() {
                ClientApplet.this.frame = new ClientFrame("HubNet", ClientApplet.this, isLocal);
                ClientApplet.this.frame.setIconImage(org.nlogo.awt.Utils.loadImageResource("/images/arrowhead.gif"));
                ClientApplet.this.frame.getContentPane().setLayout(new BorderLayout());
                ClientApplet.this.frame.getContentPane().add((Component)ClientApplet.this, "Center");
                ClientApplet.this.frame.setResizable(false);
                ClientApplet.this.clientPanel = ClientApplet.this.isRoboClient ? new ClientPanel(ClientApplet.this.roboClientWaitTime) : new ClientPanel(isLocal);
                ClientApplet.this.setLayout(new BorderLayout());
                ClientApplet.this.add((Component)ClientApplet.this.clientPanel, "Center");
                ClientApplet.this.clientPanel.setDefaultLoginValues(ClientApplet.this.userID, ClientApplet.this.hostIP, ClientApplet.this.portNumber);
                ClientApplet.this.frame.pack();
                org.nlogo.awt.Utils.center(ClientApplet.this.frame, null);
                ClientApplet.this.frame.setVisible(true);
                ClientApplet.this.clientPanel.requestFocus();
            }
        });
    }

    public void startup(String hostIP, String portNumber) {
        this.userID = "Local " + testIndex++;
        this.hostIP = hostIP;
        this.portNumber = portNumber;
        this.startup(true);
    }

    public void startup(boolean isLocal, long waitTime) {
        this.isRoboClient = true;
        this.roboClientWaitTime = waitTime;
        this.startup(isLocal);
    }

    public void exit() {
        if (this.clientPanel != null) {
            this.clientPanel.exit();
        } else {
            this.frame.destroy();
        }
    }

    public void quit() {
        if (this.clientPanel != null) {
            this.clientPanel.quit();
        } else {
            this.frame.destroy();
        }
    }

    public void addNotify() {
        try {
            super.addNotify();
            if (!this.isLocal) {
                RuntimeErrorDialog.init(this);
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    private final void processCommandLineArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("--robo")) {
                this.isRoboClient = true;
                if (i + 1 < args.length) {
                    try {
                        this.roboClientWaitTime = new Long(args[i + 1]);
                        ++i;
                    }
                    catch (NumberFormatException nfe) {
                        Exceptions.ignore(nfe);
                    }
                }
            } else if (args[i].equalsIgnoreCase("--id")) {
                this.userID = args[++i];
            } else if (args[i].equalsIgnoreCase("--ip")) {
                this.hostIP = args[++i];
            } else if (args[i].equalsIgnoreCase("--port")) {
                this.portNumber = args[++i];
            }
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.isLocal = false;
        this.isRoboClient = false;
        this.roboClientWaitTime = 500L;
    }

    public ClientApplet() {
        this.this();
    }
}

