/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import org.nlogo.awt.Utils;
import org.nlogo.hubnet.computer.client.ClientGraphics;
import org.nlogo.window.InterfacePanelLite;
import org.nlogo.window.graphing.GraphManager;

public strictfp class ClientGUI
extends JPanel {
    private InterfacePanelLite interfacePanel;
    private JPanel statusPanel;
    private JTextArea messageTextArea;

    void setStatus(String userName, String activity, String server, String portNumber) {
        if (this.statusPanel != null) {
            throw new IllegalStateException("ClientGUI.setStatus can only be called once");
        }
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 0));
        this.statusPanel.add(new StatusField("User name", userName));
        this.statusPanel.add(Box.createHorizontalGlue());
        this.statusPanel.add(new StatusField("Server", server));
        this.statusPanel.add(new StatusField("Port", portNumber));
        this.add(this.statusPanel);
        Utils.getFrame(this).setTitle("HubNet: " + activity);
    }

    public void requestFocus() {
        if (this.interfacePanel != null) {
            this.interfacePanel.requestFocus();
        }
    }

    void removeInterfacePanel() {
        if (this.interfacePanel != null) {
            this.remove(this.interfacePanel);
            this.interfacePanel = null;
        }
    }

    void addMessage(String message) {
        if (this.messageTextArea == null) {
            this.messageTextArea = new JTextArea(2, 3);
            int messageAreaHeight = 88;
            this.messageTextArea.setDragEnabled(false);
            this.messageTextArea.setEditable(false);
            this.messageTextArea.setForeground(Color.darkGray);
            JScrollPane messageAreaScrollPane = new JScrollPane(this.messageTextArea);
            messageAreaScrollPane.setBorder(new BevelBorder(1));
            Dimension d = Utils.getFrame(this).getSize();
            Utils.getFrame(this).setSize(d.width, d.height + 88);
            this.add(messageAreaScrollPane);
            this.revalidate();
        }
        this.messageTextArea.append(message);
        this.messageTextArea.setCaretPosition(this.messageTextArea.getDocument().getLength());
    }

    void clearMessages() {
        this.messageTextArea.setText("");
    }

    public Component[] getInterfaceComponents() {
        return this.interfacePanel.getComponents();
    }

    public ClientGUI(ClientGraphics clientGraphics, GraphManager graphManager) {
        this.setLayout(new BoxLayout(this, 1));
        this.interfacePanel = new InterfacePanelLite(clientGraphics, null, graphManager, null);
        this.interfacePanel.sliderEventOnReleaseOnly(true);
        this.add(this.interfacePanel);
    }

    private static class StatusField
    extends JPanel {
        public StatusField(String labelStr, String valueStr) {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(new EmptyBorder(4, 4, 4, 4));
            JLabel label = new JLabel(labelStr + ": ");
            JLabel value = new JLabel(valueStr);
            label.setFont(label.getFont().deriveFont((float)((double)label.getFont().getSize() - (double)2)));
            label.setFont(label.getFont().deriveFont(1));
            value.setFont(value.getFont().deriveFont((float)((double)value.getFont().getSize() - (double)2)));
            this.add(label);
            this.add(value);
        }
    }
}

