/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.client;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.Shape;
import org.nlogo.agent.ShapeList;
import org.nlogo.agent.Turtle;
import org.nlogo.awt.Utils;
import org.nlogo.hubnet.computer.client.ClientPanel;
import org.nlogo.hubnet.computer.mirroring.ClientWorld;
import org.nlogo.hubnet.computer.mirroring.PatchData;
import org.nlogo.hubnet.computer.mirroring.TurtleData;
import org.nlogo.shapes.VectorShape;
import org.nlogo.util.Exceptions;
import org.nlogo.window.AWTColor;
import org.nlogo.window.GraphicsWidgetInterface;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.TurtleDrawer;
import org.nlogo.window.Widget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class ClientGraphics
extends Widget
implements GraphicsWidgetInterface,
MouseListener,
MouseMotionListener {
    private ClientWorld world;
    private ClientPanel clientPanel;
    private TurtleDrawer turtleDrawer;
    private boolean blank;
    private int screenEdgeX;
    private int screenEdgeY;
    private int screenSizeX;
    private int screenSizeY;
    private double patchSize;
    private int labelSize;
    private boolean[] occupiedPatches;
    private final ShapeList shapeList;
    private VectorShape[] shapesArr;
    boolean mouseInside;
    boolean isMouseDown;
    double mouseXCor;
    double mouseYCor;

    public synchronized void paintComponent(Graphics g) {
        if (this.blank || this.world.getScreenEdgeX() != this.screenEdgeX || this.world.getScreenEdgeY() != this.screenEdgeY) {
            Rectangle bounds = this.getBounds();
            g.setColor(InterfaceColors.GRAPHICS_BACKGROUND);
            g.fillRect(0, 0, bounds.width, bounds.height);
            return;
        }
        if (this.world != null) {
            if (this.labelSize != this.world.getLabelSize()) {
                this.labelSize = this.world.getLabelSize();
                Font font = this.getFont();
                Font newFont = new Font(font.getName(), font.getStyle(), this.labelSize);
                this.setFont(newFont);
            }
            PatchData[] patches = this.world.getPatches();
            int i = 0;
            while (i < patches.length) {
                this.drawPatch(g, patches[i]);
                ++i;
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            i = 0;
            while (i < patches.length) {
                if (patches[i].getLabel().length() > 0) {
                    this.drawPatchLabel(g, patches[i]);
                }
                ++i;
            }
            if (this.world.drawExact()) {
                this.paintExactTurtles(g);
            } else {
                this.paintGridTurtles(g);
            }
        }
    }

    protected synchronized void updateDisplay(byte[] worldData) {
        if (this.world != null) {
            try {
                this.world.updateFrom(new DataInputStream(new ByteArrayInputStream(worldData)));
                this.blank = false;
            }
            catch (IOException e) {
                Exceptions.handle(e);
            }
            this.repaint();
        }
    }

    synchronized void blank() {
        this.blank = true;
        this.repaint();
    }

    private final void drawPatch(Graphics g, PatchData patch) {
        try {
            if (patch == null) {
                return;
            }
            int x = (int)((double)this.graphicsX(patch) * this.patchSize);
            int y = (int)((double)this.graphicsY(patch) * this.patchSize);
            int width = (int)((double)(this.graphicsX(patch) + 1) * this.patchSize) - x;
            int height = (int)((double)(this.graphicsY(patch) + 1) * this.patchSize) - y;
            g.setColor(AWTColor.getColor(patch.getColor()));
            g.fillRect(x, y, width, height);
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    private final void paintExactTurtles(Graphics g) {
        Iterator it = this.world.getTurtles();
        while (it.hasNext()) {
            this.drawTurtle(g, (TurtleData)it.next());
        }
    }

    private final void paintGridTurtles(Graphics g) {
        ArrayList<TurtleData> visibleTurtles = new ArrayList<TurtleData>();
        Arrays.fill(this.occupiedPatches, false);
        Iterator it = this.world.getTurtles();
        while (it.hasNext()) {
            TurtleData turtle = (TurtleData)it.next();
            int patchId = this.patchId(turtle.getXcor(), turtle.getYcor());
            if (turtle.isHidden() || this.occupiedPatches[patchId]) continue;
            visibleTurtles.add(turtle);
            this.occupiedPatches[patchId] = true;
        }
        it = visibleTurtles.iterator();
        while (it.hasNext()) {
            this.drawTurtle(g, (TurtleData)it.next());
        }
    }

    private final void drawTurtle(Graphics g, TurtleData turtle) {
        double effectiveTurtleSize;
        if (turtle.isHidden()) {
            return;
        }
        double d = effectiveTurtleSize = this.world.drawExact() ? turtle.getSize() : 1.0;
        if (this.world.useShapes() && effectiveTurtleSize * this.patchSize > (double)2) {
            this.drawTurtleShape(g, turtle, effectiveTurtleSize);
        } else {
            this.drawTurtleNoShape(g, turtle, effectiveTurtleSize);
        }
        if (turtle.getLabel().length() > 0) {
            this.drawLabel(g, this.graphicsX(turtle), this.graphicsY(turtle), turtle.getLabel(), turtle.getLabelColor());
        }
    }

    private final void drawTurtleShape(Graphics g, TurtleData turtle, double effectiveTurtleSize) {
        Shape turtleShape = turtle.getShape() >= this.shapesArr.length ? this.shapeList.shape("default") : this.shapesArr[turtle.getShape()];
        Turtle agent = new Turtle(turtle.getColor(), turtle.getHeading(), turtleShape, turtle.isHidden());
        int n = this.graphicsX(turtle);
        int n2 = this.graphicsY(turtle);
        int n3 = (int)StrictMath.floor(this.patchSize);
        int n4 = (int)StrictMath.floor(this.patchSize);
        boolean bl = false;
        if (effectiveTurtleSize == 1.0) {
            bl = true;
        }
        this.turtleDrawer.drawTurtle(g, n, n2, n3, n4, effectiveTurtleSize, agent, bl);
    }

    private final void drawTurtleNoShape(Graphics g, TurtleData turtle, double effectiveTurtleSize) {
        g.setColor(AWTColor.getColor(turtle.getColor()));
        int rectSize = (int)(this.patchSize * effectiveTurtleSize);
        int offset = (rectSize - (int)this.patchSize) / 2;
        if (this.patchSize >= (double)5) {
            g.fillRect(this.graphicsX(turtle) - offset + 1, this.graphicsY(turtle) - offset + 1, rectSize - 2, rectSize - 2);
        } else {
            g.fillRect(this.graphicsX(turtle) - offset, this.graphicsY(turtle) - offset, rectSize, rectSize);
        }
    }

    private final void drawPatchLabel(Graphics g, PatchData patch) {
        int x = (int)((double)this.graphicsX(patch) * this.patchSize);
        int y = (int)((double)this.graphicsY(patch) * this.patchSize);
        this.drawLabel(g, x, y, patch.getLabel(), patch.getLabelColor());
    }

    private final void drawLabel(Graphics g, int x, int y, String label, double color) {
        y = (int)((double)y + this.patchSize);
        g.setColor(AWTColor.getColor(color));
        FontMetrics fm = g.getFontMetrics();
        int centerAdjustment = (int)(this.patchSize / (double)4 - (double)(fm.getMaxAscent() / 4));
        centerAdjustment = StrictMath.min(0, centerAdjustment);
        int leftx = (int)StrictMath.floor((double)(x - fm.stringWidth(label)) + this.patchSize);
        if (this.patchSize >= (double)(fm.getMaxAscent() + fm.getMaxDescent())) {
            g.drawString(label, leftx, y - fm.getMaxDescent());
        } else {
            g.drawString(label, leftx, y - centerAdjustment);
        }
    }

    private final int graphicsX(TurtleData turtle) {
        if (this.world.drawExact()) {
            return (int)(this.patchSize * (turtle.getXcor() + (double)this.screenEdgeX));
        }
        return (int)(this.patchSize * (double)(StrictMath.round(turtle.getXcor()) + (long)this.screenEdgeX));
    }

    private final int graphicsY(TurtleData turtle) {
        if (this.world.drawExact()) {
            return (int)(this.patchSize * ((double)this.screenEdgeY - turtle.getYcor()));
        }
        return (int)(this.patchSize * (double)((long)this.screenEdgeY - StrictMath.round(turtle.getYcor())));
    }

    private final int graphicsX(PatchData patch) {
        return patch.getId() % this.screenSizeX;
    }

    private final int graphicsY(PatchData patch) {
        return (int)StrictMath.floor(patch.getId() / this.screenSizeX);
    }

    private final int patchId(double xcor, double ycor) {
        return (this.screenSizeY - 1 - ((int)StrictMath.round(ycor) + this.screenEdgeY)) * this.screenSizeX + ((int)StrictMath.round(xcor) + this.screenEdgeX);
    }

    void shapes(List shapes) {
        Utils.mustBeEventDispatchThread();
        this.shapeList.clearShapes();
        this.shapesArr = new VectorShape[shapes.size()];
        int i = 0;
        while (i < shapes.size()) {
            VectorShape shape = (VectorShape)shapes.get(i);
            this.shapeList.addNewShape(shape);
            this.shapesArr[i] = shape;
            ++i;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (Utils.button1Mask(e)) {
            this.isMouseDown = true;
            this.clientPanel.sendMouseMessage(this.mouseXCor, this.mouseYCor);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (Utils.button1Mask(e)) {
            this.isMouseDown = false;
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseInside = true;
        Point p = e.getPoint();
        this.setMouseCoords(p);
    }

    public void mouseExited(MouseEvent e) {
        this.mouseInside = false;
        Point p = e.getPoint();
        this.setMouseCoords(p);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.mouseInside) {
            this.setMouseCoords(e.getPoint());
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.setMouseCoords(e.getPoint());
    }

    public void mouseClicked(MouseEvent e) {
    }

    private final void setMouseCoords(Point p) {
        Utils.mustBeEventDispatchThread();
        try {
            Rectangle rect = this.getBounds();
            double sex = this.screenEdgeX;
            double dx = (double)p.x / (double)rect.width;
            double newMouseX = (double)this.screenSizeX * (dx - 0.5);
            if (newMouseX < -(sex + 0.5)) {
                newMouseX = -(sex + 0.5);
            } else if (newMouseX >= sex + 0.5) {
                newMouseX = sex + 0.4999999;
            }
            if (this.patchSize <= 1.0) {
                newMouseX = org.nlogo.util.Utils.approximate(newMouseX, 0);
            }
            this.mouseXCor = newMouseX;
            double dy = (double)p.y / (double)rect.height;
            double newMouseY = (double)this.screenSizeY * (0.5 - dy);
            double sey = this.screenEdgeY;
            if (newMouseY < -(sey + 0.5)) {
                newMouseY = -(sey + 0.5);
            } else if (newMouseY >= sey + 0.5) {
                newMouseY = sey + 0.4999999;
            }
            if (this.patchSize <= 1.0) {
                newMouseY = org.nlogo.util.Utils.approximate(newMouseY, 0);
            }
            this.mouseYCor = newMouseY;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    public Object load(String[] strings, String version) {
        this.setSize(0, 0);
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1 - 10, y2 - y1 - 31);
        this.screenEdgeX = Integer.parseInt(strings[5]);
        this.screenEdgeY = Integer.parseInt(strings[6]);
        this.screenSizeX = this.screenEdgeX * 2 + 1;
        this.screenSizeY = this.screenEdgeY * 2 + 1;
        int numPatches = this.screenSizeX * this.screenSizeY;
        this.patchSize = (double)this.getSize().width / (double)this.screenSizeX;
        this.world = new ClientWorld(numPatches);
        this.occupiedPatches = new boolean[numPatches];
        this.blank = true;
        this.turtleDrawer = new TurtleDrawer(this.shapeList, this.patchSize);
        return this;
    }

    public String save() {
        return "";
    }

    public Widget asWidget() {
        return this;
    }

    private final /* synthetic */ void this() {
        this.shapeList = new ShapeList(null);
        this.mouseInside = false;
        this.isMouseDown = false;
        this.mouseXCor = 0.0;
        this.mouseYCor = 0.0;
    }

    ClientGraphics(ClientPanel cp) {
        this.this();
        this.clientPanel = cp;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }
}

