/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.client;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import javax.swing.JPanel;
import org.nlogo.agent.LogoList;
import org.nlogo.awt.Utils;
import org.nlogo.event.AddJobEvent;
import org.nlogo.event.ExportPlotEvent;
import org.nlogo.event.InterfaceGlobalEvent;
import org.nlogo.event.LoadSectionEvent;
import org.nlogo.hubnet.HubNetGraphPoint;
import org.nlogo.hubnet.computer.client.ClientAWTEvent;
import org.nlogo.hubnet.computer.client.ClientFrame;
import org.nlogo.hubnet.computer.client.ClientGUI;
import org.nlogo.hubnet.computer.client.ClientGraphics;
import org.nlogo.hubnet.computer.client.LoginPanel;
import org.nlogo.hubnet.computer.protocol.ActivityCommand;
import org.nlogo.hubnet.computer.protocol.DisableGraphics;
import org.nlogo.hubnet.computer.protocol.EnterMessage;
import org.nlogo.hubnet.computer.protocol.ExitMessage;
import org.nlogo.hubnet.computer.protocol.GraphicsUpdate;
import org.nlogo.hubnet.computer.protocol.Handshake;
import org.nlogo.hubnet.computer.protocol.LoginFailure;
import org.nlogo.hubnet.computer.protocol.Message;
import org.nlogo.hubnet.computer.protocol.Text;
import org.nlogo.hubnet.computer.protocol.WidgetControl;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.util.SocketListener;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.SliderWidget;
import org.nlogo.window.SwitchWidget;
import org.nlogo.window.Widget;
import org.nlogo.window.graphing.GraphException;
import org.nlogo.window.graphing.GraphManager;
import org.nlogo.window.graphing.GraphPen;
import org.nlogo.window.graphing.GraphWidget;
import org.nlogo.workspace.Exporter;
import org.nlogo.workspace.ModelReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class ClientPanel
extends JPanel
implements AddJobEvent.Handler,
ExportPlotEvent.Handler,
InterfaceGlobalEvent.Handler,
LoadSectionEvent.Raiser {
    private static final int DEFAULT_PORT_NUMBER = 9173;
    private LoginPanel loginPanel;
    private ClientGUI interfaceContainer;
    private final GraphManager graphManager;
    private ClientGraphics graphicsWidget;
    private String userName;
    private String server;
    private String port;
    private String activityName;
    private SocketListener listener;
    protected boolean connected;
    private boolean loggingIn;
    private boolean isLocal;
    protected boolean isRoboClient;
    protected long roboWaitTime;
    protected RoboWidgetControl roboClient;
    private boolean disconnecting;

    public void setDefaultLoginValues(String userName, String server, String port) {
        this.userName = userName;
        this.server = server;
        this.port = port;
    }

    private final void showLoginPanel() {
        if (this.loginPanel != null) {
            return;
        }
        this.loginPanel = new LoginPanel(this);
        this.loginPanel.setDefaultValues(this.userName, this.server, this.port);
        if (this.interfaceContainer != null) {
            this.remove(this.interfaceContainer);
        }
        this.add((Component)this.loginPanel, "Center");
        this.interfaceContainer = null;
        Utils.invokeLater(new Runnable(){

            public final void run() {
                Frame f = Utils.getFrame(ClientPanel.this);
                f.setTitle("HubNet");
                f.pack();
            }
        });
    }

    void exit() {
        Utils.mustBeEventDispatchThread();
        if (this.listener != null) {
            if (this.isLocal) {
                this.logout();
                this.quit();
            } else if (this.showExitMessage("Exit", "Do you really want to exit this activity?")) {
                this.logout();
            }
        } else {
            this.quit();
        }
    }

    void quit() {
        Utils.mustBeEventDispatchThread();
        if (this.isLocal || this.showExitMessage("Quit", "Do you really want to quit HubNet?")) {
            ((ClientFrame)Utils.getFrame(this)).destroy();
        }
    }

    private final boolean showExitMessage(String title, String message) {
        Utils.mustBeEventDispatchThread();
        Object[] buttons = new String[]{title, "Cancel"};
        boolean bl = false;
        if (OptionDialog.show(this, "Confirm " + title, message, buttons) == 0) {
            bl = true;
        }
        return bl;
    }

    private final void handleEx(Exception e, boolean sendingEx) {
        Utils.mustBeEventDispatchThread();
        if (!sendingEx && this.listener != null) {
            this.logout();
        }
        this.disconnect();
        Exceptions.handle(e);
    }

    void sendMouseMessage(double mouseXCor, double mouseYCor) {
        Utils.mustBeEventDispatchThread();
        LogoList coords = new LogoList(2);
        coords.add(new Double(mouseXCor));
        coords.add(new Double(mouseYCor));
        this.sendDataAndWait(new ActivityCommand("Graphics Window", coords));
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ClientAWTEvent && e.getSource() == this) {
            ClientAWTEvent clientEvent = (ClientAWTEvent)e;
            try {
                if (clientEvent.receivedData) {
                    this.receiveData(clientEvent.info);
                } else if (clientEvent.info instanceof Object[]) {
                    this.handleEx((Exception)((Object[])clientEvent.info)[0], (Boolean)((Object[])clientEvent.info)[1]);
                }
            }
            catch (RuntimeException ex) {
                Exceptions.handle(ex);
            }
        } else {
            super.processEvent(e);
        }
    }

    private final void receiveData(Object object) {
        Utils.mustBeEventDispatchThread();
        if (object instanceof String && !this.connected) {
            String info = (String)object;
            if (info.equals("NetLogo 2.1.0")) {
                this.sendDataAndWait(new Handshake(this.listener.getClientId()));
            } else {
                this.handleLoginFailure("The version of the HubNet Client you are using does not match the version of the server. Please use the HubNet Client that comes with " + info);
            }
            return;
        }
        if (!(object instanceof Message)) {
            return;
        }
        Message message = (Message)object;
        if (message instanceof Handshake) {
            this.completeLogin((Handshake)message);
        } else if (message instanceof LoginFailure) {
            this.handleLoginFailure((String)message.getContent());
        } else if (message instanceof Text) {
            this.interfaceContainer.addMessage((String)message.getContent());
        } else if (message instanceof ExitMessage) {
            this.disconnect();
        } else if (message instanceof WidgetControl) {
            String widgetName = ((WidgetControl)message).tag();
            this.handleWidgetControlMessage(message.getContent(), widgetName);
        } else if (message instanceof DisableGraphics) {
            this.graphicsWidget.blank();
        } else if (message instanceof GraphicsUpdate) {
            this.graphicsWidget.updateDisplay(((GraphicsUpdate)message).getByteArray());
        }
    }

    public void handleAddJobEvent(AddJobEvent e) {
        Utils.mustBeEventDispatchThread();
        ButtonWidget button = (ButtonWidget)e.owner();
        this.sendDataAndWait(new ActivityCommand(button.displayName(), button.foreverOn() ? Boolean.TRUE : Boolean.FALSE));
        button.popUpStoppingButton();
    }

    public void handleExportPlotEvent(ExportPlotEvent e) {
        block3: {
            switch (e.getWhichGraphs()) {
                case 1: {
                    throw new UnsupportedOperationException("can't export all plots yet.");
                }
            }
            final GraphWidget graph = e.getGraph();
            if (graph == null) break block3;
            new Exporter(e.getFilename()){

                protected final void export(PrintWriter writer) {
                    graph.export(writer);
                }
            }.export("plot", "HubNet Client", "");
        }
    }

    public void handleInterfaceGlobalEvent(InterfaceGlobalEvent e) {
        Utils.mustBeEventDispatchThread();
        this.sendDataAndWait(new ActivityCommand(e.widget().name(), e.widget().valueObject()));
    }

    private final void handleWidgetControlMessage(Object value, String widgetName) {
        Utils.mustBeEventDispatchThread();
        Component[] components = this.interfaceContainer.getInterfaceComponents();
        int i = 0;
        while (i < components.length) {
            Component comp;
            Widget widget;
            if (components[i] instanceof Widget && (widget = (Widget)(comp = components[i])).displayName().equals(widgetName)) {
                if (widget instanceof InterfaceGlobalWidget) {
                    ((InterfaceGlobalWidget)((Object)widget)).valueObject(value);
                } else if (widget instanceof MonitorWidget) {
                    ((MonitorWidget)widget).value(value);
                } else if (widget instanceof GraphWidget) {
                    this.handleGraphControlMessage((GraphWidget)widget, value);
                }
                return;
            }
            ++i;
        }
    }

    private final void handleGraphControlMessage(GraphWidget graphWidget, Object value) {
        block37: {
            Utils.mustBeEventDispatchThread();
            if (value instanceof String) {
                try {
                    if (graphWidget.getPen((String)value) == null) {
                        graphWidget.selectOrCreatePen((String)value);
                        break block37;
                    }
                    graphWidget.selectPen((String)value);
                }
                catch (GraphException ex) {
                    Exceptions.handle(ex);
                }
            } else if (value instanceof Integer) {
                graphWidget.setPenColor(new Color((Integer)value));
            } else if (value instanceof Boolean) {
                graphWidget.penDown((Boolean)value);
                graphWidget.repaintIfNeeded();
            } else if (value instanceof HubNetGraphPoint) {
                HubNetGraphPoint point = (HubNetGraphPoint)value;
                if (point.specifiesXCor()) {
                    graphWidget.plot(point.xcor(), point.ycor());
                } else {
                    graphWidget.plot(point.ycor());
                }
                graphWidget.repaintIfNeeded();
            } else if (value instanceof Character) {
                try {
                    switch (((Character)value).charValue()) {
                        case 'a': {
                            this.graphManager.clearAll();
                            String[] names = this.graphManager.getGraphNames();
                            int i = 0;
                            while (i < names.length) {
                                this.graphManager.getGraph(names[i]).repaintIfNeeded();
                                ++i;
                            }
                            break;
                        }
                        case 'c': {
                            graphWidget.clear();
                            graphWidget.repaintIfNeeded();
                            break;
                        }
                        case 'r': {
                            graphWidget.resetPen(true);
                            graphWidget.repaintIfNeeded();
                            break;
                        }
                        case 'p': {
                            graphWidget.resetPen(false);
                            graphWidget.repaintIfNeeded();
                            break;
                        }
                        case 'n': {
                            graphWidget.autoPlotOn(true);
                            break;
                        }
                        case 'f': {
                            graphWidget.autoPlotOn(false);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                catch (RuntimeException ex) {
                    Exceptions.handle(ex);
                }
            } else if (value instanceof Short) {
                graphWidget.plotPenMode(((Short)value).intValue());
                graphWidget.repaintIfNeeded();
            } else if (value instanceof Double) {
                graphWidget.setInterval((Double)value);
            } else if (value instanceof List) {
                if (((List)value).get(0) instanceof Integer) {
                    graphWidget.beginHistogramSafe();
                    graphWidget.histogramFromBars((List)value);
                    graphWidget.endHistogram();
                    graphWidget.repaintIfNeeded();
                } else if (((List)value).get(0) instanceof GraphPen) {
                    graphWidget.editPlotPens((List)value);
                } else if (((Character)((List)value).get(0)).charValue() == 'x') {
                    double min = (Double)((List)value).get(1);
                    double max = (Double)((List)value).get(2);
                    graphWidget.xRange(min, max);
                    graphWidget.repaintIfNeeded();
                } else {
                    double min = (Double)((List)value).get(1);
                    double max = (Double)((List)value).get(2);
                    graphWidget.yRange(min, max);
                    graphWidget.repaintIfNeeded();
                }
            }
        }
    }

    protected void disconnect() {
        Utils.mustBeEventDispatchThread();
        if (!this.disconnecting) {
            this.disconnecting = true;
            this.showLoginPanel();
            if (this.isRoboClient && this.roboClient != null && this.roboClient.running()) {
                this.roboClient.running(false);
            }
            if (this.connected && !this.isLocal && !this.isRoboClient) {
                Utils.invokeLater(new Runnable(){

                    public final void run() {
                        Object[] ok = new String[]{"OK"};
                        OptionDialog.show(ClientPanel.this, "", "You have been disconnected from " + ClientPanel.this.activityName + '.', ok);
                    }
                });
            }
            if (this.isLocal) {
                this.quit();
            }
            if (this.listener != null) {
                this.listener.disconnect();
                this.listener = null;
            }
            this.connected = false;
            this.disconnecting = false;
        }
    }

    private final void sendDataAndWait(Object obj) {
        Utils.mustBeEventDispatchThread();
        if (this.listener != null) {
            try {
                this.listener.waitForSendData(obj);
            }
            catch (IOException e) {
                Exceptions.warn(e);
            }
        } else {
            System.err.println("Attempted to send data on a shutdown listener, ignoring.");
        }
    }

    void login(final String userName, final String server, final int port) {
        if (this.loggingIn) {
            return;
        }
        this.loggingIn = true;
        this.userName = userName;
        this.server = server;
        this.port = "" + port;
        Utils.mustBeEventDispatchThread();
        final Exception[] exception = new Exception[1];
        new ModalProgressTask(Utils.getFrame(this.loginPanel), new Runnable(){

            public final void run() {
                try {
                    Socket socket = new Socket(server, port);
                    socket.setSoTimeout(0);
                    socket.setTcpNoDelay(true);
                    ClientPanel.this.listener = new Listener(userName, socket);
                    ClientPanel.this.listener.start();
                    ClientPanel.this.sendDataAndWait("NetLogo 2.1.0");
                }
                catch (IOException e) {
                    exception[0] = e;
                }
                catch (RuntimeException e) {
                    exception[0] = e;
                }
            }
        }, "Entering...");
        if (exception[0] != null) {
            String message = "Login failed:\n";
            message = exception[0] instanceof NoRouteToHostException ? message + server + " could not be reached." : (exception[0] instanceof UnknownHostException ? message + server + " does not resolve to a valid IP address." : (exception[0] instanceof ConnectException ? message + "There was no server running at " + server + " on port " + port : (exception[0] instanceof IOException ? message + "Unknown cause:\n" + org.nlogo.util.Utils.getStackTrace(exception[0]) : (exception[0] instanceof RuntimeException ? message + "Unknown cause:\n" + org.nlogo.util.Utils.getStackTrace(exception[0]) : "Internal error: unexpected exception: " + org.nlogo.util.Utils.getStackTrace(exception[0])))));
            this.handleLoginFailure(message);
        }
    }

    private final void completeLogin(Handshake handshake) {
        this.connected = true;
        this.activityName = handshake.activityName;
        this.graphicsWidget = new ClientGraphics(this);
        this.showClientGUI();
        this.loggingIn = false;
        this.interfaceContainer.setStatus(this.userName, this.activityName, this.server, this.port);
        String[] l = handshake.interfaceSpec.getWidgets();
        new LoadSectionEvent(this, "HubNet", ModelReader.WIDGETS, l).raise();
        this.graphicsWidget.shapes(handshake.interfaceSpec.getShapes());
        this.sendDataAndWait(new EnterMessage());
        if (this.isRoboClient) {
            this.roboClient = new RoboWidgetControl(this.roboWaitTime);
            this.roboClient.start();
        }
    }

    private final void showClientGUI() {
        if (this.interfaceContainer != null) {
            return;
        }
        this.interfaceContainer = new ClientGUI(this.graphicsWidget, this.graphManager);
        if (this.loginPanel != null) {
            this.remove(this.loginPanel);
        }
        this.add((Component)this.interfaceContainer, "Center");
        this.loginPanel = null;
        Utils.invokeLater(new Runnable(){

            public final void run() {
                Frame f = Utils.getFrame(ClientPanel.this);
                f.pack();
                ClientPanel.this.interfaceContainer.requestFocus();
            }
        });
    }

    private final void handleLoginFailure(String errorMessage) {
        Utils.mustBeEventDispatchThread();
        this.disconnect();
        if (!this.isRoboClient) {
            OptionDialog.show(this.loginPanel, "Login Failed", errorMessage, new String[]{"OK"});
        }
        this.loggingIn = false;
    }

    private final void logout() {
        Utils.mustBeEventDispatchThread();
        if (this.connected) {
            if (this.isRoboClient) {
                this.roboClient.running(false);
            }
            this.listener.stopWriting();
            this.sendDataAndWait(new ExitMessage());
            this.connected = false;
        }
    }

    private final /* synthetic */ void this() {
        this.connected = false;
        this.loggingIn = false;
        this.isLocal = false;
        this.isRoboClient = false;
        this.roboWaitTime = 500L;
        this.disconnecting = false;
    }

    ClientPanel(boolean isLocal) {
        this.this();
        this.isLocal = isLocal;
        this.graphManager = new GraphManager();
        this.setLayout(new BorderLayout());
        Utils.invokeLater(new Runnable(){

            public final void run() {
                ClientPanel.this.showLoginPanel();
                ClientPanel.this.loginPanel.tryToEnter();
            }
        });
        this.port = "9173";
    }

    ClientPanel(long waitTime) {
        this(false);
        this.isRoboClient = true;
        this.roboWaitTime = waitTime;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RoboWidgetControl
    extends Thread {
        private long waitTime;
        private boolean running;

        boolean running() {
            return this.running;
        }

        void running(boolean running) {
            this.running = running;
        }

        public void run() {
            while (this.running) {
                Component[] components = ClientPanel.this.interfaceContainer.getInterfaceComponents();
                int i = 0;
                while (i < components.length && this.running) {
                    Component comp;
                    Widget widget;
                    if (components[i] instanceof Widget && ((widget = (Widget)(comp = components[i])) instanceof SliderWidget || widget instanceof ButtonWidget || widget instanceof SwitchWidget)) {
                        try {
                            this.getAndSendRoboWidgetMessage(widget);
                            RoboWidgetControl.sleep(this.waitTime);
                        }
                        catch (InterruptedException ex) {
                            Exceptions.handle(ex);
                        }
                    }
                    ++i;
                }
            }
        }

        private final void getAndSendRoboWidgetMessage(final Widget widget) throws InterruptedException {
            Utils.invokeAndWait(new Runnable(){

                public final void run() {
                    Serializable value;
                    String name = widget.displayName();
                    if (widget instanceof SliderWidget) {
                        SliderWidget sliderWidget = (SliderWidget)widget;
                        name = sliderWidget.nameWrapper();
                        if (sliderWidget.value().equals(sliderWidget.maximum())) {
                            sliderWidget.value(sliderWidget.minimum());
                        } else {
                            sliderWidget.value(new Double(sliderWidget.value().doubleValue() + sliderWidget.increment().doubleValue()));
                        }
                        value = sliderWidget.value();
                    } else if (widget instanceof ButtonWidget) {
                        value = ((ButtonWidget)widget).foreverOn() ? Boolean.TRUE : Boolean.FALSE;
                    } else if (widget instanceof SwitchWidget) {
                        SwitchWidget switchWidget = (SwitchWidget)widget;
                        switchWidget.isOn(switchWidget.isOn() ^ true);
                        value = switchWidget.isOn() ? Boolean.TRUE : Boolean.FALSE;
                    } else {
                        return;
                    }
                    if (ClientPanel.this.connected) {
                        ClientPanel.this.sendDataAndWait(new ActivityCommand(name, value));
                    }
                }
            });
        }

        private final /* synthetic */ void this() {
            this.running = true;
        }

        RoboWidgetControl(long waitTime) {
            super("RoboWidgetControl Thread");
            this.this();
            this.waitTime = waitTime;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Listener
    extends SocketListener {
        public void receiveData(Object data) {
            ClientPanel.this.getToolkit().getSystemEventQueue().postEvent(new ClientAWTEvent(ClientPanel.this, data, true));
        }

        public void handleEx(Exception e, boolean sendingEx) {
            Object[] exceptionData = new Object[]{e, sendingEx ? Boolean.TRUE : Boolean.FALSE};
            ClientPanel.this.getToolkit().getSystemEventQueue().postEvent(new ClientAWTEvent(ClientPanel.this, exceptionData, false));
        }

        public void disconnect() {
            super.disconnect();
            Utils.invokeLater(new Runnable(){

                public final void run() {
                    ClientPanel.this.disconnect();
                }
            });
        }

        Listener(String userName, Socket socket) throws IOException {
            super("Listener: " + userName, socket);
            this.clientId = userName;
            this.stopWriting();
        }
    }
}

