/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Arrays;
import org.nlogo.hubnet.computer.client.AnnouncementListener;
import org.nlogo.hubnet.computer.server.DiscoveryMessage;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class DiscoveryListener
extends Thread {
    private static final String MULTICAST_GROUP = "228.5.8.80";
    private static final int MULTICAST_PORT = 5885;
    private AnnouncementListener listener;
    private boolean shouldKeepListening;

    synchronized void setAnnouncementListener(AnnouncementListener listener) {
        this.listener = listener;
    }

    synchronized void removeAnnouncementListener(AnnouncementListener listener) {
        if (listener == this.listener) {
            this.listener = null;
        }
    }

    void stopListening() {
        this.shouldKeepListening = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void notifyListeners(DiscoveryMessage m) {
        if (this.listener == null) return;
        AnnouncementListener announcementListener = this.listener;
        synchronized (announcementListener) {
            this.listener.announcementReceived(m);
            return;
        }
    }

    public void run() {
        byte[] receiptBuffer = new byte[1024];
        MulticastSocket multicastSocket = null;
        try {
            InetAddress group = InetAddress.getByName(MULTICAST_GROUP);
            multicastSocket = new MulticastSocket(5885);
            multicastSocket.joinGroup(group);
            while (this.shouldKeepListening) {
                Arrays.fill(receiptBuffer, (byte)0);
                DatagramPacket packet = new DatagramPacket(receiptBuffer, receiptBuffer.length - 1);
                try {
                    multicastSocket.receive(packet);
                    String sender = packet.getAddress().getHostName();
                    DiscoveryMessage message = new DiscoveryMessage(sender, packet.getData());
                    this.notifyListeners(message);
                }
                catch (IOException ex) {
                    Exceptions.ignore(ex);
                }
            }
            multicastSocket.leaveGroup(group);
        }
        catch (IOException ioe) {
            Exceptions.ignore(ioe);
        }
        if (multicastSocket != null) {
            multicastSocket.close();
        }
    }

    private final /* synthetic */ void this() {
        this.shouldKeepListening = true;
    }

    DiscoveryListener() {
        this.this();
    }
}

