/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.nlogo.hubnet.computer.client.ClientPanel;
import org.nlogo.hubnet.computer.client.ServerTable;
import org.nlogo.swing.NonemptyTextFieldButtonEnabler;
import org.nlogo.swing.TextField;
import org.nlogo.swing.TextFieldBox;

public strictfp class LoginPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
DocumentListener {
    private ClientPanel clientPanel;
    private TextField nameField;
    private TextField serverField;
    private TextField portField;
    private JPanel centerPanel;
    private JButton enterButton;
    private ServerTable serverTable;
    private JScrollPane serverTablePane;
    private boolean isServerTableSelectingValue;

    public void addNotify() {
        super.addNotify();
        this.getRootPane().setDefaultButton(this.enterButton);
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                LoginPanel.this.nameField.requestFocus();
            }
        });
    }

    public void setDefaultValues(String userName, String server, String port) {
        if (userName != null) {
            this.nameField.setText(userName);
        }
        if (server != null) {
            this.serverField.setText(server);
        }
        if (port != null) {
            this.portField.setText(port);
        }
    }

    public void tryToEnter() {
        this.enterButton.doClick();
    }

    public void valueChanged(ListSelectionEvent e) {
        int i;
        if (!e.getValueIsAdjusting() && (i = this.serverTable.getSelectionModel().getMinSelectionIndex()) > -1) {
            this.isServerTableSelectingValue = true;
            String server = (String)this.serverTable.getValueAt(i, 2);
            this.serverField.setText(server);
            String port = (String)this.serverTable.getValueAt(i, 3);
            this.portField.setText(port);
            this.isServerTableSelectingValue = false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isVisible()) {
            return;
        }
        try {
            String name = this.nameField.getText();
            String server = this.serverField.getText();
            String portString = this.portField.getText();
            int portNumber = Integer.parseInt(portString);
            this.clientPanel.login(name, server, portNumber);
        }
        catch (NumberFormatException nfex) {
            JOptionPane.showMessageDialog(this, "Invalid port number", "Login Failed", 1);
            SwingUtilities.invokeLater(new Runnable(){

                public final void run() {
                    LoginPanel.this.portField.requestFocus();
                }
            });
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.fieldChangeUpdate();
    }

    public void insertUpdate(DocumentEvent e) {
        this.fieldChangeUpdate();
    }

    public void removeUpdate(DocumentEvent e) {
        this.fieldChangeUpdate();
    }

    private final void fieldChangeUpdate() {
        int i;
        if (!this.isServerTableSelectingValue && (i = this.serverTable.getSelectionModel().getMinSelectionIndex()) > -1) {
            String server = (String)this.serverTable.getValueAt(i, 2);
            String port = (String)this.serverTable.getValueAt(i, 3);
            if (!port.equals(this.portField.getText()) || !server.equals(this.serverField.getText())) {
                this.serverTable.clearSelection();
            }
        }
    }

    public void setVisible(boolean visible) {
        this.serverTable.setActive(visible);
        super.setVisible(visible);
    }

    public LoginPanel(ClientPanel clientPanel) {
        this.clientPanel = clientPanel;
        this.nameField = new TextField(14);
        this.serverField = new TextField(26);
        this.portField = new TextField(4);
        this.portField.setText("9173");
        this.serverTable = new ServerTable();
        this.enterButton = new JButton("Enter");
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.add((Component)this.centerPanel, "Center");
        TextFieldBox tfb = new TextFieldBox();
        tfb.addField("User name:", this.nameField);
        tfb.add(Box.createVerticalStrut(12));
        tfb.addField("Server:", this.serverField);
        tfb.addField("Port:", this.portField);
        this.centerPanel.add(tfb);
        this.centerPanel.add(Box.createVerticalStrut(12));
        this.centerPanel.add(Box.createVerticalStrut(2));
        this.serverTablePane = new JScrollPane(this.serverTable);
        this.centerPanel.add(this.serverTablePane);
        Dimension tableSize = new Dimension();
        tableSize.width = this.serverTable.getPreferredScrollableViewportSize().width;
        tableSize.width = 100;
        tableSize.height = 88;
        this.serverTablePane.setPreferredSize(tableSize);
        this.serverTablePane.setVisible(false);
        this.isServerTableSelectingValue = false;
        this.centerPanel.add(Box.createVerticalGlue());
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.enterButton);
        this.add((Component)buttonPanel, "South");
        this.serverTable.getSelectionModel().addListSelectionListener(this);
        this.enterButton.addActionListener(this);
        this.serverField.getDocument().addDocumentListener(this);
        this.portField.getDocument().addDocumentListener(this);
        this.serverTable.addMouseListener(new MouseAdapter(){

            public final void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (LoginPanel.this.enterButton.isEnabled()) {
                        LoginPanel.this.enterButton.doClick();
                    } else {
                        LoginPanel.this.nameField.requestFocus();
                    }
                }
            }
        });
        NonemptyTextFieldButtonEnabler buttonEnabler = new NonemptyTextFieldButtonEnabler(this.enterButton);
        buttonEnabler.addRequiredField(this.nameField);
        buttonEnabler.addRequiredField(this.serverField);
        buttonEnabler.addRequiredField(this.portField);
        this.serverTablePane.setVisible(true);
        this.serverTable.setActive(true);
    }
}

