/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.mirroring;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.nlogo.hubnet.computer.mirroring.PatchData;
import org.nlogo.hubnet.computer.mirroring.TurtleData;

public strictfp class ClientWorld {
    public static final boolean PRINT_ERRORS = true;
    SortedMap sortedTurtles = new TreeMap(new TurtleKeyComparator());
    Map turtleKeys = new HashMap();
    PatchData[] patches;
    private int screenEdgeX;
    private int screenEdgeY;
    private int labelSize;
    private boolean shapes;
    private boolean exactDraw;

    public Iterator getTurtles() {
        return this.sortedTurtles.values().iterator();
    }

    public PatchData[] getPatches() {
        return this.patches;
    }

    public int getLabelSize() {
        return this.labelSize;
    }

    public int getScreenEdgeX() {
        return this.screenEdgeX;
    }

    public int getScreenEdgeY() {
        return this.screenEdgeY;
    }

    public boolean useShapes() {
        return this.shapes;
    }

    public boolean drawExact() {
        return this.exactDraw;
    }

    void updatePatch(PatchData patch) {
        if (patch.getId() >= this.patches.length) {
            this.handleError("ERROR: received update for non-existent patch (" + patch.stringRep() + ").");
            return;
        }
        PatchData bufPatch = this.patches[patch.getId()];
        if (bufPatch == null) {
            if (patch.isComplete()) {
                this.patches[patch.getId()] = patch;
            } else {
                this.handleError("ERROR: received incremental update for non-existent patch (" + patch.stringRep() + ").");
            }
            return;
        }
        bufPatch.updateFrom(patch);
    }

    void updateTurtle(TurtleData turtle) {
        Integer simpleKey = new Integer(turtle.getWho());
        TurtleKey sortedKey = (TurtleKey)this.turtleKeys.get(simpleKey);
        if (turtle.isDead()) {
            if (sortedKey == null) {
                this.handleError("ERROR: received death message for non-existent turtle (" + turtle.stringRep() + ").");
                return;
            }
            this.sortedTurtles.remove(sortedKey);
            this.turtleKeys.remove(simpleKey);
            return;
        }
        TurtleData bufTurtle = null;
        if (sortedKey != null) {
            bufTurtle = (TurtleData)this.sortedTurtles.get(sortedKey);
        }
        if (bufTurtle == null) {
            if (turtle.isComplete()) {
                sortedKey = new TurtleKey(turtle.getWho(), turtle.getBreedIndex());
                this.sortedTurtles.put(sortedKey, turtle);
                this.turtleKeys.put(simpleKey, sortedKey);
            } else {
                this.handleError("ERROR: received incremental update for non-existent turtle (" + turtle.stringRep() + ").");
            }
            return;
        }
        bufTurtle.updateFrom(turtle);
    }

    public void updateFrom(DataInputStream is) throws IOException {
        int i;
        int numToRead;
        short mask = is.readShort();
        if ((mask & 1) == 1) {
            this.screenEdgeX = is.readInt();
        }
        if ((mask & 2) == 2) {
            this.screenEdgeY = is.readInt();
        }
        if ((mask & 4) == 4) {
            this.shapes = is.readBoolean();
        }
        if ((mask & 8) == 8) {
            this.exactDraw = is.readBoolean();
        }
        if ((mask & 0x10) == 16) {
            this.labelSize = is.readInt();
        }
        if ((mask & 0x200) == 512) {
            numToRead = is.readInt();
            i = 0;
            while (i < numToRead) {
                this.updatePatch(new PatchData(is));
                ++i;
            }
        }
        if ((mask & 0x100) == 256) {
            numToRead = is.readInt();
            i = 0;
            while (i < numToRead) {
                this.updateTurtle(new TurtleData(is));
                ++i;
            }
        }
    }

    private final void handleError(Object o) {
        System.err.println("@ " + new Date() + " : ");
        System.err.println(o.toString());
    }

    public ClientWorld(int numPatches) {
        this.patches = new PatchData[numPatches];
        int i = 0;
        while (i < this.patches.length) {
            this.patches[i] = new PatchData(i, 7, 0.0, "", 0.0);
            ++i;
        }
    }

    private static class TurtleKey {
        int who;
        int breedIndex;

        public boolean equals(Object o) {
            TurtleKey tk = (TurtleKey)o;
            boolean bl = false;
            if (this.who == tk.who && this.breedIndex == tk.breedIndex) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            return this.breedIndex * 1000 + this.who;
        }

        public String toString() {
            return "(" + this.who + ", " + this.breedIndex + ')';
        }

        public TurtleKey(int who, int breedIndex) {
            this.who = who;
            this.breedIndex = breedIndex;
        }
    }

    private static class TurtleKeyComparator
    implements Comparator {
        public int compare(Object k1, Object k2) {
            TurtleKey tk1 = (TurtleKey)k1;
            TurtleKey tk2 = (TurtleKey)k2;
            if (tk1.breedIndex == tk2.breedIndex) {
                return tk1.who - tk2.who;
            }
            return tk1.breedIndex - tk2.breedIndex;
        }

        private TurtleKeyComparator() {
        }
    }
}

