/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.mirroring;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nlogo.hubnet.computer.mirroring.PatchData;
import org.nlogo.hubnet.computer.mirroring.TurtleData;
import org.nlogo.util.Exceptions;

public strictfp class DiffBuffer {
    public static final short EMPTY = 0;
    public static final short SEX = 1;
    public static final short SEY = 2;
    public static final short SHAPES = 4;
    public static final short EXACT_DRAW = 8;
    public static final short LABEL_SIZE = 16;
    public static final short TURTLES = 256;
    public static final short PATCHES = 512;
    public static final short EVERYTHING = 799;
    private short mask = 0;
    private int screenEdgeX;
    private int screenEdgeY;
    private int labelSize;
    private boolean shapes;
    private boolean exactDraw;
    private List patchDiffs = new ArrayList();
    private List turtleDiffs = new ArrayList();

    public boolean isEmpty() {
        boolean bl = false;
        if (this.mask == 0) {
            bl = true;
        }
        return bl;
    }

    void addScreenEdgeX(int screenEdgeX) {
        this.mask = (short)(this.mask | 1);
        this.screenEdgeX = screenEdgeX;
    }

    void addScreenEdgeY(int screenEdgeY) {
        this.mask = (short)(this.mask | 2);
        this.screenEdgeY = screenEdgeY;
    }

    void addShapes(boolean shapes) {
        this.mask = (short)(this.mask | 4);
        this.shapes = shapes;
    }

    void addExactDraw(boolean exactDraw) {
        this.mask = (short)(this.mask | 8);
        this.exactDraw = exactDraw;
    }

    void addLabelSize(int labelSize) {
        this.mask = (short)(this.mask | 0x10);
        this.labelSize = labelSize;
    }

    void addTurtle(TurtleData diffs) {
        this.mask = (short)(this.mask | 0x100);
        this.turtleDiffs.add(diffs);
    }

    void addPatch(PatchData diffs) {
        this.mask = (short)(this.mask | 0x200);
        this.patchDiffs.add(diffs);
    }

    public void serialize(DataOutputStream os) throws IOException {
        Iterator it;
        os.writeShort(this.mask);
        if ((this.mask & 1) == 1) {
            os.writeInt(this.screenEdgeX);
        }
        if ((this.mask & 2) == 2) {
            os.writeInt(this.screenEdgeY);
        }
        if ((this.mask & 4) == 4) {
            os.writeBoolean(this.shapes);
        }
        if ((this.mask & 8) == 8) {
            os.writeBoolean(this.exactDraw);
        }
        if ((this.mask & 0x10) == 16) {
            os.writeInt(this.labelSize);
        }
        if ((this.mask & 0x200) == 512) {
            os.writeInt(this.patchDiffs.size());
            it = this.patchDiffs.iterator();
            while (it.hasNext()) {
                ((PatchData)it.next()).serialize(os);
            }
        }
        if ((this.mask & 0x100) == 256) {
            os.writeInt(this.turtleDiffs.size());
            it = this.turtleDiffs.iterator();
            while (it.hasNext()) {
                ((TurtleData)it.next()).serialize(os);
            }
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.serialize(new DataOutputStream(bos));
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
        return bos.toByteArray();
    }
}

