/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.mirroring;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public strictfp class PatchData {
    public static final short DEAD = 0;
    public static final short COLOR = 1;
    public static final short LABEL = 2;
    public static final short LABEL_COLOR = 4;
    public static final short COMPLETE = 7;
    private int id;
    private double color;
    private String label;
    private double labelColor;
    private short mask;

    public int getId() {
        return this.id;
    }

    public double getColor() {
        return this.color;
    }

    public String getLabel() {
        return this.label;
    }

    public double getLabelColor() {
        return this.labelColor;
    }

    String stringRep() {
        return "Patch " + this.id + " (" + this.color + ", " + this.label + ", " + this.labelColor + ')';
    }

    boolean isComplete() {
        boolean bl = false;
        if ((this.mask & 7) == 7) {
            bl = true;
        }
        return bl;
    }

    PatchData updateFrom(PatchData otherPatch) {
        PatchData diffs = new PatchData(this.id);
        if ((otherPatch.mask & 1) == 1 && this.color != otherPatch.color) {
            this.color = otherPatch.color;
            diffs.mask = (short)(diffs.mask | 1);
            diffs.color = this.color;
        }
        if ((otherPatch.mask & 2) == 2 && !this.label.equals(otherPatch.label)) {
            this.label = otherPatch.label;
            diffs.mask = (short)(diffs.mask | 2);
            diffs.label = this.label;
        }
        if ((otherPatch.mask & 4) == 4 && this.labelColor != otherPatch.labelColor) {
            this.labelColor = otherPatch.labelColor;
            diffs.mask = (short)(diffs.mask | 4);
            diffs.labelColor = this.labelColor;
        }
        if (diffs.mask != 0) {
            return diffs;
        }
        return null;
    }

    void serialize(DataOutputStream os) throws IOException {
        os.writeInt(this.id);
        os.writeShort(this.mask);
        if ((this.mask & 1) == 1) {
            os.writeDouble(this.color);
        }
        if ((this.mask & 2) == 2) {
            os.writeUTF(this.label);
        }
        if ((this.mask & 4) == 4) {
            os.writeDouble(this.labelColor);
        }
    }

    PatchData(int id, short mask, double color, String label, double labelColor) {
        this.id = id;
        this.mask = mask;
        this.color = color;
        this.label = label;
        this.labelColor = labelColor;
    }

    PatchData(DataInputStream is) throws IOException {
        this.id = is.readInt();
        this.mask = is.readShort();
        if ((this.mask & 1) == 1) {
            this.color = is.readDouble();
        }
        if ((this.mask & 2) == 2) {
            this.label = is.readUTF();
        }
        if ((this.mask & 4) == 4) {
            this.labelColor = is.readDouble();
        }
    }

    private PatchData(int id) {
        this.id = id;
        this.mask = 0;
    }
}

