/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.mirroring;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.awt.Utils;
import org.nlogo.hubnet.HubNetManager;
import org.nlogo.hubnet.computer.mirroring.DiffBuffer;
import org.nlogo.hubnet.computer.mirroring.PatchData;
import org.nlogo.hubnet.computer.mirroring.TurtleData;
import org.nlogo.util.Exceptions;
import org.nlogo.window.GraphicsWidget;

public strictfp class ServerWorld {
    private HubNetManager manager;
    private Map turtles;
    private Map patches;
    private int screenEdgeX;
    private int screenEdgeY;
    private int labelSize;
    private boolean shapes;
    private boolean exactDraw;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized DiffBuffer updateWorld(World world) {
        Utils.mustBeEventDispatchThread();
        DiffBuffer buf = new DiffBuffer();
        World world2 = world;
        synchronized (world2) {
            this.updateGeneral(world, buf);
            this.updatePatches(world, buf);
            this.updateTurtles(world, buf);
            return buf;
        }
    }

    private final void updateGeneral(World world, DiffBuffer buf) {
        GraphicsWidget gw = this.manager.guiWorkspace().graphicsWidget;
        if (this.screenEdgeX != world.screenEdgeX()) {
            this.screenEdgeX = world.screenEdgeX();
            buf.addScreenEdgeX(this.screenEdgeX);
        }
        if (this.screenEdgeY != world.screenEdgeY()) {
            this.screenEdgeY = world.screenEdgeY();
            buf.addScreenEdgeY(this.screenEdgeY);
        }
        if (this.labelSize != gw.fontSize()) {
            this.labelSize = gw.fontSize();
            buf.addLabelSize(this.labelSize);
        }
        if (this.shapes != gw.refreshShaped()) {
            this.shapes = gw.refreshShaped();
            buf.addShapes(this.shapes);
        }
        if (this.exactDraw != gw.exactDraw()) {
            this.exactDraw = gw.exactDraw();
            buf.addExactDraw(this.exactDraw);
        }
    }

    private final void updatePatches(World world, DiffBuffer buf) {
        Iterator it = world.patches().iterator();
        while (it.hasNext()) {
            PatchData diffs = this.updatePatch((Patch)it.next());
            if (diffs == null) continue;
            buf.addPatch(diffs);
        }
    }

    private final void updateTurtles(World world, DiffBuffer buf) {
        HashMap<Integer, TurtleData> newTurtles = new HashMap<Integer, TurtleData>();
        Iterator it = world.turtles().iterator();
        while (it.hasNext()) {
            Turtle turtle = (Turtle)it.next();
            TurtleData diffs = this.updateTurtle(turtle);
            if (diffs != null) {
                buf.addTurtle(diffs);
            }
            TurtleData tmp = (TurtleData)this.turtles.remove(org.nlogo.util.Utils.reuseInteger(turtle.id));
            newTurtles.put(org.nlogo.util.Utils.reuseInteger(turtle.id), tmp);
        }
        it = this.turtles.values().iterator();
        while (it.hasNext()) {
            buf.addTurtle(new TurtleData(((TurtleData)it.next()).getWho()));
        }
        this.turtles = newTurtles;
    }

    private final PatchData updatePatch(Patch patch) {
        PatchData pd = new PatchData(patch.id, 7, patch.pcolor(), patch.labelString(), patch.labelColor());
        PatchData bufPatch = (PatchData)this.patches.get(org.nlogo.util.Utils.reuseInteger(patch.id));
        if (bufPatch == null) {
            this.patches.put(org.nlogo.util.Utils.reuseInteger(patch.id), pd);
            return pd;
        }
        this.patches.put(org.nlogo.util.Utils.reuseInteger(patch.id), pd);
        return bufPatch.updateFrom(pd);
    }

    private final TurtleData updateTurtle(Turtle turtle) {
        TurtleData td = new TurtleData(turtle.id, 1023, turtle.xcor(), turtle.ycor(), this.manager.shapeIndex(turtle.shape()), turtle.color(), turtle.heading(), turtle.size(), turtle.hidden(), turtle.labelString(), turtle.labelColor(), turtle.getBreedIndex());
        TurtleData bufTurtle = (TurtleData)this.turtles.get(org.nlogo.util.Utils.reuseInteger(turtle.id));
        if (bufTurtle == null) {
            this.turtles.put(org.nlogo.util.Utils.reuseInteger(turtle.id), td);
            return td;
        }
        return bufTurtle.updateFrom(td);
    }

    private final void serialize(DataOutputStream os) throws IOException {
        os.writeShort(799);
        os.writeInt(this.screenEdgeX);
        os.writeInt(this.screenEdgeY);
        os.writeBoolean(this.shapes);
        os.writeBoolean(this.exactDraw);
        os.writeInt(this.labelSize);
        os.writeInt(this.patches.values().size());
        Iterator it = this.patches.values().iterator();
        while (it.hasNext()) {
            ((PatchData)it.next()).serialize(os);
        }
        os.writeInt(this.turtles.values().size());
        it = this.turtles.values().iterator();
        while (it.hasNext()) {
            ((TurtleData)it.next()).serialize(os);
        }
    }

    public synchronized byte[] toByteArray() {
        Utils.mustBeEventDispatchThread();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.serialize(new DataOutputStream(bos));
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
        return bos.toByteArray();
    }

    public ServerWorld(HubNetManager manager) {
        this.manager = manager;
        this.turtles = new HashMap();
        this.patches = new HashMap();
    }
}

