/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.mirroring;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public strictfp class TurtleData {
    public static final short DEAD = 0;
    public static final short XCOR = 1;
    public static final short YCOR = 2;
    public static final short SHAPE = 4;
    public static final short COLOR = 8;
    public static final short HEADING = 16;
    public static final short SIZE = 32;
    public static final short HIDDEN = 64;
    public static final short LABEL = 128;
    public static final short LABEL_COLOR = 256;
    public static final short BREED_INDEX = 512;
    public static final short COMPLETE = 1023;
    private int who;
    private short mask;
    private double xcor;
    private double ycor;
    private int shape;
    private double color;
    private double heading;
    private double size;
    private boolean hidden;
    private String label;
    private double labelColor;
    private int breedIndex;

    int getWho() {
        return this.who;
    }

    public double getXcor() {
        return this.xcor;
    }

    public double getYcor() {
        return this.ycor;
    }

    public double getColor() {
        return this.color;
    }

    public double getSize() {
        return this.size;
    }

    public int getShape() {
        return this.shape;
    }

    public double getHeading() {
        return this.heading;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getLabel() {
        return this.label;
    }

    public double getLabelColor() {
        return this.labelColor;
    }

    public int getBreedIndex() {
        return this.breedIndex;
    }

    public String stringRep() {
        if (this.mask == 1023) {
            return "Turtle " + this.who + " (" + this.xcor + ", " + this.ycor + ", " + this.shape + ", " + this.color + ", " + this.heading + ", " + this.size + ", " + this.hidden + ", " + this.label + ", " + this.labelColor + ", " + this.breedIndex + ')';
        }
        if (this.mask == 0) {
            return "Turtle " + this.who + " (dead)";
        }
        return "Turtle " + this.who + " update (mask " + Integer.toBinaryString(this.mask) + ')';
    }

    boolean isComplete() {
        boolean bl = false;
        if ((this.mask & 0x3FF) == 1023) {
            bl = true;
        }
        return bl;
    }

    boolean isDead() {
        boolean bl = false;
        if (this.mask == 0) {
            bl = true;
        }
        return bl;
    }

    TurtleData updateFrom(TurtleData other) {
        if (other.isDead()) {
            System.err.println("@ " + new Date() + " : ");
            System.err.println("ERROR: attempting incremental update of a dead turtle (" + this.stringRep() + ").");
            return null;
        }
        TurtleData diffs = new TurtleData(this.who);
        if ((other.mask & 1) == 1 && this.xcor != other.xcor) {
            this.xcor = other.xcor;
            diffs.mask = (short)(diffs.mask | 1);
            diffs.xcor = this.xcor;
        }
        if ((other.mask & 2) == 2 && this.ycor != other.ycor) {
            this.ycor = other.ycor;
            diffs.mask = (short)(diffs.mask | 2);
            diffs.ycor = this.ycor;
        }
        if ((other.mask & 4) == 4 && this.shape != other.shape) {
            this.shape = other.shape;
            diffs.mask = (short)(diffs.mask | 4);
            diffs.shape = this.shape;
        }
        if ((other.mask & 8) == 8 && this.color != other.color) {
            this.color = other.color;
            diffs.mask = (short)(diffs.mask | 8);
            diffs.color = this.color;
        }
        if ((other.mask & 0x10) == 16 && this.heading != other.heading) {
            this.heading = other.heading;
            diffs.mask = (short)(diffs.mask | 0x10);
            diffs.heading = this.heading;
        }
        if ((other.mask & 0x20) == 32 && this.size != other.size) {
            this.size = other.size;
            diffs.mask = (short)(diffs.mask | 0x20);
            diffs.size = this.size;
        }
        if ((other.mask & 0x40) == 64 && this.hidden != other.hidden) {
            this.hidden = other.hidden;
            diffs.mask = (short)(diffs.mask | 0x40);
            diffs.hidden = this.hidden;
        }
        if ((other.mask & 0x80) == 128 && !this.label.equals(other.label)) {
            this.label = other.label;
            diffs.mask = (short)(diffs.mask | 0x80);
            diffs.label = this.label;
        }
        if ((other.mask & 0x100) == 256 && this.labelColor != other.labelColor) {
            this.labelColor = other.labelColor;
            diffs.mask = (short)(diffs.mask | 0x100);
            diffs.labelColor = this.labelColor;
        }
        this.breedIndex = other.breedIndex;
        diffs.mask = (short)(diffs.mask | 0x200);
        diffs.breedIndex = this.breedIndex;
        if (diffs.mask != 0) {
            return diffs;
        }
        return null;
    }

    void serialize(DataOutputStream os) throws IOException {
        os.writeInt(this.who);
        os.writeShort(this.mask);
        if ((this.mask & 1) == 1) {
            os.writeDouble(this.xcor);
        }
        if ((this.mask & 2) == 2) {
            os.writeDouble(this.ycor);
        }
        if ((this.mask & 4) == 4) {
            os.writeInt(this.shape);
        }
        if ((this.mask & 8) == 8) {
            os.writeDouble(this.color);
        }
        if ((this.mask & 0x10) == 16) {
            os.writeDouble(this.heading);
        }
        if ((this.mask & 0x20) == 32) {
            os.writeDouble(this.size);
        }
        if ((this.mask & 0x40) == 64) {
            os.writeBoolean(this.hidden);
        }
        if ((this.mask & 0x80) == 128) {
            os.writeUTF(this.label);
        }
        if ((this.mask & 0x100) == 256) {
            os.writeDouble(this.labelColor);
        }
        if ((this.mask & 0x200) == 512) {
            os.writeInt(this.breedIndex);
        }
    }

    TurtleData(int who) {
        this.who = who;
        this.mask = 0;
    }

    TurtleData(int who, short mask, double xcor, double ycor, int shape, double color, double heading, double size, boolean hidden, String label, double labelColor) {
        this(who, mask, xcor, ycor, shape, color, heading, size, hidden, label, labelColor, 0);
    }

    TurtleData(int who, short mask, double xcor, double ycor, int shape, double color, double heading, double size, boolean hidden, String label, double labelColor, int breedIndex) {
        this.who = who;
        this.mask = mask;
        this.xcor = xcor;
        this.ycor = ycor;
        this.shape = shape;
        this.color = color;
        this.heading = heading;
        this.size = size;
        this.hidden = hidden;
        this.label = label;
        this.labelColor = labelColor;
        this.breedIndex = breedIndex;
    }

    TurtleData(DataInputStream is) throws IOException {
        this.who = is.readInt();
        this.mask = is.readShort();
        if ((this.mask & 1) == 1) {
            this.xcor = is.readDouble();
        }
        if ((this.mask & 2) == 2) {
            this.ycor = is.readDouble();
        }
        if ((this.mask & 4) == 4) {
            this.shape = is.readInt();
        }
        if ((this.mask & 8) == 8) {
            this.color = is.readDouble();
        }
        if ((this.mask & 0x10) == 16) {
            this.heading = is.readDouble();
        }
        if ((this.mask & 0x20) == 32) {
            this.size = is.readDouble();
        }
        if ((this.mask & 0x40) == 64) {
            this.hidden = is.readBoolean();
        }
        if ((this.mask & 0x80) == 128) {
            this.label = is.readUTF();
        }
        if ((this.mask & 0x100) == 256) {
            this.labelColor = is.readDouble();
        }
        if ((this.mask & 0x200) == 512) {
            this.breedIndex = is.readInt();
        }
    }
}

