/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nlogo.shapes.VectorShape;
import org.nlogo.util.LocalFile;
import org.nlogo.workspace.ModelReader;

public strictfp class ClientInterfaceSpecification
implements Serializable {
    private static final String SHAPES = "shapes";
    private static final String WIDGETS = "widgets";
    private static final String[] TYPES = new String[]{"unknown", "widgets", "unknown1", "shapes"};
    private String[] widgetDescriptions;
    private List shapeDescriptions;
    private transient List clientWidgetTags;

    public String[] getWidgets() {
        return this.widgetDescriptions;
    }

    public List getShapes() {
        return this.shapeDescriptions;
    }

    public boolean containsWidget(String tag) {
        return this.clientWidgetTags.contains(tag);
    }

    public boolean containsGraphicsWidget() {
        List widgets = ModelReader.parseWidgets(this.getWidgets());
        boolean containsGraphicsWindow = false;
        if (widgets != null) {
            int i = 0;
            while (i < widgets.size()) {
                String widgetTypeString = (String)((List)widgets.get(i)).get(0);
                if (widgetTypeString.equals("GRAPHICS-WINDOW")) {
                    containsGraphicsWindow = true;
                    break;
                }
                ++i;
            }
        }
        return containsGraphicsWindow;
    }

    private final void cacheWidgetTags() {
        String[] widgetsArr = this.widgetDescriptions;
        List widgets = ModelReader.parseWidgets(widgetsArr);
        this.clientWidgetTags = new ArrayList(widgets.size() - 1);
        int i = 0;
        while (i < widgets.size()) {
            List widget = (List)widgets.get(i);
            if (!widget.get(0).equals("GRAPHICS-WINDOW") && !widget.get(0).equals("CC-WINDOW")) {
                this.clientWidgetTags.add(widget.get(5));
            }
            ++i;
        }
    }

    public String toString() {
        return "ClientInterfaceSpecification: " + super.toString() + "\nSHAPES = " + this.getShapes() + "\nWIDGETS = " + this.getWidgets() + '\n';
    }

    public ClientInterfaceSpecification(String filePath) throws IOException {
        String fileContents = LocalFile.readFile(new File(filePath));
        Map parsedFile = ModelReader.parseString(fileContents, TYPES, false);
        this.widgetDescriptions = (String[])parsedFile.get(WIDGETS);
        String[] shapesV = (String[])parsedFile.get(SHAPES);
        if (shapesV != null) {
            List shapes;
            if (shapesV.length == 0) {
                try {
                    shapesV = ModelReader.getDefaultShapesV();
                }
                catch (IOException ex) {
                    throw new RuntimeException("couldn't load default shapes (" + ex + ')');
                }
            }
            this.shapeDescriptions = shapes = VectorShape.parseShapes(shapesV);
        }
        this.cacheWidgetTags();
    }

    public ClientInterfaceSpecification() {
        this.cacheWidgetTags();
    }
}

