/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.nlogo.hubnet.computer.server.ControlCenter;

public strictfp class ClientsPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private ControlCenter controlCenter;
    private JList list;
    private DefaultListModel listData;
    private JButton kickButton;
    private JButton newClientButton;

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        boolean bl = false;
        if (this.list.getMinSelectionIndex() > -1) {
            bl = true;
        }
        this.kickButton.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.kickButton)) {
            Object[] clientIds = this.list.getSelectedValues();
            int j = 0;
            while (j < clientIds.length) {
                this.controlCenter.kickClient((String)clientIds[j]);
                ++j;
            }
        } else if (evt.getSource().equals(this.newClientButton)) {
            this.controlCenter.launchNewClient();
        }
    }

    public void addClientEntry(String clientId) {
        this.listData.addElement(clientId);
    }

    public void removeClientEntry(String clientId) {
        this.listData.removeElement(clientId);
    }

    public void setClientList(Iterator clientNames) {
        this.listData.clear();
        while (clientNames.hasNext()) {
            this.listData.addElement(clientNames.next());
        }
    }

    public ClientsPanel(ControlCenter controlCenter, Iterator initialClientEntries) {
        this.controlCenter = controlCenter;
        this.listData = new DefaultListModel();
        this.list = new JList(this.listData);
        this.list.setSelectionMode(2);
        this.kickButton = new JButton("Kick");
        this.newClientButton = new JButton("Local");
        this.list.addListSelectionListener(this);
        this.kickButton.addActionListener(this);
        this.kickButton.setEnabled(false);
        this.newClientButton.addActionListener(this);
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout(0, 4));
        JLabel title = new JLabel("Clients:");
        title.setAlignmentY(0.0f);
        this.add((Component)title, "North");
        this.list.setPrototypeCellValue("CLIENT NAME");
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.add((Component)scrollPane, "Center");
        JPanel fp = new JPanel(new FlowLayout(2, 0, 0));
        fp.add(this.kickButton);
        fp.add(this.newClientButton);
        this.add((Component)fp, "South");
        this.kickButton.setAlignmentY(1.0f);
        this.newClientButton.setAlignmentY(1.0f);
        while (initialClientEntries.hasNext()) {
            this.addClientEntry((String)initialClientEntries.next());
        }
    }
}

