/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.server;

import java.awt.Frame;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nlogo.agent.LogoList;
import org.nlogo.awt.Utils;
import org.nlogo.hubnet.HubNetException;
import org.nlogo.hubnet.HubNetManager;
import org.nlogo.hubnet.MessageBox;
import org.nlogo.hubnet.NodeConnection;
import org.nlogo.hubnet.computer.mirroring.DiffBuffer;
import org.nlogo.hubnet.computer.mirroring.ServerWorld;
import org.nlogo.hubnet.computer.protocol.GraphicsUpdate;
import org.nlogo.hubnet.computer.protocol.Handshake;
import org.nlogo.hubnet.computer.protocol.Message;
import org.nlogo.hubnet.computer.protocol.WidgetControl;
import org.nlogo.hubnet.computer.server.ClientInterfaceSpecification;
import org.nlogo.hubnet.computer.server.CompUtils;
import org.nlogo.hubnet.computer.server.ConnectionListener;
import org.nlogo.hubnet.computer.server.ControlCenter;
import org.nlogo.hubnet.computer.server.DiscoveryAnnouncer;
import org.nlogo.hubnet.computer.server.StartupDialog;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class CompConnection
extends NodeConnection {
    public static List currentActivities = new ArrayList();
    private static final String VALID_SEND_TYPES_MESSAGE = "You can only send strings, booleans (true or false), numbers, and lists of these types.";
    private int port;
    private String clientInterface;
    protected final Map clients;
    protected ControlCenter controlCenter;
    boolean controlCenterOn;
    private boolean nodesHaveGraphics;
    private ServerWorld worldBuffer;
    private boolean serverDiscoveryEnabled;
    private ServerSocket socket;
    private boolean serverOn;
    private ClientInterfaceSpecification clientInterfaceSpec;

    public int getPortNumber() {
        return this.port;
    }

    public boolean isDiscoveryEnabled() {
        return this.serverDiscoveryEnabled;
    }

    public String nodeType() {
        return "COMPUTER";
    }

    public boolean doStartup() {
        Utils.mustBeEventDispatchThread();
        currentActivities.add("clientApplet.html");
        String serverName = System.getProperty("org.nlogo.hubnet.server.name");
        if (serverName != null) {
            this.getHubNetManager().setUniqueId(serverName);
        } else if (this.guiWorkspace() != null) {
            StartupDialog sd = new StartupDialog(this.guiWorkspace().getFrame());
            sd.setVisible(true);
            this.serverDiscoveryEnabled = sd.isDiscoverySelected();
            this.getHubNetManager().setUniqueId(sd.getName());
        }
        this.workspace().computerHubNetRunning(true);
        return true;
    }

    public void run() {
        try {
            this.serverOn = true;
            this.port = 9173;
            while (this.socket == null && this.port <= 9183) {
                try {
                    this.socket = new ServerSocket(this.port);
                }
                catch (BindException bex) {
                    Exceptions.warn(bex);
                    ++this.port;
                }
            }
            if (this.socket == null) {
                throw new BindException();
            }
            this.socket.setSoTimeout(250);
            DiscoveryAnnouncer announcer = null;
            if (this.serverDiscoveryEnabled) {
                announcer = new DiscoveryAnnouncer(this.getHubNetManager().getUniqueId(), this.workspace().modelNameForDisplay(), this.port);
                announcer.start();
            }
            Utils.invokeLater(new Runnable(){

                public final void run() {
                    ((CompConnection)CompConnection.this).guiWorkspace().hubNetControlCenterAction.setEnabled(true);
                    CompConnection.this.showControlCenter();
                }
            });
            while (this.serverOn) {
                try {
                    this.waitForConnection();
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    Exceptions.handle(e);
                }
                catch (ClassNotFoundException e) {
                    Exceptions.handle(e);
                }
                catch (RuntimeException e) {
                    Exceptions.handle(e);
                }
            }
            if (announcer != null) {
                announcer.setShouldRun(false);
            }
            this.socket.close();
            this.socket = null;
        }
        catch (BindException bex) {
            Utils.invokeLater(new Runnable(){

                public final void run() {
                    String message = "Could not start the Computer HubNet server.  No ports are available.";
                    String title = "Error Starting Computer HubNet";
                    OptionDialog.show(CompConnection.this.guiWorkspace().getFrame(), title, message, new String[]{"OK"});
                }
            });
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
    }

    Frame getFrame() {
        return this.guiWorkspace().getFrame();
    }

    private final void waitForConnection() throws IOException, ClassNotFoundException {
        Socket newSocket = this.socket.accept();
        newSocket.setSoTimeout(0);
        newSocket.setTcpNoDelay(true);
        new ConnectionListener(newSocket, this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doShutdown() {
        Utils.mustBeEventDispatchThread();
        if (this.nodeThread.isAlive()) {
            this.serverOn = false;
            while (this.socket != null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    Exceptions.ignore(ie);
                }
            }
            if (this.controlCenterOn) {
                Utils.invokeLater(new Runnable(){

                    public final void run() {
                        CompConnection.this.controlCenter.dispose();
                    }
                });
            }
            Map map = this.clients;
            synchronized (map) {
                Iterator it = this.clients.values().iterator();
                while (true) {
                    if (!it.hasNext()) {
                        this.clients.clear();
                        break;
                    }
                    ConnectionListener c = (ConnectionListener)it.next();
                    this.disconnectClient(c, true);
                }
            }
        }
        if (this.guiWorkspace() != null) {
            this.guiWorkspace().hubNetControlCenterAction.setEnabled(false);
        }
        this.workspace().computerHubNetRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean finalizeConnection(ConnectionListener c, String tempClientId) {
        Utils.mustBeEventDispatchThread();
        Map map = this.clients;
        synchronized (map) {
            if (this.clients.containsKey(tempClientId)) {
                return false;
            }
            this.clients.put(tempClientId, c);
            if (this.controlCenterOn) {
                this.controlCenter.addClient(tempClientId, c.getRemoteSocketAddress());
            }
            return true;
        }
    }

    protected void setClientInterface(LogoList interfaceInfo) throws HubNetException {
        if (interfaceInfo.size() != 1 || !(interfaceInfo.get(0) instanceof String)) {
            throw new HubNetException("Since the first input to hubnet-set-client-interface is " + this.nodeType() + ", the second input must be a list of a single string.");
        }
        String fileName = this.workspace().attachModelDir((String)interfaceInfo.get(0));
        if (this.clientInterface != null && !fileName.equals(this.clientInterface)) {
            throw new HubNetException("You can only have one computer interface per model.  Please make sure that you use hubnet-set-client-interface " + this.nodeType() + " only once in the model.");
        }
        try {
            this.getClientInterface(fileName);
        }
        catch (FileNotFoundException ex) {
            throw new HubNetException("\"" + fileName + "\" could not be found.");
        }
        catch (IOException ex) {
            throw new HubNetException("\"" + fileName + "\" could not be read.");
        }
        this.clientInterface = fileName;
    }

    private final void getClientInterface(String filePath) throws IOException, HubNetException {
        try {
            this.clientInterfaceSpec = new ClientInterfaceSpecification(filePath);
        }
        catch (IOException ex) {
            if (this.socket != null) {
                this.socket.close();
            }
            throw ex;
        }
        this.getHubNetManager().makeShapesHash(this.clientInterfaceSpec.getShapes());
        this.nodesHaveGraphics = this.clientInterfaceSpec.containsGraphicsWidget();
    }

    void putClientData(MessageBox messageBox) {
        this.enqueueMessage(messageBox);
        if (HubNetManager.debug) {
            System.out.println(this.getMessageDebugOutput(messageBox));
        }
    }

    public Handshake createHandshakeMessage() {
        return new Handshake(this.workspace().modelNameForDisplay(), this.clientInterfaceSpec);
    }

    protected boolean validTag(String tag) {
        return this.clientInterfaceSpec.containsWidget(tag);
    }

    public void broadcast(String tag, Object message) throws HubNetException {
        if (!this.validTag(tag)) {
            throw new HubNetException(tag + " is not a valid tag on the client.");
        }
        if (!(message instanceof Serializable)) {
            throw new HubNetException(VALID_SEND_TYPES_MESSAGE);
        }
        this.broadcastMessage(new WidgetControl((Serializable)message, tag));
        if (HubNetManager.debug) {
            System.out.println(this.sendMessageDebugOutput(tag, message));
        }
    }

    public boolean send(String node, String tag, Object message) throws HubNetException {
        if (!this.validTag(tag)) {
            throw new HubNetException(tag + " is not a valid tag on the client.");
        }
        if (!(message instanceof Serializable)) {
            throw new HubNetException(VALID_SEND_TYPES_MESSAGE);
        }
        if (HubNetManager.debug) {
            System.out.println(this.sendMessageDebugOutput(tag, message, node));
        }
        return this.sendUserMessage(node, new WidgetControl((Serializable)message, tag));
    }

    void broadcastMessage(Message message) {
        Iterator it = this.clients.values().iterator();
        while (it.hasNext()) {
            ConnectionListener c = (ConnectionListener)it.next();
            c.sendData(message);
        }
    }

    private final boolean sendUserMessage(String userid, Message message) {
        ConnectionListener c = (ConnectionListener)this.clients.get(userid);
        if (c != null) {
            c.sendData(message);
            return true;
        }
        return false;
    }

    protected final boolean canNarrowCast() {
        return true;
    }

    public void showControlCenter() {
        if (this.guiWorkspace() == null) {
            return;
        }
        if (!this.controlCenterOn) {
            this.controlCenter = new ControlCenter(this, this.guiWorkspace().getFrame(), this.getHubNetManager().getUniqueId(), this.getHubNetManager().getModelName(), this.clients.keySet().iterator());
            this.controlCenterOn = true;
        } else {
            Utils.invokeLater(new Runnable(){

                public final void run() {
                    CompConnection.this.controlCenter.toFront();
                    CompConnection.this.controlCenter.requestFocus();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeClient(String userid, boolean notifyClient) {
        Utils.mustBeEventDispatchThread();
        if (userid == null) return;
        ConnectionListener c = null;
        Map map = this.clients;
        synchronized (map) {
            c = (ConnectionListener)this.clients.get(userid);
            if (c != null) {
                this.clients.remove(userid);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
            this.disconnectClient(c, notifyClient);
            return;
        }
    }

    private final void disconnectClient(ConnectionListener c, boolean notifyClient) {
        Utils.mustBeEventDispatchThread();
        if (c != null) {
            if (this.controlCenterOn) {
                this.controlCenter.clientDisconnect(c.getClientId());
            }
            c.disconnect(notifyClient);
        }
    }

    public void fullUpdateDisplay() {
        Utils.mustBeEventDispatchThread();
        this.worldBuffer = new ServerWorld(this.getHubNetManager());
        this.performUpdateDisplay();
        this.worldBuffer = new ServerWorld(this.getHubNetManager());
        if (HubNetManager.debug) {
            System.out.println(this.nodeType() + " HubNet at " + new Date() + " sent {Source=ALL LOGGED IN USERS, Message=Graphics Window}");
        }
    }

    public void updateDisplay() {
        Utils.mustBeEventDispatchThread();
        this.performUpdateDisplay();
        if (HubNetManager.debug) {
            System.out.println(this.nodeType() + " HubNet at " + new Date() + " sent {Source=ALL LOGGED IN USERS, Message=Automatic Graphics Window Update}");
        }
    }

    private final void performUpdateDisplay() {
        Utils.mustBeEventDispatchThread();
        DiffBuffer buf = this.worldBuffer.updateWorld(this.workspace().world);
        if (buf.isEmpty()) {
            return;
        }
        byte[] bytes = buf.toByteArray();
        this.broadcastMessage(new GraphicsUpdate(bytes));
    }

    public boolean fullUpdateDisplay(String node) {
        Utils.mustBeEventDispatchThread();
        DiffBuffer buf = new ServerWorld(this.getHubNetManager()).updateWorld(this.workspace().world);
        if (buf.isEmpty()) {
            return true;
        }
        byte[] bytes = buf.toByteArray();
        this.worldBuffer = new ServerWorld(this.getHubNetManager());
        if (HubNetManager.debug) {
            System.out.println(this.nodeType() + " HubNet at " + new Date() + " sent {Source=" + node + ", Message=Graphics Window}");
        }
        return this.sendUserMessage(node, new GraphicsUpdate(bytes));
    }

    GraphicsUpdate currentGraphicsWindowUpdate() {
        Utils.mustBeEventDispatchThread();
        return new GraphicsUpdate(this.worldBuffer.toByteArray());
    }

    public boolean nodesHaveGraphics() {
        boolean bl = false;
        if (this.nodesHaveGraphics && CompUtils.graphicsWindowMirroring) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List clientSendQueueSizes() {
        ArrayList<Integer> clientQueueSizes = new ArrayList<Integer>();
        Map map = this.clients;
        synchronized (map) {
            Iterator it = this.clients.values().iterator();
            while (it.hasNext()) {
                ConnectionListener c = (ConnectionListener)it.next();
                clientQueueSizes.add(org.nlogo.util.Utils.reuseInteger(c.getSendQueueSize()));
            }
            return clientQueueSizes;
        }
    }

    private final /* synthetic */ void this() {
        this.port = -1;
        this.clients = new HashMap();
        this.nodesHaveGraphics = false;
        this.serverDiscoveryEnabled = false;
    }

    public CompConnection(HubNetManager manager) throws HubNetException {
        super(manager);
        this.this();
        this.worldBuffer = new ServerWorld(manager);
        this.nodeThread.setName("org.nlogo.hubnet.computer.CompConnection");
    }
}

