/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.server;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Date;
import org.nlogo.awt.Utils;
import org.nlogo.hubnet.EnterMessageBox;
import org.nlogo.hubnet.ExitMessageBox;
import org.nlogo.hubnet.HubNetManager;
import org.nlogo.hubnet.MessageBox;
import org.nlogo.hubnet.computer.protocol.ActivityCommand;
import org.nlogo.hubnet.computer.protocol.DisableGraphics;
import org.nlogo.hubnet.computer.protocol.EnterMessage;
import org.nlogo.hubnet.computer.protocol.ExitMessage;
import org.nlogo.hubnet.computer.protocol.Handshake;
import org.nlogo.hubnet.computer.protocol.LoginFailure;
import org.nlogo.hubnet.computer.protocol.Message;
import org.nlogo.hubnet.computer.server.CompConnection;
import org.nlogo.hubnet.computer.server.CompUtils;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.util.SocketListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class ConnectionListener
extends SocketListener {
    private final CompConnection server;
    private boolean validClientVersion;
    private boolean disconnecting;

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public void receiveData(Object object) {
        if (object instanceof Message) {
            final Message message = (Message)object;
            Utils.invokeLater(new Runnable(){

                public final void run() {
                    ConnectionListener.this.handleMessage(message);
                }
            });
        } else if (object instanceof String && this.clientId == null) {
            if (object.equals("NetLogo 2.1.0")) {
                this.validClientVersion = true;
            }
            this.sendData("NetLogo 2.1.0");
        } else {
            throw new RuntimeException("Message type not known: " + object);
        }
    }

    private final void handleMessage(Message message) {
        Utils.mustBeEventDispatchThread();
        if (message instanceof ExitMessage) {
            this.server.removeClient(this.clientId, false);
        } else if (message instanceof Handshake) {
            if (!this.validClientVersion) {
                this.sendData(new LoginFailure("The version of the HubNet Client you are using does not match the version of the server. Please use the HubNet Client that comes with NetLogo 2.1.0"));
                return;
            }
            String desiredClientId = (String)message.getContent();
            try {
                if (this.server.finalizeConnection(this, desiredClientId)) {
                    this.clientId = desiredClientId;
                    this.sendData(this.server.createHandshakeMessage());
                    if (CompUtils.graphicsWindowMirroring) {
                        this.sendData(this.server.currentGraphicsWindowUpdate());
                    } else {
                        this.sendData(new DisableGraphics());
                    }
                } else {
                    this.sendData(new LoginFailure("\"" + desiredClientId + "\" is already taken by another user.  Please choose another name."));
                    if (HubNetManager.debug) {
                        System.out.println("At " + new Date() + ", another user tried to login as \"" + desiredClientId + "\" which is already used.");
                    }
                }
            }
            catch (RuntimeException ex) {
                Exceptions.handle(ex);
            }
        } else if (message instanceof ActivityCommand) {
            ActivityCommand tmp = (ActivityCommand)message;
            this.server.putClientData(new MessageBox(tmp.getTag(), this.clientId, tmp.getContent()));
        } else if (message instanceof EnterMessage) {
            this.server.putClientData(new EnterMessageBox(this.clientId));
        } else {
            throw new RuntimeException("Message type not known: " + message);
        }
    }

    public void disconnect() {
        if (!this.disconnecting) {
            this.disconnecting = true;
            Utils.invokeLater(new Runnable(){

                public final void run() {
                    ConnectionListener.this.server.removeClient(ConnectionListener.this.clientId, false);
                }
            });
        }
    }

    void disconnect(boolean notifyClient) {
        Utils.mustBeEventDispatchThread();
        this.disconnecting = true;
        this.server.putClientData(new ExitMessageBox(this.clientId));
        if (notifyClient) {
            this.sendData(new ExitMessage());
        }
        this.stopWriting();
        super.disconnect();
    }

    public void handleEx(Exception e, final boolean sendingEx) {
        if (!this.disconnecting) {
            this.disconnecting = true;
            Utils.invokeLater(new Runnable(){

                public final void run() {
                    if (ConnectionListener.this.clientId != null) {
                        ConnectionListener.this.server.removeClient(ConnectionListener.this.clientId, sendingEx ^ true);
                    } else {
                        ConnectionListener.this.stopWriting();
                        ConnectionListener.super.disconnect();
                    }
                }
            });
            if (e instanceof ClassNotFoundException) {
                Utils.invokeLater(new Runnable(){

                    public final void run() {
                        OptionDialog.show(ConnectionListener.this.server.getFrame(), "Login Failed", "An incompatible version of the HubNet Client tried logging in. Please ensure that everyone is using the version of the HubNet Client that came with this release, NetLogo 2.1.0", new String[]{"OK"});
                    }
                });
            } else if (!sendingEx) {
                Exceptions.handle(e);
            } else {
                System.err.println("@ " + new Date() + " : ");
                System.err.println("sending exception:\n" + e);
            }
        }
    }

    private final /* synthetic */ void this() {
        this.validClientVersion = false;
        this.disconnecting = false;
    }

    ConnectionListener(Socket socket, CompConnection server) throws IOException {
        super("ConnectionListener", socket);
        this.this();
        this.server = server;
    }
}

