/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import javax.swing.JFrame;
import org.nlogo.awt.Utils;
import org.nlogo.hubnet.HubNetManager;
import org.nlogo.hubnet.computer.protocol.DisableGraphics;
import org.nlogo.hubnet.computer.protocol.Text;
import org.nlogo.hubnet.computer.server.ClientsPanel;
import org.nlogo.hubnet.computer.server.CompConnection;
import org.nlogo.hubnet.computer.server.CompUtils;
import org.nlogo.hubnet.computer.server.MessagePanel;
import org.nlogo.hubnet.computer.server.ServerOptionsPanel;

strictfp class ControlCenter
extends JFrame {
    private CompConnection server;
    private ServerOptionsPanel serverOptionsPanel;
    private ClientsPanel clientsPanel;
    private MessagePanel messagePanel;

    void setDebug(boolean debug) {
        Utils.mustBeEventDispatchThread();
        HubNetManager.debug = debug;
    }

    void setGraphicsMirroring(boolean mirror) {
        Utils.mustBeEventDispatchThread();
        if (mirror != CompUtils.graphicsWindowMirroring) {
            CompUtils.graphicsWindowMirroring = mirror;
            if (mirror) {
                this.server.broadcastMessage(this.server.currentGraphicsWindowUpdate());
            } else {
                this.server.broadcastMessage(new DisableGraphics());
            }
        }
    }

    void setPlotMirroring(boolean mirror) {
        Utils.mustBeEventDispatchThread();
        CompUtils.plotMirroring = mirror;
    }

    void kickClient(String clientId) {
        Utils.mustBeEventDispatchThread();
        this.server.removeClient(clientId, true);
        this.clientsPanel.removeClientEntry(clientId);
    }

    void broadcastMessage(String messageString) {
        Utils.mustBeEventDispatchThread();
        Text message = new Text(messageString);
        this.server.broadcastMessage(message);
    }

    private final String getServerIPAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "UNKNOWN";
        }
    }

    void addClient(String clientId, SocketAddress remoteAddress) {
        Utils.mustBeEventDispatchThread();
        this.clientsPanel.addClientEntry(clientId);
        this.messagePanel.logMessage("'" + clientId + "' joined from: " + remoteAddress + '\n');
    }

    void clientDisconnect(String clientId) {
        Utils.mustBeEventDispatchThread();
        this.messagePanel.logMessage("'" + clientId + "' disconnected.\n");
        this.clientsPanel.removeClientEntry(clientId);
    }

    void launchNewClient() {
        this.server.getHubNetManager().newClient();
    }

    public void dispose() {
        Utils.mustBeEventDispatchThread();
        this.server.controlCenterOn = false;
        super.dispose();
    }

    ControlCenter(CompConnection server, Frame frame, String serverId, String activityName, Iterator clientIds) {
        super("HubNet Control Center");
        this.server = server;
        this.serverOptionsPanel = new ServerOptionsPanel(this, this.getServerIPAddress(), "" + server.getPortNumber(), activityName, serverId, CompUtils.graphicsWindowMirroring, CompUtils.plotMirroring, server.isDiscoveryEnabled(), HubNetManager.debug);
        this.clientsPanel = new ClientsPanel(this, clientIds);
        this.messagePanel = new MessagePanel(this);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.serverOptionsPanel, "Center");
        this.getContentPane().add((Component)this.clientsPanel, "East");
        this.getContentPane().add((Component)this.messagePanel, "South");
        this.pack();
        Utils.moveNextTo(this, frame);
        this.setVisible(true);
    }
}

