/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.nlogo.util.Exceptions;

public strictfp class DiscoveryMessage {
    public final String version;
    public final String uniqueId;
    public final String modelName;
    public final String portNumber;
    public final String hostName;
    public long creationTime;

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(this.version);
            dos.writeUTF(this.uniqueId);
            dos.writeUTF(this.modelName);
            dos.writeUTF(this.portNumber);
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
        return bos.toByteArray();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DiscoveryMessage)) {
            return false;
        }
        DiscoveryMessage dm = (DiscoveryMessage)obj;
        boolean bl = false;
        if (this.uniqueId.equals(dm.uniqueId) && this.modelName.equals(dm.modelName) && this.portNumber.equals(dm.portNumber) && this.version.equals(dm.version) && this.hostName.equals(dm.hostName)) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.uniqueId.hashCode() + this.modelName.hashCode() + this.portNumber.hashCode();
    }

    public String toString() {
        return super.toString() + ':' + this.uniqueId + '/' + this.modelName + '/' + this.portNumber + '/' + this.version + '/' + this.hostName;
    }

    public DiscoveryMessage(String uniqueId, String modelName, int portNumber) {
        this.version = "NetLogo 2.1.0";
        this.uniqueId = uniqueId;
        this.modelName = modelName;
        this.portNumber = "" + portNumber;
        this.hostName = null;
    }

    public DiscoveryMessage(String hostName, byte[] bytes) throws IOException {
        this.hostName = hostName;
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            this.version = dis.readUTF();
            if (!this.version.equals("NetLogo 2.1.0")) {
                throw new IOException("Cannot deserialize DiscoveryMessage: version mismatch");
            }
            this.uniqueId = dis.readUTF();
            this.modelName = dis.readUTF();
            this.portNumber = dis.readUTF();
        }
        catch (IOException ex) {
            throw new IOException("Cannot deserialize DiscoveryMessage: " + ex.getMessage());
        }
    }
}

