/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.computer.server;

import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.nlogo.hubnet.computer.server.ControlCenter;
import org.nlogo.swing.SelectableJLabel;
import org.nlogo.swing.TextFieldBox;

strictfp class ServerOptionsPanel
extends JPanel
implements ItemListener {
    private ControlCenter controlCenter;
    private JCheckBox mirrorGraphicsCheckBox;
    private JCheckBox mirrorPlotsCheckBox;
    private JCheckBox debugCheckBox;

    public void itemStateChanged(ItemEvent e) {
        this.controlCenter.setGraphicsMirroring(this.mirrorGraphicsCheckBox.isSelected());
        this.controlCenter.setPlotMirroring(this.mirrorPlotsCheckBox.isSelected());
        this.controlCenter.setDebug(this.debugCheckBox.isSelected());
    }

    public ServerOptionsPanel(ControlCenter controlCenter, String server, String portNumber, String activityName, String serverId, boolean mirrorGraphics, boolean mirrorPlots, boolean discoveryEnabled, boolean debug) {
        this.controlCenter = controlCenter;
        this.mirrorGraphicsCheckBox = new JCheckBox("Mirror graphics on clients", mirrorGraphics);
        this.mirrorPlotsCheckBox = new JCheckBox("Mirror plots on clients (experimental)", mirrorPlots);
        this.debugCheckBox = new JCheckBox("Debug", debug);
        JCheckBox discoveryEnabledCheckBox = new JCheckBox("Broadcast server address", discoveryEnabled);
        discoveryEnabledCheckBox.setEnabled(false);
        this.mirrorGraphicsCheckBox.addItemListener(this);
        this.mirrorPlotsCheckBox.addItemListener(this);
        this.debugCheckBox.addItemListener(this);
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setLayout(new BoxLayout(this, 1));
        Font f = new JLabel().getFont().deriveFont(1);
        TextFieldBox tfb = new TextFieldBox(4, null, f);
        tfb.addField("Name:", new SelectableJLabel(serverId));
        tfb.addField("Activity:", new SelectableJLabel(activityName));
        tfb.add(Box.createVerticalStrut(12));
        tfb.addField("Server address:", new SelectableJLabel(server));
        tfb.addField("Port number:", new SelectableJLabel(portNumber));
        this.add(tfb);
        this.add(Box.createVerticalStrut(30));
        this.add(new JLabel("Settings:"));
        this.add(Box.createVerticalStrut(4));
        this.add(this.mirrorGraphicsCheckBox);
        this.add(this.mirrorPlotsCheckBox);
        this.add(discoveryEnabledCheckBox);
        this.add(this.debugCheckBox);
        this.add(Box.createVerticalGlue());
    }
}

