/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab;

import java.util.Iterator;
import java.util.Map;
import org.nlogo.agent.World;
import org.nlogo.compiler.CompilerException;
import org.nlogo.lab.Experiment;
import org.nlogo.lab.ProgressListener;
import org.nlogo.lab.Protocol;
import org.nlogo.lab.Run;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class Worker
extends Thread {
    public final Experiment experiment;
    public final Workspace workspace;
    public ProgressListener progressListener;
    public boolean aborted;
    public Throwable throwable;

    public void run() {
        try {
            Protocol.CombinationsIterator iter = this.experiment.protocol.iterator();
            while (iter.hasNext()) {
                this.doOneRun((Map)iter.next());
                if (!this.aborted && !this.isInterrupted()) continue;
                return;
            }
        }
        catch (CompilerException ex) {
            this.throwable = ex;
        }
        catch (FailedException ex) {
            this.throwable = ex;
        }
        catch (Throwable t) {
            this.throwable = t;
        }
    }

    private final void doOneRun(Map variableValues) throws CompilerException, FailedException {
        Run run = new Run(variableValues);
        this.setVariables(variableValues);
        if (this.progressListener != null) {
            this.progressListener.runStarted(run);
        }
        this.setup();
        run.measurements.add(this.metric());
        if (this.progressListener != null) {
            this.progressListener.tickCompleted(run);
        }
        while (!this.done(run)) {
            ++run.ticks;
            this.go();
            run.measurements.add(this.metric());
            this.workspace.updateDisplay(false);
            if (this.progressListener != null) {
                this.progressListener.tickCompleted(run);
            }
            if (!this.aborted && !this.isInterrupted()) continue;
            return;
        }
        this.experiment.runs.add(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setVariables(Map variableValues) {
        Iterator iter = variableValues.keySet().iterator();
        while (iter.hasNext()) {
            String variableName = (String)iter.next();
            World world = this.workspace.world;
            synchronized (world) {
                this.workspace.world.setObserverVariableByName(variableName, variableValues.get(variableName));
            }
        }
    }

    private final void setup() throws CompilerException {
        this.workspace.evaluator.evaluateCommands(this.experiment.protocol.setupCommands, this.workspace.world.observer(), true);
    }

    private final boolean done(Run run) throws CompilerException, FailedException {
        if (this.experiment.protocol.hasTimeLimit && run.ticks == this.experiment.protocol.timeLimit) {
            return true;
        }
        if (this.experiment.protocol.hasExitCondition) {
            Boolean result = (Boolean)this.workspace.evaluator.evaluateReporter(this.experiment.protocol.exitCondition, this.workspace.world.observer());
            if (result == null) {
                throw new FailedException("Stopping condition failed to report a result:\n" + this.experiment.protocol.exitCondition);
            }
            return result;
        }
        return false;
    }

    private final void go() throws CompilerException {
        this.workspace.evaluator.evaluateCommands(this.experiment.protocol.goCommands, this.workspace.world.observer(), true);
    }

    private final Object metric() throws CompilerException, FailedException {
        Object result = this.workspace.evaluator.evaluateReporter(this.experiment.protocol.metric, this.workspace.world.observer());
        if (result == null) {
            throw new FailedException("Reporter for measuring runs failed to report a result:\n" + this.experiment.protocol.metric);
        }
        return result;
    }

    private final /* synthetic */ void this() {
        this.aborted = false;
    }

    public Worker(Experiment experiment, Workspace workspace) {
        this.this();
        this.experiment = experiment;
        this.workspace = workspace;
    }

    public static class FailedException
    extends Exception {
        FailedException(String message) {
            super(message);
        }
    }
}

