/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;
import org.nlogo.agent.Dump;
import org.nlogo.awt.ColumnLayout;
import org.nlogo.awt.Utils;
import org.nlogo.lab.ProgressListener;
import org.nlogo.lab.Run;
import org.nlogo.lab.gui.Supervisor;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.graphing.GraphManager;
import org.nlogo.window.graphing.GraphWidget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class ProgressDialog
extends JDialog
implements ProgressListener {
    private final Supervisor supervisor;
    private final int totalRuns;
    private Run currentRun;
    private JTextArea progressArea;
    private Timer timer;
    private GraphManager graphManager;
    private GraphWidget progressPlot;
    private final Action abortAction;
    private final Action periodicUpdateAction;
    private final Action displaySwitchAction;
    private final Action plotsAndMonitorsSwitchAction;
    private boolean updatePlots;
    private final long started;
    private int runCount;
    private String elapsed;
    private String settings;
    private int ticks;

    void close() {
        Utils.mustBeEventDispatchThread();
        this.timer.stop();
        this.setVisible(false);
        this.dispose();
        ((GUIWorkspace)this.supervisor.worker.workspace).displaySwitchOn(true);
        ((GUIWorkspace)this.supervisor.worker.workspace).setPeriodicUpdatesEnabled(true);
    }

    public void runStarted(Run run) {
        this.currentRun = run;
        ++this.runCount;
        this.resetPlot();
        this.settings = "";
        Iterator iter = run.variableValues.keySet().iterator();
        while (iter.hasNext()) {
            String variableName = (String)iter.next();
            this.settings = this.settings + variableName + " = " + Dump.logoObject(run.variableValues.get(variableName)) + '\n';
        }
        this.updateProgressArea(true);
    }

    public void tickCompleted(Run run) {
        this.plotNextPoint(run);
    }

    private final void resetPlot() {
        try {
            Utils.invokeAndWait(new Runnable(){

                public final void run() {
                    ProgressDialog.this.progressPlot.resetPen(true);
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.ignore(ex);
        }
    }

    private final void plotNextPoint(final Run run) {
        try {
            Utils.invokeAndWait(new Runnable(){

                public final void run() {
                    Object measurement = run.measurements.get(run.measurements.size() - 1);
                    if (measurement instanceof Number) {
                        ProgressDialog.this.progressPlot.plot(((Number)measurement).doubleValue());
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.ignore(ex);
        }
    }

    private final void updateProgressArea(boolean force) {
        int elapsedMillis = (int)((System.currentTimeMillis() - this.started) / 1000L);
        String hours = Integer.toString(elapsedMillis / 3600);
        String minutes = Integer.toString(elapsedMillis % 3600 / 60);
        String seconds = Integer.toString(elapsedMillis % 60);
        if (minutes.length() == 1) {
            minutes = "0" + minutes;
        }
        if (seconds.length() == 1) {
            seconds = "0" + seconds;
        }
        String newElapsed = hours + ':' + minutes + ':' + seconds;
        if (this.currentRun != null) {
            this.ticks = this.currentRun.ticks;
        }
        if (force || !this.elapsed.equals(newElapsed)) {
            this.elapsed = newElapsed;
            this.progressArea.setText("Run #" + this.runCount + " of " + this.totalRuns + ", tick #" + this.ticks + "\nTotal elapsed time: " + this.elapsed + '\n' + this.settings);
        }
    }

    private final /* synthetic */ void this() {
        this.graphManager = new GraphManager();
        this.progressPlot = this.graphManager.createGraph("Behavior Plot", true);
        this.abortAction = new AbstractAction("Abort"){

            public final void actionPerformed(ActionEvent e) {
                Utils.mustBeEventDispatchThread();
                String message = "Do you really want to abort this experiment? The results so far will be lost.";
                if (OptionDialog.show(ProgressDialog.this, "Confirm Abort of Experiment", message, new String[]{"Abort", "Cancel"}) == 0) {
                    ProgressDialog.this.supervisor.interrupt();
                    ProgressDialog.this.close();
                }
            }
        };
        this.periodicUpdateAction = new AbstractAction("update elapsed time"){

            public final void actionPerformed(ActionEvent e) {
                ProgressDialog.this.updateProgressArea(false);
                if (ProgressDialog.this.updatePlots) {
                    ProgressDialog.this.progressPlot.handlePeriodicUpdateEvent(null);
                }
            }
        };
        this.displaySwitchAction = new AbstractAction("Update graphics"){

            public final void actionPerformed(ActionEvent e) {
                ((GUIWorkspace)((ProgressDialog)ProgressDialog.this).supervisor.worker.workspace).displaySwitchOn(((JCheckBox)e.getSource()).isSelected());
            }
        };
        this.plotsAndMonitorsSwitchAction = new AbstractAction("Update plots and monitors"){

            public final void actionPerformed(ActionEvent e) {
                ProgressDialog.this.updatePlots = ((JCheckBox)e.getSource()).isSelected();
                if (ProgressDialog.this.updatePlots) {
                    ((GUIWorkspace)((ProgressDialog)ProgressDialog.this).supervisor.worker.workspace).setPeriodicUpdatesEnabled(true);
                } else {
                    ((GUIWorkspace)((ProgressDialog)ProgressDialog.this).supervisor.worker.workspace).setPeriodicUpdatesEnabled(false);
                    ((GUIWorkspace)((ProgressDialog)ProgressDialog.this).supervisor.worker.workspace).jobManager.finishSecondaryJobs(null);
                }
            }
        };
        this.updatePlots = true;
        this.started = System.currentTimeMillis();
        this.runCount = 0;
        this.elapsed = "0:00:00";
        this.settings = "";
        this.ticks = 0;
    }

    ProgressDialog(Frame frame, Supervisor supervisor) {
        super(frame, true);
        this.this();
        Utils.mustBeEventDispatchThread();
        this.supervisor = supervisor;
        this.totalRuns = supervisor.worker.experiment.protocol.countRuns();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                ProgressDialog.this.abortAction.actionPerformed(null);
            }
        });
        this.setTitle("Running Experiment");
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new ColumnLayout(5));
        JCheckBox displaySwitch = new JCheckBox(this.displaySwitchAction);
        displaySwitch.setSelected(true);
        ((GUIWorkspace)supervisor.worker.workspace).displaySwitchOn(true);
        JCheckBox plotsAndMonitorsSwitch = new JCheckBox(this.plotsAndMonitorsSwitchAction);
        plotsAndMonitorsSwitch.setSelected(true);
        southPanel.add(displaySwitch);
        southPanel.add(plotsAndMonitorsSwitch);
        southPanel.add((Component)new ButtonPanel(new JButton[]{new JButton(this.abortAction)}), "South");
        this.getContentPane().add((Component)southPanel, "South");
        this.progressPlot.defaultXMin(0.0);
        this.progressPlot.defaultYMin(0.0);
        this.progressPlot.defaultXMax(1.0);
        this.progressPlot.defaultYMax(1.0);
        this.progressPlot.defaultAutoPlotOn(true);
        this.progressPlot.xLabel("Time");
        this.progressPlot.yLabel("Behavior");
        this.progressPlot.clear();
        this.getContentPane().add((Component)this.progressPlot, "North");
        this.progressArea = new JTextArea(10, 40);
        this.progressArea.setEditable(false);
        this.getContentPane().add((Component)this.progressArea, "Center");
        this.updateProgressArea(true);
        this.timer = new Timer(200, this.periodicUpdateAction);
        this.timer.start();
        this.pack();
        Utils.center(this, frame);
    }
}

