/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.nlogo.agent.Dump;
import org.nlogo.agent.LogoList;
import org.nlogo.agent.World;
import org.nlogo.compiler.Compiler;
import org.nlogo.compiler.CompilerException;
import org.nlogo.lab.Protocol;
import org.nlogo.lab.ValueSet;
import org.nlogo.util.Exceptions;
import org.nlogo.window.Editable;
import org.nlogo.window.PropertyDescription;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class ProtocolEditable
implements Editable {
    private final Protocol protocol;
    private final Workspace workspace;
    private String valueSetsString;

    public String classDisplayName() {
        return "Experiment Setup";
    }

    public List propertySet() {
        ArrayList<PropertyDescription> properties = new ArrayList<PropertyDescription>();
        properties.add(new PropertyDescription("valueSetsString", "Vary variables as follows", "<html>Either list values to use, for example:<br>  [\"my-slider\" 1 2 7 8]<br>or specify start, step, and end, for example:<br>  [\"my-slider\" [0 1 10]]<br>to step from 0, 1 at a time, to 10</html>", "Reporter", 0, true));
        properties.add(new PropertyDescription("repetitions", "Run each combination this many times:", "Integer", 0, false));
        properties.add(new PropertyDescription("metric", "Measure runs using this reporter:", "Reporter", 0, false));
        properties.add(new PropertyDescription("setupCommands", "Set up model with these commands:", "Commands", 0, false));
        properties.add(new PropertyDescription("goCommands", "Step model with these commands:", "Commands", 0, false));
        properties.add(new PropertyDescription("timeLimit", "Stop after this many steps (0 = no limit):", "Integer", 0, false));
        properties.add(new PropertyDescription("exitCondition", "Stop if this reporter becomes true:", "Reporter", 0, false));
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void editFinished() {
        boolean bl = false;
        if (this.protocol.timeLimit > 0) {
            bl = true;
        }
        this.protocol.hasTimeLimit = bl;
        this.protocol.hasExitCondition = this.protocol.exitCondition.trim().equals("false") ^ true;
        this.protocol.valueSets = new LinkedHashMap();
        LogoList list = new LogoList();
        try {
            World world = this.workspace.world;
            synchronized (world) {
                list = (LogoList)Compiler.readFromString("[" + this.valueSetsString + ']', this.workspace.world);
            }
        }
        catch (CompilerException ex) {
            Exceptions.handle(ex);
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            LogoList sublist = (LogoList)iter.next();
            String variableName = (String)sublist.get(0);
            ValueSet valueSet = new ValueSet();
            if (sublist.get(1) instanceof LogoList) {
                LogoList subsublist = (LogoList)sublist.get(1);
                valueSet.isStepped = true;
                valueSet.first = (Number)subsublist.get(0);
                valueSet.step = (Number)subsublist.get(1);
                valueSet.last = (Number)subsublist.get(2);
                this.protocol.valueSets.put(variableName, valueSet);
                continue;
            }
            valueSet.isEnumerated = true;
            valueSet.values = new ArrayList(sublist);
            valueSet.values.remove(0);
            this.protocol.valueSets.put(variableName, valueSet);
        }
    }

    public String valueSetsString() {
        return this.valueSetsString;
    }

    public void valueSetsString(String valueSetsString) {
        this.valueSetsString = valueSetsString;
    }

    public int repetitions() {
        return this.protocol.repetitions;
    }

    public void repetitions(int repetitions) {
        this.protocol.repetitions = repetitions;
    }

    public String setupCommands() {
        return this.protocol.setupCommands;
    }

    public void setupCommands(String setupCommands) {
        this.protocol.setupCommands = setupCommands;
    }

    public String goCommands() {
        return this.protocol.goCommands;
    }

    public void goCommands(String goCommands) {
        this.protocol.goCommands = goCommands;
    }

    public String metric() {
        return this.protocol.metric;
    }

    public void metric(String metric) {
        this.protocol.metric = metric;
    }

    public int timeLimit() {
        return this.protocol.timeLimit;
    }

    public void timeLimit(int timeLimit) {
        this.protocol.timeLimit = timeLimit;
    }

    public String exitCondition() {
        return this.protocol.exitCondition;
    }

    public void exitCondition(String exitCondition) {
        this.protocol.exitCondition = exitCondition;
    }

    private final /* synthetic */ void this() {
        this.valueSetsString = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ProtocolEditable(Protocol protocol, Workspace workspace) {
        super();
        this.this();
        this.protocol = protocol;
        this.workspace = workspace;
        if (protocol.valueSets.isEmpty()) {
            var3_3 = workspace.world;
            synchronized (var3_3) {
                iter = workspace.world.program().interfaceGlobals.iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        return;
                    }
                    variableName = (String)iter.next();
                    this.valueSetsString = this.valueSetsString + "[\"" + variableName + "\" " + Dump.logoObject(workspace.world.getObserverVariableByName(variableName), true, false) + "]\n";
                }
            }
        }
        iter = protocol.valueSets.keySet().iterator();
        while (iter.hasNext()) {
            block9: {
                block8: {
                    variableName = (String)iter.next();
                    valueSet = (ValueSet)protocol.valueSets.get(variableName);
                    this.valueSetsString = this.valueSetsString + "[\"" + variableName + '\"';
                    if (!valueSet.isEnumerated) break block8;
                    iter2 = valueSet.iterator();
                    if (true) ** GOTO lbl33
                }
                if (valueSet.isStepped == false) throw new IllegalStateException();
                this.valueSetsString = this.valueSetsString + " [" + valueSet.first + ' ' + valueSet.step + ' ' + valueSet.last + ']';
                break block9;
                do {
                    this.valueSetsString = this.valueSetsString + ' ' + Dump.logoObject(iter2.next());
lbl33:
                    // 2 sources

                } while (iter2.hasNext());
            }
            this.valueSetsString = this.valueSetsString + "]\n";
        }
    }
}

